package com.cloud.hisavana.sdk.common.gsonutil;

import com.google.gson.Gson;

import java.lang.reflect.Type;

/**
 * @author xinbing.zhang
 * @date :2021/12/8 3:02 下午
 * @description:
 */
public class GsonUtil {

    /**
     * 全局统一输出
     */
    public static Gson getGson() {
        //return new Gson();
        return GsonFactory.getSingletonGson();
    }

    /**
     * 数据解析
     */
    public static <T> T fromJson(String json, Class<T> classOfT) {
        return getGson().fromJson(json, classOfT);
    }

    public static <T> T fromJson(String json, Type typeOfT) {
        return getGson().fromJson(json, typeOfT);
    }

    public static String toJson(Object ob) {
        return getGson().toJson(ob);
    }

}
