package com.cloud.hisavana.sdk.common.tranmeasure;

import static com.cloud.hisavana.sdk.common.util.AdLogUtil.MEASURE_TAG;

import android.view.View;

import com.cloud.hisavana.sdk.api.config.SspAd;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.tracking.ADExposureManager;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;

import java.lang.ref.WeakReference;


/**
 * 封装了一下 需要 监控的 行为
 */
public class MeasureSession<T> {

    /**
     * 数据 --> 绑定在需要监控的View上的数据
     */
    private T mKey;

    protected AdImpressionListener<T> mImpressionListener;
    private WeakReference<View> mAdView;
    private boolean mIsImpression = false;
    protected MeasureInfo mMeasureInfo;
    private boolean mIsAdValid = true;

    /**
     * 广告所在的Activity 生命周期 是否是 stop 标识
     */
    private boolean isStop = false;

    public boolean isStop() {
        return isStop;
    }

    public void setStop(boolean stop) {
        isStop = stop;
    }

    /**
     * 这个才是用来监控的实际操作者
     */
    private ImpressionValidChecker mImpressionValidChecker = null;


    // =============================================================================================


    public MeasureSession(T key) {
        mMeasureInfo = new MeasureInfo();
        mMeasureInfo.minImpressionTime = 1000;
        mMeasureInfo.minVisiblePercent = 50;
        mMeasureInfo.minVisiblePx = 0;
        this.mKey = key;
        mImpressionValidChecker = new ImpressionValidChecker(this);
    }

    /**
     * 注册一个需要监控的行为
     *
     * @param adView    目标View
     * @param listener  回调
     */
    public void registerView(View adView, AdImpressionListener<T> listener) {
        AdLogUtil.Log().d(MEASURE_TAG,"MeasureSession registerView,isImpression = " + mIsImpression);
        if (!mIsImpression) {
            mAdView = new WeakReference<>(adView);
            mImpressionListener = listener;
            MeasureSessionManager.getInstance().registerSession(this);
            //1.3.0展现时上报
            if (mKey instanceof AdsDTO) {
                AdsDTO info = (AdsDTO) mKey;{
                    info.setShowReportTimeType(Constants.SHOW_REPORT_TIME_TYPE.TYPE_SHOW);
                    ADExposureManager.exposureInvalid(info);
                }
            }

            //1.3.0广告展示就回调给聚合onAdShow
            if(mImpressionListener != null) {
                if (mKey instanceof AdsDTO && mAdView.get() != null){
                    ((AdsDTO)mKey).setImageWidth(mAdView.get().getMeasuredWidth());
                    ((AdsDTO)mKey).setImageHeight(mAdView.get().getMeasuredHeight());
                }
                // 成功回调
                mImpressionListener.onViewImpressed(mKey);

                //展示过就不在检测展示
                mIsImpression = true;
                AdLogUtil.Log().d(MEASURE_TAG,"trigger the impression event  mIsImpression = true;");
            }


        }

        // 开关控制
        if (SspAd.isOptimizedMeasure() && null != mAdView.get()){
            // 监听 View的状态 主要是解决 RecyclerView 的列表滑动 Activity的decorView检测不到AdView
            mAdView.get().addOnAttachStateChangeListener(new View.OnAttachStateChangeListener() {
                @Override
                public void onViewAttachedToWindow(View v) {
                    isStop = false;
                    AdLogUtil.Log().d(MEASURE_TAG," --> onViewAttachedToWindow isStop = false;");
                    Monitor.getInstance().start();
                }

                @Override
                public void onViewDetachedFromWindow(View v) {
                    isStop = true;
                    AdLogUtil.Log().d(MEASURE_TAG," --> onViewDetachedFromWindow isStop = true;");
                }
            });
        }

    }

    /**
     * 是否是同一个对象
     */
    protected boolean isHit(T key) {
        return mKey == key;
    }

    public void setAdValid(boolean isAdValid){
        this.mIsAdValid = isAdValid;
    }
    public boolean getAdValid(){
        return mIsAdValid;
    }

    /**
     * 监控的目标View
     */
    protected View getAdView() {
        if (mAdView != null) {
            return mAdView.get();
        }
        return null;
    }


    /**
     * 结束监控行为
     */
    public void finish() {
        if (mAdView != null) {
            mAdView.clear();
        }

        if (null!= mImpressionValidChecker){
            mImpressionValidChecker.beforeFinish2Impression();
        }

        // 取消注册
        MeasureSessionManager.getInstance().unregisterSession(this);
    }

    /**
     * 测量 --> 最后都是分发到这里处理的
     */
    protected void measure() {
        mImpressionValidChecker.checkValid();
    }

    /**
     * 返回数据类
     */
    protected T getmKey() {
        return mKey;
    }


    // =============================================================================================


    /**
     * 达到要求的时候的回调
     */
    public interface AdImpressionListener<T> {
        void onViewImpressed(T key);
    }
}
