package com.cloud.hisavana.sdk.internal.interstitial;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.text.TextUtils;

import com.cloud.hisavana.sdk.common.activity.TAdInterstitialActivity;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.ImageDownloadHelper;
import com.transsion.core.CoreUtil;

import java.lang.ref.WeakReference;

/**
 * Created by jianbing.yu on 2019/3/27.
 */
public class InterstitialGemini {

    private InterstitialAdBroadcastReceiver receiver;
    private TranInterstitial mInterstitial;
    private AdsDTO mAdBean;


    // =============================================================================================


    public InterstitialGemini(TranInterstitial interstitial) {
        this.mInterstitial = interstitial;
    }

    /**
     * 插屏广告是一个独立的Activity 这里用广播通讯
     */
    private static class InterstitialAdBroadcastReceiver extends BroadcastReceiver {

        private WeakReference<InterstitialGemini> weakReference;
        private WeakReference<AdListener> listener;

        InterstitialAdBroadcastReceiver(InterstitialGemini gemini, AdListener tAdListener) {
            weakReference = new WeakReference<>(gemini);
            listener = new WeakReference<>(tAdListener);
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent != null) {
                String action = intent.getAction();
                if (action == null) {
                    return;
                }
                InterstitialGemini gemini = weakReference.get();
                if (gemini != null) {
                    if (action.equals(gemini.getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_CLICK)) {
                        AdLogUtil.Log().d(AdLogUtil.TAG,"receive interstitial click");
                        if (weakReference.get() != null) {
                            DownUpPointBean pointBean = (DownUpPointBean) intent.getSerializableExtra("pointBean");
                            weakReference.get().clickToLandingPage(pointBean);
                        }

                        if (listener.get() != null) {
                            DownUpPointBean pointBean = (DownUpPointBean) intent.getSerializableExtra("pointBean");
                            listener.get().onAdClicked(pointBean);
                        }

                    } else if (action.equals(gemini.getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_CLOSE)) {
                        AdLogUtil.Log().d(AdLogUtil.TAG,"receive interstitial ad_close");
                        if (listener.get() != null) {
                            listener.get().onAdClosed();
                            gemini.unRegisterInterstitalAdReceiver();
                            gemini.receiver = null;
                        }
                    } else if (action.equals(gemini.getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_ERROR)) {
                        AdLogUtil.Log().d(AdLogUtil.TAG,"receive interstitial error");
                        if (listener.get() != null) {
                            listener.get().onError(new TaErrorCode(intent.getIntExtra(TAdInterstitialActivity.ERROR_CODE, TaErrorCode.UNKNOWN_ERROR_CODE_2),
                                    intent.getStringExtra(TAdInterstitialActivity.ERROR_MSG)));
                        }
                        gemini.unRegisterInterstitalAdReceiver();
                        gemini.receiver = null;
                    } else if (action.equals(gemini.getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_SHOW)) {
                        AdLogUtil.Log().d(AdLogUtil.TAG,"receive interstitial show");
                        //gemini.mInterstitial.polyInterstitial().impressionTrack(gemini.mAdBean);
                    } else if (action.equals(gemini.getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_PREIMP)) {
                        AdLogUtil.Log().d(AdLogUtil.TAG,"receive interstitial pre impression");
                    } else if (action.equals(gemini.getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_ADCHOICE_CLICK)) {
                        AdLogUtil.Log().d(AdLogUtil.TAG,"receive interstitial adchocie click");
                        if (listener.get() != null) listener.get().onAdChoiceClick();
                    }
                }
            }
        }
    }

    private void clickToLandingPage(DownUpPointBean pointBean) {
        mInterstitial.polyInterstitial().startLandingPage(CoreUtil.getContext(), mAdBean, pointBean);
    }

    public void loadAd() {
        mAdBean = mInterstitial.adBean();
        if (mAdBean != null) {
            //图片插屏 1.5 版本之后 取值调整 加载主图片
            if (!TextUtils.isEmpty(mAdBean.getAdImgUrl())) {
                AdLogUtil.Log().d(AdLogUtil.TAG,"imageView impression");
                ImageDownloadHelper.downloadImage(mAdBean.getAdImgUrl(),
                        Constants.ImageLoadType.IMAGE_DISK_INCLUDED, mAdBean,
                        AthenaTracker.M_TYPE_LARGE_IMG, new ImageDownloadHelper.ImageListener() {

                            @Override
                            public void onImagesCached(byte[] data) {
                                if (mInterstitial.adListener() != null) {
                                    mInterstitial.adListener().onAdLoaded();
                                }
                            }

                            @Override
                            public void onImagesFailedToCache(TaErrorCode errorCode) {
                                if (mInterstitial.adListener() != null) {
                                    mInterstitial.adListener().onError(errorCode);
                                }
                            }
                        });
            } else {
                if (mInterstitial.adListener() != null) {
                    mInterstitial.adListener().onError(TaErrorCode.INVALID_CRVT_TYPE);
                }
            }
        } else {
            if (mInterstitial.adListener() != null) {
                mInterstitial.adListener().onError(new TaErrorCode(TaErrorCode.UNKNOWN_ERROR_CODE_2, "mAdBean is null"));
            }
        }
    }

    public void show() {
        if (mAdBean != null) {

            if (receiver == null) {
                receiver = new InterstitialAdBroadcastReceiver(InterstitialGemini.this, mInterstitial.adListener());
            }
            registerInterstitialAdReceiver();

            // 1.5版本新增 广告位类型
            Intent intent = new Intent(CoreUtil.getContext(), TAdInterstitialActivity.class);

            intent.setFlags(Intent.FLAG_ACTIVITY_NO_ANIMATION | Intent.FLAG_ACTIVITY_NEW_TASK);
            intent.putExtra("mAdBean", mAdBean);
            intent.putExtra("BroadCastPrefix",getBroadCastPrefix());
            CoreUtil.getContext().startActivity(intent);
        } else {
            AdLogUtil.Log().d(AdLogUtil.TAG,"show() --> mAdBean == null");
        }
    }

    private void registerInterstitialAdReceiver() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_CLICK);
        intentFilter.addAction(getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_CLOSE);
        intentFilter.addAction(getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_SHOW);
        intentFilter.addAction(getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_PREIMP);
        intentFilter.addAction(getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_ERROR);
        intentFilter.addAction(getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_ADCHOICE_CLICK);
        CoreUtil.getContext().registerReceiver(receiver, intentFilter);
        AdLogUtil.Log().d(AdLogUtil.TAG,"registerInterstitialAdReceiver");
    }

    public void destroy() {
        unRegisterInterstitalAdReceiver();
        AdLogUtil.Log().d(AdLogUtil.TAG,"destroy");
    }

    private String getBroadCastPrefix() {
        return mInterstitial.polyInterstitial().getBroadCastPrefix(mAdBean);
    }

    private void unRegisterInterstitalAdReceiver() {
        if (receiver != null) {
            CoreUtil.getContext().unregisterReceiver(receiver);
            receiver = null;
        }
    }
}
