package com.cloud.hisavana.sdk.api.listener;

/**
 * @author peng.sun
 * @data 2017/7/5
 * ========================================
 * CopyRight (c) 2017 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class TaRequest {

    private AdListener mListener = null;
    private int scheduleTime = 0;

    public TaRequest(TaRequestBuild TAdRequestBuild) {
        this.mListener = TAdRequestBuild.mListener;
        this.scheduleTime = TAdRequestBuild.scheduleTime;
    }

    public AdListener getListener() {
        return mListener;
    }

    public int getScheduleTime() {
        return scheduleTime;
    }

    @Override
    public String toString() {
        return "TaRequest{" +
                "mListener=" + mListener +
                ", scheduleTime=" + scheduleTime +
                '}';
    }

    /**
     * 构造类
     */
    public static class TaRequestBuild {
        private AdListener mListener = null;
        private int scheduleTime = 60 * 1000;//default 60s

        public TaRequestBuild setListener(AdListener mListener) {
            this.mListener = mListener;
            return this;
        }

        public TaRequestBuild setScheduleTime(int scheduleTime) {
            this.scheduleTime = scheduleTime;
            return this;
        }

        public TaRequest build() {
            return new TaRequest(this);
        }

        @Override
        public String toString() {
            return "TAdRequestBuild{" +
                    "mListener=" + mListener +
                    ", scheduleTime=" + scheduleTime +
                    '}';
        }
    }
}
