package com.cloud.hisavana.sdk.common.athena;

import static com.cloud.hisavana.sdk.common.util.AdLogUtil.TAG;

import android.os.Bundle;

import com.cloud.hisavana.sdk.BuildConfig;
import com.cloud.hisavana.sdk.api.config.SspAd;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.gsonutil.GsonUtil;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.DeviceUtil;
import com.cloud.hisavana.sdk.common.util.GPSTracker;
import com.cloud.hisavana.sdk.data.bean.request.AdxImpBean;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.transsion.athenacust.AthenaCust;

/**
 * Created by wenjing.luo on 2022/3/2.
 */

public class AthenaTrackerInvoker{
    /**
     * @return 获取公参
     */
    public static Bundle getBundle(Bundle bundle) {
        long start = 0;
        if (BuildConfig.DEBUG) {
            start = System.currentTimeMillis();
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.putString("session_id", PostConstant.getSessionId());
        bundle.putString("sdk_version", PostConstant.getSdkVersion());
        bundle.putString("user_agent", PostConstant.getUserAgent());
        bundle.putInt("type", PostConstant.getType());
        bundle.putString("make", PostConstant.getMake());
        bundle.putString("ostype", "Android");

        bundle.putString("imei_sha1", PostConstant.getImeiSha1());
        bundle.putString("imei_md5", PostConstant.getImeiMd5());
        bundle.putString("androidId_sha1", PostConstant.getAndroidIdSha1());
        bundle.putString("androidId_md5", PostConstant.getAndroidIdMd5());

        bundle.putInt("screen_width", PostConstant.getScreenWidth());
        bundle.putInt("screen_height", PostConstant.getScreenHeight());
        bundle.putInt("screen_density", PostConstant.getScreenDensity());

        bundle.putString("base_station", DeviceUtil.getGsmCellLocation());
        bundle.putDouble("latitude", GPSTracker.getLatitude());
        bundle.putDouble("longitude", GPSTracker.getLongitude());
        bundle.putLong("coordtime", GPSTracker.getCoordTime());

        bundle.putString("imsi", PostConstant.getImsi());
        bundle.putString("mac", PostConstant.getMac());

        if (BuildConfig.DEBUG) {
            AdLogUtil.Log().d("","AthenaTracker getBundle time = " + (System.currentTimeMillis() - start)+" bundle = "+bundle.toString());
        }
        return bundle;
    }

    /**
     * ad_ssp_show上报
     * @param info
     */
    public static void trackShow(AdsDTO info) {
        AdLogUtil.Log().d(TAG, "currentThread().getId()" + Thread.currentThread().getId());
        Bundle bundle = new Bundle();
        bundle.putDouble("price", info.getFirstPrice());
        //20220117 二价扣费
        bundle.putString("new_price", info.getNewPrice());
        //推广应用安装状态 1.非下载类广告 2. 已安装目标下载应用 3.未安装目标下载应用"
        bundle.putInt("popularize_app_install_status", info.getInstallApk());
        //曝光时长
        bundle.putLong("show_duration", info.getActualShowTime());
        //曝光面积
        bundle.putString("show_area", info.getShowArea());
        //展现上报时机类型1. 展现时上报 2. 达标时上报 3. 离开时上报
        bundle.putLong("show_report_time_type", info.getShowReportTimeType());
        //广告下发的deeplink
        bundle.putString("deep_link_url", info.getDeepLinkUrl());
        new AthenaCust(PostConstant.EVENT, PostConstant.TID).trackCommon(fillAdParamsToBundleForShowAndDeeplink(info,bundle), null).submit();
    }
    /**
     * deeplink应用拉起成功上报
     * @param info
     */
    public static void trackDeeplink(AdsDTO info) {
        Bundle bundle = new Bundle();
        //成功拉起的deeplink链接
        bundle.putString("deep_link_url", info.getDeepLinkUrlFirst());
        new AthenaCust(PostConstant.EVENT_DEEPLINK, PostConstant.TID).trackCommon(fillAdParamsToBundleForShowAndDeeplink(info,bundle), null).submit();
    }
    /**
     * ad_ssp_show和deeplink共有的埋点参数设置
     * @param info
     * @param params
     * @return
     */
    private static Bundle fillAdParamsToBundleForShowAndDeeplink(AdsDTO info, Bundle params) {
        //公参 SDK自行上报
        Bundle bundle = getBundle(params);

        //事件参数
        bundle.putString("request_id", info.getRid());
        bundle.putString("code_seat_id", info.getCodeSeatId());
        bundle.putInt("code_seat_type", info.getCodeSeatType());
        bundle.putInt("cache_time", info.getCacheTime());//缓存时长：开屏-4、其他-1 （小时）
        bundle.putInt("id", info.getId());
        bundle.putLong("advertiser_id", info.getAdvertiserId());//广告主id
        bundle.putLong("plan_id", info.getPlanId());//计划id
        bundle.putLong("ad_group_id", info.getAdGroupId());//广告组id
        bundle.putLong("ad_creative_id", info.getAdCreativeId());//广告创意id
        bundle.putString("package_name", info.getPackageName());
        bundle.putString("click_url", info.getClickUrl());
        bundle.putString("tracking_secret_key", info.getShowTrackingSecretKey());//曝光加密串
        bundle.putString("default_ad_expiration_time", info.getDefaultAdExpirationTime());
        bundle.putInt("default_ad_show_count", info.getDefaultAdShowCount());
        bundle.putInt("is_default_ad_first_show", info.getIsDefaultAdFirstShow());//是否初次曝光（仅在打底广告时记录）

        // 1.5 版本升级调整
        bundle.putString("image_url", info.getAdImgUrl());
        bundle.putInt("image_width", info.getAdImageWidth());
        bundle.putInt("image_height", info.getAdImageHeight());

        if (info.getNativeObject() != null) {
            bundle.putString("version", info.getNativeObject().getVersion());
            bundle.putInt("rating", info.getNativeObject().getRating());
            bundle.putString("title_text", info.getNativeObject().getTitleTxt());
            bundle.putString("descript_text", info.getNativeObject().getDescriptionTxt());
            bundle.putString("button_text", info.getNativeObject().getButtonTxt(info.getInstallApk()));
            if (info.getNativeObject().getLogo() != null) {
                bundle.putString("logo_url", info.getNativeObject().getLogoUrl());
                bundle.putInt("logo_width", info.getNativeObject().getLogo().getWidth());
                bundle.putInt("logo_height", info.getNativeObject().getLogo().getHeight());
            }
            //todo native多条待完善
            if (info.getNativeObject().getMainImages() != null && info.getNativeObject().getMainImages().size() > 0) {
                bundle.putString("main_image_url", info.getNativeObject().getMainImages().get(0).getUrl());
                bundle.putInt("main_image_width", info.getNativeObject().getMainImages().get(0).getWidth());
                bundle.putInt("main_image_height", info.getNativeObject().getMainImages().get(0).getHeight());
            }
        }
        bundle.putLong("login_time", System.currentTimeMillis());//日志时间戳
        bundle.putInt("is_default_ad", info.getIsDefaultAd());
        bundle.putInt("actual_show_rate", info.getActualShowRate());//广告素材实际曝光比例
        bundle.putLong("show_ts", System.currentTimeMillis());//广告曝光时时间戳
        bundle.putInt("is_effective_show", info.getIsEffectiveShow());//是否有效曝光 1/0 1=有效 0=无效
        bundle.putString("app_id", SspAd.AppId);

        if (info.getStoreDeeplink() != null && info.getStoreDeeplink().size() > 0){
            bundle.putString("click_urls", info.getStoreDeeplink().toString());
        }
        bundle.putInt("is_test_request", SspAd.isTestRequest() ? 1 : 0);// 是否测试请求   1=是 0=否        int

        //20211028 配和abtest
        if (info.getAbTest() != null) {
            bundle.putString("abTest", GsonUtil.toJson(info.getAbTest()));
        }
        bundle.putString("extInfo", info.getExtInfo());
        if (info.getImpBeanRequest() != null) {
            bundle.putInt("request_type",  info.getImpBeanRequest().requestType);
        }
        return bundle;
    }

    /**
     * SSP SDK 物料加载日志
     *
     * @param info         广告详情
     * @param download_way 下载方式 1.HttpUrlConnection 2.Okhttp  int
     * @param m_status     物料事件状态  1=开始加载 2=加载成功 3=加载失败 int
     * @param errorcode    失败原因 string
     * @param m_type       物料类型 1=logo 2=大图 int
     */
    public static void trackImageDownload(AdsDTO info, int download_way, int m_status, String errorcode, int m_type) {

        if (null == info) {
            return;
        }

        //公参 SDK自行上报
        Bundle bundle = getBundle(null);

        //事件参数
        bundle.putString("request_id", info.getRid());
        bundle.putString("code_seat_id", info.getCodeSeatId());
        bundle.putInt("code_seat_type", info.getCodeSeatType());
        bundle.putLong("advertiser_id", info.getAdvertiserId());
        bundle.putLong("plan_id", info.getPlanId());
        bundle.putLong("ad_group_id", info.getAdGroupId());
        bundle.putLong("ad_creative_id", info.getAdCreativeId());
        bundle.putString("package_name", info.getPackageName());

        // 1.5 版本升级调整
        bundle.putString("image_url", info.getAdImgUrl());
        bundle.putInt("image_width", info.getAdImageWidth());
        bundle.putInt("image_height", info.getAdImageHeight());


        bundle.putLong("login_time", System.currentTimeMillis());//日志时间戳
        bundle.putInt("is_default_ad", info.getIsDefaultAd());

        // 自定义字段
        bundle.putInt("download_way ", download_way); // 下载方式 1.HttpUrlConnection 2.Okhttp  int
        bundle.putInt("m_status", m_status); // 物料事件状态  1=开始加载 2=加载成功 3=加载失败 int
        bundle.putString("error_code", errorcode); // 失败原因 string
        bundle.putInt("m_type", m_type); // 物料类型 1=logo 2=大图 int
        new AthenaCust(PostConstant.EVENT_IMG, PostConstant.TID).trackCommon(bundle, null).submit();
    }

    /**
     *  请求广告埋点
     * @param info
     */
    public static void trackSspRequest(AdxImpBean info) {
        //公参 SDK自行上报
        Bundle bundle = getBundle(null);
        bundle.putInt("request_type", info.requestType);
        bundle.putLong("request_ts", info.getRequestTs());
        bundle.putString("request_id", info.requestId);
        bundle.putInt("ad_type", info.adt);
        bundle.putString("app_id", SspAd.AppId);
        bundle.putString("code_seat_id", info.pmid);
        bundle.putInt("ad_count", info.mAdCount);
        bundle.putInt("is_retreatad", 0);
        bundle.putInt("is_default_ad", info.defaultAd ? 1 : 0);
        if (bundle != null) {
            new AthenaCust(PostConstant.EVENT_AD_SSP_REQUEST, PostConstant.TID).trackCommon(bundle, null).submit();
        }
    }

    /**
     * 返回广告埋点
     * @param info
     */
    public static void trackSspReturn(AdsDTO info, TaErrorCode adError,AdxImpBean adxImpBean) {
        //公参 SDK自行上报
        Bundle bundle = getBundle(null);
        if (info != null && info.getImpBeanRequest() != null && adxImpBean == null){
            adxImpBean = info.getImpBeanRequest();
        }
        if (adxImpBean != null){
            bundle.putInt("request_type", adxImpBean.requestType);
            bundle.putLong("request_ts", adxImpBean.getRequestTs());
            bundle.putString("request_id", adxImpBean.requestId);
            bundle.putInt("ad_type", adxImpBean.adt);
            bundle.putString("code_seat_id", adxImpBean.pmid);
            bundle.putInt("ad_count", adxImpBean.mAdCount);
            bundle.putInt("is_default_ad", adxImpBean.defaultAd ? 1 : 0);
            bundle.putInt("return_time",(int)(System.currentTimeMillis() - adxImpBean.getRequestTs()));
            bundle.putInt("is_timeout", adxImpBean.isTimeOut);
        }
        bundle.putString("app_id", SspAd.AppId);
        bundle.putLong("return_ts", System.currentTimeMillis());

        //请求成功时，不会上报
        if (adError != null){
            bundle.putString("error_code", adError.getErrorCode()+"");
            bundle.putString("error_message", adError.getErrorMessage());
        }
        if (info != null) {
            bundle.putDouble("bidding_price", info.getFirstPrice());
            bundle.putLong("advertiser_id", info.getAdvertiserId());//广告主id
            bundle.putLong("plan_id", info.getPlanId());//计划id
            bundle.putLong("ad_group_id", info.getAdGroupId());//广告组id
            bundle.putLong("ad_creative_id", info.getAdCreativeId());//广告创意id
            bundle.putString("package_name", info.getPackageName());
            bundle.putString("image_url", info.getAdImgUrl());
            bundle.putInt("image_width", info.getAdImageWidth());
            bundle.putInt("image_height", info.getAdImageHeight());
            bundle.putString("default_ad_expiration_time", info.getDefaultAdExpirationTime());
            bundle.putInt("default_ad_show_count", info.getDefaultAdShowCount());
            bundle.putString("material_style", info.getMaterialStyle());
            if (info.getNativeObject() != null){
                String str = GsonUtil.toJson(info.getNativeObject());
                bundle.putString("ad_material_info_list", str);
            }
            if (info.getStoreDeeplink() != null && info.getStoreDeeplink().size() > 0) {
                bundle.putString("click_urls", info.getStoreDeeplink().toString());
            }
        }
        if (bundle != null) {
            new AthenaCust(PostConstant.EVENT_AD_SSP_RETURN, PostConstant.TID).trackCommon(bundle, null).submit();
        }
    }
}
