package com.cloud.hisavana.sdk.common.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;

import com.cloud.hisavana.sdk.R;


/**
 * Created by wenshuai.liu on 2017/5/5.
 * ========================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class CountTimeView extends View implements View.OnClickListener {
    private Paint mPain, mTextPain;
    private long mStartTime = 6;
    private CountDownTimer mCountTimer;
    private int mTextSize;
    private String mTextString = "5s";
    private CountDownTimerListener countDownTimerListener;
    private Bitmap bitmap;
    /**
     *  在界面在不可见的时候，就已经开始计时了 。
     */
    private static final long AE = 400L;
    private Rect rect = new Rect();

    public CountTimeView(Context context) {
        this(context, null);
    }

    public CountTimeView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CountTimeView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        setOnClickListener(this);
        mTextSize = context.getResources().getDimensionPixelSize(R.dimen.ad_skip_text_size);
        initPaint();
    }

    private void initPaint() {
        mPain = new Paint();
        mPain.setAntiAlias(true);
        mPain.setDither(true);
        mPain.setStyle(Paint.Style.FILL);
        mTextPain = new Paint();
        mTextPain.setAntiAlias(true);
        mTextPain.setColor(Color.WHITE);
        mTextPain.setTextSize(mTextSize);
        mTextPain.setStrokeWidth(8);
        mTextPain.setTextAlign(Paint.Align.CENTER);
    }

    public void setStartTime(int time) {
        this.mStartTime = time*1000+AE;
        createCountTimer();
    }


    public void setCountDownTimerListener(CountDownTimerListener listener) {
        this.countDownTimerListener = listener;
    }

    private void createCountTimer() {
        mCountTimer = new CountDownTimer(mStartTime, 1000) {
            @Override
            public void onTick(long millisUntilFinished) {
                mTextString = "SKIP "+(millisUntilFinished)/ 1000;
                invalidate();
            }

            @Override
            public void onFinish() {
                if (countDownTimerListener != null) {
                    countDownTimerListener.onFinish();
                }
            }
        };
    }

    /**
     * 开始计时
     */
    public void start() {
        mCountTimer.start();
        if (countDownTimerListener != null) {
            countDownTimerListener.onStart();
        }
    }

    public void cancel() {
        if (mCountTimer != null) {
            mCountTimer.cancel();
        }
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!TextUtils.isEmpty(mTextString)) {

            /**
             * 求字符串长度
             *
             */
            //canvas.drawRect(rect,mTextPain);
            if (bitmap == null) {
                bitmap = getBg();
            }
            /**
             * 画图
             */
            Rect scr = new Rect(0,0,bitmap.getWidth(),bitmap.getHeight());
            canvas.drawBitmap(bitmap,scr,scr,mPain);
            Paint.FontMetrics fontMetrics = mTextPain.getFontMetrics();
            int baseLine = (int)(rect.bottom+rect.top - fontMetrics.bottom-fontMetrics.top)/2;
            canvas.drawText(mTextString,rect.centerX(),baseLine,mTextPain);
        }
    }


    private Bitmap getBg(){
        Drawable drawable = getResources().getDrawable(R.drawable.ad_skip_button);
        if(drawable instanceof BitmapDrawable){
            bitmap = ((BitmapDrawable)drawable).getBitmap();
        }else {
            bitmap = Bitmap.createBitmap(drawable.getIntrinsicWidth(),drawable.getIntrinsicHeight(),Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            drawable.setBounds(0,0,canvas.getWidth(),canvas.getHeight());
            drawable.draw(canvas);
        }
        return bitmap;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        rect.set(0,0,getWidth(),getHeight());
        super.onSizeChanged(w, h, oldw, oldh);
    }

    @Override
    public void onClick(View v) {
        if (countDownTimerListener != null) {
            countDownTimerListener.onClick();
        }
    }
    public interface CountDownTimerListener {
        void onStart();

        void onFinish();

        void onClick();
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        mCountTimer.start();
        if (countDownTimerListener != null) {
            countDownTimerListener.onStart();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (mCountTimer != null) {
            mCountTimer.cancel();
        }
    }
}
