package com.cloud.hisavana.sdk.data.bean.response;

import java.util.List;

/**
 * @author: wenjing.luo
 * @date: 2021/8/5
 * ==================================
 * Copyright (c) 2021 TRANSSION.Co.Ltd.
 * All rights reserved.
 * <p>
 * 广告返回数据bean
 */
public class DataDTO {

    /**
     * 归因需求新增
     * 服务器当前时间
     * 格林尼治时间
     * yyyy-MM-dd HH:mm:ss SSS Z
     * 2021-08-06 17:56:18 878 +0000
     */
    private String time;

    private String requestId;        // 广告请求id
    private String gaid;             // gaid
    private String codeSeatId;       // 代码位id
    private Integer codeSeatType;    // 代码位类型 同请求格式
    private Integer cacheTime;       // 缓存时长（分钟）：开屏-4小时、其他-1小时
    private List<AdsDTO> ads;        // 广告集合

    private String cloudControlVersion;
    private List<AbTestDTO> abTest;
    private String extInfo;

    public String getTime() {
        return null == time ? "" : time;
    }

    public String getRequestId() {
        return null == requestId ? "" : requestId;
    }

    public String getGaid() {
        return null == gaid ? "" : gaid;
    }

    public String getCodeSeatId() {
        return null == codeSeatId ? "" : codeSeatId;
    }

    public Integer getCodeSeatType() {
        return codeSeatType == null ? 0 : codeSeatType;
    }

    public Integer getCacheTime() {
        return cacheTime == null ? 0 : cacheTime;
    }

    public List<AdsDTO> getAds() {
        return ads;
    }

    public String getCloudControlVersion() {
        return null == cloudControlVersion ? "" : cloudControlVersion;
    }

    public List<AbTestDTO> getAbTest() {
        return abTest;
    }

    public String getExtInfo() {
        return null == extInfo ? "" : extInfo;
    }

    @Override
    public String toString() {
        return "DataDTO{" +
                "time='" + time + '\'' +
                ", requestId='" + requestId + '\'' +
                ", gaid='" + gaid + '\'' +
                ", codeSeatId='" + codeSeatId + '\'' +
                ", codeSeatType=" + codeSeatType +
                ", cacheTime=" + cacheTime +
                ", ads=" + ads +
                ", cloudControlVersion='" + cloudControlVersion + '\'' +
                ", abTest=" + abTest +
                ", extInfo='" + extInfo + '\'' +
                '}';
    }
}
