package com.cloud.hisavana.sdk.common.tranmeasure;

import android.view.Choreographer;

import com.cloud.hisavana.sdk.common.util.AdLogUtil;


public class ChoreographerMonitor extends Monitor{
    private boolean mRunningState = false;
    private static final int INTERVAL = 12;
    int times = 1;
    private ScreenStateManager mStateManager = null;

    protected ChoreographerMonitor(){
        mStateManager = new ScreenStateManager();
        mStateManager.setStateListener(new ScreenStateManager.IState() {
            @Override
            public void updateState(boolean forground) {
                if(forground){
                    sendHeartPkg();
                }else {
                    stopHeartPkg();
                }
            }
        });
    }

    @Override
    public void start(){
        if(mRunningState){
            AdLogUtil.Log().d(AdLogUtil.TAG,"monitor is running");
            return;
        }
        sendHeartPkg();
        mStateManager.startMonitor();
    }

    private void sendHeartPkg(){
        mRunningState = true;
        Choreographer.getInstance().postFrameCallback(frameCallback);
    }

    private void stopHeartPkg(){
        mRunningState = false;
        Choreographer.getInstance().removeFrameCallback(frameCallback);
    }

    @Override
    public void end(){
        mRunningState = false;
        mStateManager.endMonitor();
        stopHeartPkg();
    }

    private Choreographer.FrameCallback frameCallback = new Choreographer.FrameCallback() {
        @Override
        public void doFrame(long frameTimeNanos) {
            if(mRunningState){
                if(times >= INTERVAL){
                    times = 1;
                    MeasureSessionManager.getInstance().measure();
                }else {
                    times++;
                }
                Choreographer.getInstance().postFrameCallback(frameCallback);
            }
            else {
                stopHeartPkg();
            }
        }
    };

}
