/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.http;

import android.text.TextUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class HttpsConfigUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLSocketFactory getSSLSocketFactory(String name) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        ByteArrayInputStream certSteam = null;
        try {
            certSteam = new ByteArrayInputStream(name.getBytes());
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            Certificate cert = factory.generateCertificate(certSteam);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            keyStore.setCertificateEntry("cert", cert);
            String tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(tmfAlgorithm);
            trustManagerFactory.init(keyStore);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
            SSLSocketFactory sSLSocketFactory = sslContext.getSocketFactory();
            return sSLSocketFactory;
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        catch (CertificateException e3) {
            e3.printStackTrace();
        }
        catch (KeyStoreException e4) {
            e4.printStackTrace();
        }
        catch (NoSuchAlgorithmException e5) {
            e5.printStackTrace();
        }
        catch (Throwable e6) {
            e6.printStackTrace();
        }
        finally {
            try {
                if (certSteam != null) {
                    ((InputStream)certSteam).close();
                }
            }
            catch (Throwable e7) {
                e7.printStackTrace();
            }
        }
        return null;
    }

    public static TrustManager getTrustManager() {
        String tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(tmfAlgorithm);
            return trustManagerFactory.getTrustManagers()[0];
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return null;
        }
    }
}

