/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.util;

import android.support.annotation.Nullable;
import android.util.Log;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.DiskLruCache;
import com.cloud.hisavana.sdk.common.util.FileUtil;
import com.transsion.core.utils.AppUtil;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class CacheUtil {
    private static final String CACHE_DIR = "ZERO_AD_SDK_LRUCACHE";
    private static DiskLruCache mDiskLruCache;
    private static final long MAX_SIZE = 0x6400000L;

    private CacheUtil() {
        try {
            mDiskLruCache = DiskLruCache.open(this.getCacheDir(), AppUtil.getVersionCode(), 1, 0x6400000L);
        }
        catch (Throwable e2) {
            e2.printStackTrace();
        }
    }

    public static CacheUtil getInstance() {
        return CacheUtilInstance.INSTANCE;
    }

    @Nullable
    public synchronized String getString(String key) {
        if (mDiskLruCache == null || mDiskLruCache.isClosed()) {
            return null;
        }
        try {
            DiskLruCache.Snapshot snapshot = mDiskLruCache.get(key);
            if (snapshot != null) {
                String value = snapshot.getString(0);
                AdLogUtil.Log().d("ssp", "get content successful.key=" + key + ", value=" + value);
                return value;
            }
        }
        catch (Throwable e2) {
            AdLogUtil.Log().e("read cache error: " + Log.getStackTraceString((Throwable)e2));
        }
        return null;
    }

    public synchronized void putString(String key, String content) {
        block6: {
            if (mDiskLruCache == null || mDiskLruCache.isClosed()) {
                return;
            }
            DiskLruCache.Editor editor = null;
            try {
                editor = mDiskLruCache.edit(key);
                if (editor != null) {
                    editor.set(0, content);
                    editor.commit();
                    mDiskLruCache.flush();
                    AdLogUtil.Log().d("ssp", "put content successful. key=" + key + ", value=" + content);
                }
            }
            catch (Throwable e2) {
                if (editor == null) break block6;
                try {
                    editor.abort();
                }
                catch (Throwable e1) {
                    AdLogUtil.Log().e("write cache error: " + Log.getStackTraceString((Throwable)e2));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putSerializable(String key, Serializable value) {
        DiskLruCache.Editor editor = null;
        ObjectOutputStream oos = null;
        try {
            editor = mDiskLruCache.edit(key);
            if (editor == null) {
                return;
            }
            OutputStream os = editor.newOutputStream(0);
            oos = new ObjectOutputStream(os);
            oos.writeObject(value);
            oos.flush();
            editor.commit();
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            try {
                editor.abort();
            }
            catch (Throwable e1) {
                e1.printStackTrace();
            }
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (Throwable e3) {
                e3.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getAsSerializable(String key) {
        Object t = null;
        ObjectInputStream ois = null;
        try {
            DiskLruCache.Snapshot snapshot = mDiskLruCache.get(key);
            if (snapshot == null) {
                T t2 = null;
                return t2;
            }
            InputStream is = snapshot.getInputStream(0);
            if (is == null) {
                T t3 = null;
                return t3;
            }
            ois = new ObjectInputStream(is);
            t = ois.readObject();
        }
        catch (Throwable e2) {
            e2.printStackTrace();
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (Throwable e3) {
                e3.printStackTrace();
            }
        }
        return (T)t;
    }

    public void diskRemove(String key) {
        if (mDiskLruCache == null || mDiskLruCache.isClosed()) {
            return;
        }
        try {
            mDiskLruCache.remove(key);
        }
        catch (Throwable e2) {
            e2.printStackTrace();
        }
    }

    private File getCacheDir() {
        File dir = new File(FileUtil.getAppDateCachePath(), CACHE_DIR);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    private static class CacheUtilInstance {
        private static final CacheUtil INSTANCE = new CacheUtil();

        private CacheUtilInstance() {
        }
    }
}

