/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.util;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;

public class DrawableUtil {
    public static int getDrawableWidth(Drawable drawable, int def) {
        if (drawable != null) {
            if (drawable instanceof BitmapDrawable) {
                if (((BitmapDrawable)drawable).getBitmap() == null) {
                    return def;
                }
                int width = ((BitmapDrawable)drawable).getBitmap().getWidth();
                AdLogUtil.Log().d("ssp", "BitmapDrawable width:=" + width);
                return width > 0 ? width : 0;
            }
            if (drawable instanceof Drawable) {
                int width = drawable.getIntrinsicWidth();
                AdLogUtil.Log().d("ssp", "Drawable width:=" + width);
                return width > 0 ? width : 0;
            }
        }
        return def;
    }

    public static int getDrawableHeight(Drawable drawable, int def) {
        if (drawable != null) {
            if (drawable instanceof BitmapDrawable) {
                Bitmap bitmap = ((BitmapDrawable)drawable).getBitmap();
                if (bitmap != null) {
                    int height = bitmap.getHeight();
                    AdLogUtil.Log().d("ssp", "BitmapDrawable height:=" + height);
                    return height > 0 ? height : 0;
                }
            } else if (drawable instanceof Drawable) {
                int height = drawable.getIntrinsicHeight();
                AdLogUtil.Log().d("ssp", "Drawable height:=" + height);
                return height > 0 ? height : 0;
            }
        }
        return def;
    }
}

