package com.cloud.hisavana.sdk.common.athena;

import static com.cloud.hisavana.sdk.common.util.AdLogUtil.TAG;

import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.data.bean.request.AdxImpBean;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;

/**
 * Created by wenjing.luo on 2021/8/24.
 */

public class AthenaTracker {


    // 下载途径
    public static final int DOWNLOAD_WAY_HTTP_URL_CONNECTION = 1;
    public static final int DOWNLOAD_WAY_OKHTTP = 2;

    // 下载状态
    public static final int M_STATUS_STAR = 1;
    public static final int M_STATUS_SUCCESS = 2;
    public static final int M_STATUS_ERROR = 3;

    // 下载类型
    public static final int M_TYPE_LOGO = 1;
    public static final int M_TYPE_LARGE_IMG = 2;
    public static final int M_TYPE_AD_CHOICE_VIEW = 3;

    public static Handler handler;
    public static HandlerThread handlerThread;

    private synchronized static void initHandler() {
        if (handler == null) {
            handlerThread = AthenaUtil.getHanderThread();
            AthenaUtil.start();
            handler = new Handler(handlerThread.getLooper());
            AdLogUtil.Log().d(TAG, "AthenaTracker initHandlerThread");
        }
    }
    /**
     * @return 获取公参
     */
    public static Bundle getBundle(Bundle bundle) {
        return AthenaTrackerInvoker.getBundle(bundle);
    }
    /**
     * 上报埋点新开一个子线程
     *
     * @param runnable
     */
    public static void trackInNewThread(final Runnable runnable) {
        initHandler();
        handler.post(runnable);
    }

    /**
     * 展示上报新开一个子线程
     *
     * @param info
     */
    public static void trackShow(final AdsDTO info) {
        trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackShow(info);
            }
        });
    }

    /**
     * deeplink应用拉起成功上报
     *
     * @param info
     */
    public static void trackDeeplink(final AdsDTO info) {
        trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackDeeplink(info);
            }
        });
    }

    /**
     * SSP SDK 物料加载日志
     *
     * @param info         广告详情
     * @param download_way 下载方式 1.HttpUrlConnection 2.Okhttp  int
     * @param m_status     物料事件状态  1=开始加载 2=加载成功 3=加载失败 int
     * @param errorcode    失败原因 string
     * @param m_type       物料类型 1=logo 2=大图 int
     */
    public static void trackImageDownload(final AdsDTO info, final int download_way, final int m_status, final String errorcode, final int m_type, final String cdn) {
        trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackImageDownload(info, download_way, m_status, errorcode, m_type,cdn);
            }
        });
    }

    /**
     * 请求广告埋点
     *
     * @param info
     */
    public static void trackSspRequest(final AdxImpBean info) {
        trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackSspRequest(info);
            }
        });
    }

    /**
     * 返回广告埋点
     *
     * @param info
     */
    public static void trackSspReturn(final AdsDTO info, final TaErrorCode adError, final AdxImpBean adxImpBean) {
        trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackSspReturn(info, adError, adxImpBean);
            }
        });
    }
}
