package com.cloud.hisavana.sdk.common.callback;

import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.data.bean.request.AdxImpBean;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo;

import java.util.List;

/**
 * Created by jianbing.yu on 2019/3/25.
 */

public abstract class InternalAdListener extends AdListener {

    public void onAdResponse(List<AdsDTO> adBeans) {
        //除splash外广告类型的返回埋点上报
        if (adBeans != null && adBeans.size() > 0){
            AthenaTracker.trackSspReturn(adBeans.get(0),null,null);
        }
    }

    public void onSplashCacheGet(List<AdsDTO> adBeans) {

    }
    public void onErrorInternal(List<AdsDTO> adBeans,TaErrorCode adError, AdxImpBean adxImpBean) {
        //返回上报
        if (adBeans != null && adBeans.size() > 0){
            AthenaTracker.trackSspReturn(adBeans.get(0),adError,adxImpBean);
        }else {
            AthenaTracker.trackSspReturn(null,adError,adxImpBean);
        }

    }
    public void onMediaDownloaded(TaNativeInfo adInfo) {

    }
}
