package com.cloud.hisavana.sdk.ad.base;

import android.text.TextUtils;
import android.util.Log;

import com.cloud.hisavana.sdk.BuildConfig;
import com.cloud.hisavana.sdk.api.config.SspAd;
import com.cloud.hisavana.sdk.common.athena.PostConstant;
import com.cloud.hisavana.sdk.common.gsonutil.GsonUtil;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.ApplicationUtil;
import com.cloud.hisavana.sdk.common.util.DeviceUtil;
import com.cloud.hisavana.sdk.common.util.GPSTracker;
import com.cloud.hisavana.sdk.common.util.MitNetUtil;
import com.cloud.hisavana.sdk.data.bean.request.AdxImpBean;
import com.cloud.hisavana.sdk.data.bean.request.AdxRequestBody;
import com.cloud.hisavana.sdk.data.bean.request.ApplicationDTO;
import com.cloud.hisavana.sdk.data.bean.request.CodeSeatDTO;
import com.cloud.hisavana.sdk.data.bean.request.DeviceDTO;
import com.cloud.hisavana.sdk.data.bean.request.UserDTO;
import com.transsion.core.utils.AppUtil;

import java.util.Locale;

/**
 * Created by jianbing.yu on 2019/3/1.
 */

public class PostBody {

    /**
     * 网络请求组织参数 全局用一个
     */
    private static volatile AdxRequestBody requestParam = null;

    private static boolean initParam(){
        if (requestParam == null) {
            requestParam = new AdxRequestBody();
            ApplicationDTO applicationDTO = new ApplicationDTO();
            applicationDTO.setPackageName(AppUtil.getPkgName());
            applicationDTO.setInstallTime(ApplicationUtil.getInstallTime()); //客户端首次安装时间（时间戳）
            applicationDTO.setVersion(PostConstant.getVersionName());
            applicationDTO.setSdkVersion(PostConstant.getSdkVersion());
            applicationDTO.setSdkVersionCode(BuildConfig.VERSION_CODE);
            applicationDTO.setUserAgent(PostConstant.getUserAgent());
            requestParam.application = applicationDTO;

            DeviceDTO deviceDTO = new DeviceDTO();
            deviceDTO.setType(PostConstant.getType());
            deviceDTO.setBrand(PostConstant.getBrand());
            deviceDTO.setModel(PostConstant.getModel());
            deviceDTO.setMaker(PostConstant.getMake());//设备制造商
            deviceDTO.setOsType(1);//1、Android；2、iOS
            deviceDTO.setOsVersion(PostConstant.getOsVersion());
            deviceDTO.setLanguage(Locale.getDefault().getLanguage());
            deviceDTO.setNetworkConnectionType(String.valueOf(MitNetUtil.getNetType()));
            deviceDTO.setOperatorType(PostConstant.getMnc()+PostConstant.getMcc());//运营商类型
            deviceDTO.setIpAddress(DeviceUtil.getIp());//客户端真实ip
            // 加密上传
            deviceDTO.setGaid(DeviceUtil.getGAId());//客户端唯一识别id，安卓传 异步重要
//                deviceDTO.setGaidNewAES(DeviceUtil.getGaidAES());//客户端唯一识别id，安卓传 异步重要
            deviceDTO.setImsi(PostConstant.getMcc());//IMSI 国际移动用户识别码
            //20220624紧急去除AndroidID
//            deviceDTO.setAndroidIdSha1(DeviceUtil.getAndroidIDSHA1());//安卓id  SHA1
//            deviceDTO.setAndroidIdMd5(DeviceUtil.getAndroidIDMd5());//安卓id  Md5
            deviceDTO.setScreenWidth(PostConstant.getScreenWidth());
            deviceDTO.setScreenHeight(PostConstant.getScreenHeight());
            deviceDTO.setScreenDensity(PostConstant.getScreenDensity());
            requestParam.device = deviceDTO;
            return true;
        }
        return false;
    }

    public static String getAdPostBody(AdxImpBean impBean) {
        try {
            boolean isInit = initParam();
            AdxRequestBody requestBody = AdxRequestBody.copy(requestParam);
            requestBody.requestId = !TextUtils.isEmpty(impBean.requestId) ? impBean.requestId : DeviceUtil.getUUID();//请求id sdk生成的
            requestBody.testRequest = SspAd.isTestRequest();//是否为测试请求: true-测试请求、fase-正常请求（默认false）
            requestBody.applicationId = SspAd.AppId;//应用id
            requestBody.defaultAd = impBean.defaultAd;//是否请求打底广告 （默认false）；true: 请求打底广告；false: 请求竞价广告
            requestBody.codeSeat.setId(impBean.pmid);//代码位id 广告位标识符
            requestBody.codeSeat.setType(impBean.adt);//代码位类型 1 native，2 banner，3插屏， 4 开屏
            requestBody.codeSeat.setAdCount(impBean.mAdCount);//单次请求的广告个数(如果不传默认为 1)
            requestBody.codeSeat.setWidth(0);//广告位宽（实际广告的展示区域宽）
            requestBody.codeSeat.setHeight(0);//广告位高（实际广告的展示区域高）
            //解决如果gaid获取为空，进程内都无法再次获取的问题
            if(!isInit && requestBody.device != null && TextUtils.isEmpty(requestBody.device.getGaid())){
                requestBody.device.setGaid(DeviceUtil.getGAId());
            }
            requestBody.user.setBaseStation(DeviceUtil.getGsmCellLocation());//客户端基站信息（IOS没有）
            requestBody.user.setLatitude(GPSTracker.getLatitude());
            requestBody.user.setLongitude(GPSTracker.getLongitude());
            requestBody.user.setCoordTime( GPSTracker.getCoordTimeStr());//获取经纬度(lat/lng)的时间。其值 为从 GMT 1970-01-01 00：00：00 至今的毫秒值
            return GsonUtil.toJson(requestBody);
        }catch (Throwable e){
            AdLogUtil.Log().e(Log.getStackTraceString(e));
        }
        return "";
    }

}
