package com.cloud.hisavana.sdk.common.tracking;

import static com.cloud.hisavana.sdk.common.util.AdLogUtil.TRACK_TAG;

import android.os.Build;
import android.text.TextUtils;

import com.cloud.hisavana.sdk.BuildConfig;
import com.cloud.hisavana.sdk.api.config.SspAd;
import com.cloud.hisavana.sdk.common.athena.PostConstant;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.util.AESUtils;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.DeviceUtil;
import com.cloud.hisavana.sdk.common.util.GPSTracker;
import com.cloud.hisavana.sdk.common.util.MitNetUtil;
import com.cloud.hisavana.sdk.common.util.UserAgentUtil;
import com.cloud.hisavana.sdk.data.control.AdxPreferencesHelper;
import com.transsion.core.deviceinfo.DeviceInfo;
import com.transsion.core.pool.TranssionPoolManager;
import com.transsion.core.utils.AppUtil;
import com.transsion.http.HttpClient;
import com.transsion.http.impl.StringCallback;

import java.util.List;

/**
 * 落地页跟踪
 */
public class TrackingManager {

    /**
     * 超时时间
     */
    private static final int TIMEOUT_IN_MILLIONS = 15 * 1000;
    private static final String CLICK_ID = "__CLICK_ID__";
    private static final String CLICK_IP = "__CLICK_IP__";
    private static final String CLICK_TS = "__CLICK_TS__";
    private static final String ANDROID_ID_LOWER_MD5 = "__ANDROID_ID_LOWER_MD5__";


    // =============================================================================================


    /**
     * 当广告被点击后，触发此字段中的 clickTrackingUrls
     */
    public static void clickTrackingUrlsExposure(List<String> urls, final String clickid) {
        if (urls == null || urls.size() < 1) {
            AdLogUtil.Log().d(TRACK_TAG, "clickTrackingUrls || showTrackingUrls --> urls==null || urls.size()=<1 --> return ");
            return;
        }

        // 发起多个请求
        for (final String url : urls) {
            if (TextUtils.isEmpty(url)) {
                continue;
            }

            TranssionPoolManager.getInstance().addTask(new Runnable() {
                @Override
                public void run() {
                    sendRequestToServer(processTrackingUrls(url, clickid));
                }
            });
        }
    }
   /**
     * 当广告被展示后，触发此字段中的 showTrackingUrls
     */
    public static void showTrackingUrlsExposure(List<String> urls, final TrackingBean trackingBean,final DownUpPointBean pointBean) {
        if (urls == null || urls.size() < 1) {
            AdLogUtil.Log().d(TRACK_TAG, "clickTrackingUrls || showTrackingUrls --> urls==null || urls.size()=<1 --> return ");
            return;
        }

        // 发起多个请求
        for (final String url : urls) {
            if (TextUtils.isEmpty(url)) {
                continue;
            }

            TranssionPoolManager.getInstance().addTask(new Runnable() {
                @Override
                public void run() {
                    if(isEagllwinLink(url)){
                        trackingBean.setLandingUrl(url);
                        //服务端曝光上报
                        reportServerShow(trackingBean,pointBean);
                    }else {
                        sendRequestToServer(processTrackingUrls(url, trackingBean.getClickid()));
                    }
                }
            });
        }
    }


    // =============================================================================================


    /**
     * 发起网络请求
     *
     * @param url
     */
    private static void sendRequestToServer(String url) {
        AdLogUtil.Log().d(TRACK_TAG, "sendRequestToServer - url = " + url);

        if (url == null) {
            return;
        }
        HttpClient.get()
                .log(SspAd.isDebug())
                .connectTimeout(TIMEOUT_IN_MILLIONS)
                .readTimeout(TIMEOUT_IN_MILLIONS)
                .url(url)
                .addHeader("User-Agent", UserAgentUtil.getUserAgent())
                .addHeader("Accept-Timezone", "UTC")
                .build()
                .execute(new StringCallback(true) {
                             @Override
                             public void onSuccess(final int statusCode, final String response) {
                                 AdLogUtil.Log().d(TRACK_TAG, "sendRequestToServer - onSuccess - statusCode = " + statusCode);
                             }

                             @Override
                             public void onFailure(final int statusCode, final String response, final Throwable throwable) {
                                 AdLogUtil.Log().d(TRACK_TAG, "sendRequestToServer --> onFailure --> statusCode = " + statusCode);
                             }
                         }
                );
    }
    /**
     * 服务端点击上报 clickurl
     * @param pointBean
     * @param trackingBean
     * @return
     */
    public static void reportServerClick(DownUpPointBean pointBean, TrackingBean trackingBean){
        if (trackingBean == null || TextUtils.isEmpty(trackingBean.getLandingUrl()) || null == pointBean) {
            AdLogUtil.Log().d(TRACK_TAG, "reportServerClick --> null == url || null == pointBean");
            return;
        }
        AdLogUtil.Log().d(TRACK_TAG, "TrackingManager --> processUrl --> pointBean = " + pointBean.toString());
        String landingUrl = trackingBean.getLandingUrl();
        //发起请求，只有eagllwin的链接需要拼接参数
        if(isEagllwinLink(landingUrl)){
            sendRequestToServer(processReportServerField(pointBean, trackingBean, true));
        }else {
            sendRequestToServer(landingUrl);
        }
    }

    /**
     * 服务端曝光上报
     * @param trackingBean
     * @return
     */
    public static void reportServerShow(TrackingBean trackingBean,DownUpPointBean pointBean){
        if (trackingBean == null || TextUtils.isEmpty(trackingBean.getLandingUrl())  || null == pointBean) {
            AdLogUtil.Log().d(TRACK_TAG, "reportServerShow --> null == url || null == pointBean");
            return;
        }
        AdLogUtil.Log().d(TRACK_TAG, "TrackingManager --> processUrl --> pointBean = " + pointBean.toString());
        // 发起请求
        sendRequestToServer(processReportServerField(pointBean, trackingBean, false));
    }


    /**
     * 判断是否是eagllwin链接
     * @param landingUrl
     * @return
     */
    public static boolean isEagllwinLink(String landingUrl){
        if(!TextUtils.isEmpty(landingUrl) && (landingUrl.contains(Constants.HOST.ADN_TEST_SERVER_IMPRESSSION)
                || landingUrl.contains(Constants.HOST.ADN_RELEASE_SERVER_IMPRESSSION)
                || landingUrl.contains(Constants.HOST.ADN_PRE_SERVER_IMPRESSSION)
                || landingUrl.contains(Constants.HOST.ADN_FAT_SERVER_IMPRESSSION))){
            return true;
        }
        return false;
    }

    /**
     * 服务端点击，曝光-处理 url
     * @param pointBean 点击区域
     * @param trackingBean
     * @return
     * <p>
     * xd=_X-DOWN_&yd=_Y-DOWN_&xu=_X-UP_&yu=_Y-UP_&ai=_APPID_&pn=_PACKAGE-NAME_&ve=_VERSION_&sv=_SDK-VERSION_&ot=_OS-TYPE_&ov=_OS-VERSION_&nc=_NET-CONN-TYPE_&op=_OPERATOR-TYPE_&ga=_GAID_&dt=_DEVICE-TYPE_&br=_BRAND_&mo=_MODEL_&ma=_MAKER_&la=_LATITUDE_&lo=_LONGITUDE_&iw=_IMAGE-WIDTH_&ih=_IMAGE-HEIGHT_
     */
    public static String processReportServerField(DownUpPointBean pointBean, TrackingBean trackingBean, boolean isClickReport) {
        // 组装Url
        AdLogUtil.Log().d(TRACK_TAG, "TrackingManager --> processUrl --> 处理前 url = " + trackingBean.getLandingUrl());

        StringBuilder sb = new StringBuilder();

        if (isClickReport){
            sb.append("xd=" + pointBean.getDownX()); // X-DOWN         点击坐标（按）     String
            sb.append("&yd=" + pointBean.getDownY()); // Y-DOWN         点击坐标（按）     String
            sb.append("&xu=" + pointBean.getUpX()); // X-UP           点击坐标（弹）     String
            sb.append("&yu=" + pointBean.getUpY()); // Y-UP           点击坐标（弹）     String
        }
        sb.append("&ai=" + SspAd.AppId); //  APPID          点击的应用id     String

        sb.append("&pn=" + AppUtil.getPkgName()); //  PACKAGE-NAME   点击的app包名    String
        sb.append("&ve=" + AppUtil.getVersionName()); // VERSION        点击的app版本号   String
        sb.append("&sv=" + BuildConfig.VERSION_NAME); // SDK-VERSION    点击的sdk版本号   String
        sb.append("&ot=" + 1); // OS-TYPE        操作系统类型      String //1、Android；2、iOS
        sb.append("&ov=" + DeviceUtil.getSystemVersion()); // OS-VERSION     操作系统版本号     String

        sb.append("&nc=" + MitNetUtil.getNetType()); //  NET-CONN-TYPE  网络连接类型      String
        if (PostConstant.getMnc() != null && PostConstant.getMcc() != null) {
            sb.append("&op=" + PostConstant.getMnc() + PostConstant.getMcc()); // OPERATOR-TYPE  运营商类型       String
        }
        sb.append("&ga=" + DeviceUtil.getGAId()); // GAID           点击时的gaid    String
        sb.append("&dt=" + (DeviceInfo.isPad() ? 2 : 1)); // DEVICE-TYPE    设备类型        String
        sb.append("&br=" + Build.BRAND); // BRAND          机型品牌        String
        sb.append("&mo=" + Build.MODEL); // MODEL          客户端手机型号     String
        sb.append("&ma=" + Build.MANUFACTURER); // MAKER          设备制造商        String

        sb.append("&la=" + GPSTracker.getLatitude()); // LATITUDE       点击时的纬度      String
        sb.append("&lo=" + GPSTracker.getLongitude()); // LONGITUDE      点击时的经度      String

        sb.append("&iw=" + pointBean.getImageW()); // IMAGE-WIDTH    点击时素材宽      String
        sb.append("&ih=" + pointBean.getImageH()); // IMAGE-HEIGHT   点击时素材高      String
        // 双11版本新增 clickid --> ci
        sb.append("&ci=" + trackingBean.getClickid());
        // 1.3.0 是否是测试请求is_test_request
        sb.append("&tr=" + SspAd.isTestRequest());
        //是否安装推广应用
        sb.append("&ia=" + trackingBean.getIsInstallApk());
        AdLogUtil.Log().d(TRACK_TAG, "athena --> sb=" + sb.toString());
        //版本新增二价计费
        String url = trackingBean.getLandingUrl() + "&p1=" + AESUtils.encrypt(sb.toString()) + "&r1=" + AESUtils.encrypt(trackingBean.getPrice());
        AdLogUtil.Log().d(TRACK_TAG, "TrackingManager --> processUrl --> process after url = " + url);
        return url;
    }

    /**
     * 第三方归因服务
     * <p>
     * 回调链接宏替换参数
     * __CLICK_ID__
     * __CLICK_IP__
     * <p>
     * callback_url 里面的
     * __CLICK_ID__
     * __CLICK_TS__
     */
    private static String processTrackingUrls(String url, String clickId) {

        if (TextUtils.isEmpty(url)) {
            return url;
        }
        return replace(url, clickId);
    }

    /**
     * 宏替换
     *
     * @param url
     * @return
     */
    private static String replace(String url, String clickId) {
        if (url == null || clickId == null) {
            return url;
        }
        while (url.contains(CLICK_ID)) {
            url = url.replace(CLICK_ID, clickId);
        }
        String time = String.valueOf(System.currentTimeMillis() + AdxPreferencesHelper.getInstance().getLong(Constants.SERVICES_TIME_DIFFERENCE_VALUE));
        while (url.contains(CLICK_TS)) {
            url = url.replace(CLICK_TS, time);
        }
        //20220624 紧急去除AndroidId 判断本地是否可以获取到gaid
        if (TextUtils.isEmpty(DeviceUtil.getGAId())||TextUtils.equals(Constants.DEFAULT_EMPTY_GAID,DeviceUtil.getGAId())){
            String md5 = DeviceUtil.getAndroidIDMd5ToLowerCase();
            while (url.contains(ANDROID_ID_LOWER_MD5)) {
                url = url.replace(ANDROID_ID_LOWER_MD5, md5);
            }
        }
        String ip = DeviceUtil.getIp();
        while (url.contains(CLICK_IP)) {
            url = url.replace(CLICK_IP, ip);
        }
        return url;
    }
    /**
     * 保存 key value 的对象
     */
    private static class InnerClass {

        private String key;
        private String value;

        public InnerClass(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

}
