package com.cloud.hisavana.sdk.common.tranmeasure;

import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;


public abstract class VisibilityChecker {

    public static final int AD_VIEW_VISIBLE = 1;
    public static final int AD_VIEW_INVISIBLE = 2;
    protected final Rect mClipRect = new Rect();
    //1.3.0展示上报新增曝光面积
    protected String showAreaStr = "";

    protected static VisibilityChecker getChecker(MeasureInfo measureInfo){
        if(measureInfo == null){
            return null;
        }
        if(measureInfo.minVisiblePercent > 0){
            return new MinVisiblePercent();
        }
        else if(measureInfo.minVisiblePx > 0){
            return new MinVisiblePx();
        }
        return null;
    }

    protected abstract int checkVisiblity(MeasureInfo measureInfo,View adView);

    /**
     * 返回可见View的百分比
     */
    protected int check(MeasureInfo measureInfo, View adView){
        if(!isViewShow(adView) || measureInfo == null){
            //return AD_VIEW_INVISIBLE;
            return 0;
        }

        // 返回目标View的可见百分比
        int flag = checkVisiblity(measureInfo,adView);
        if (flag==0){
            return 0;
        }
        //if(flag == AD_VIEW_INVISIBLE){
            //return flag;
        //}

          // 这个不可以去掉，因为点击广告界面跳转之后，还是会返回100
        if(isViewCovered(adView)){
            //return AD_VIEW_INVISIBLE;
            return 0;
        }
        return flag;
    }

    private boolean isViewCovered(final View view) {
        if(view == null || view.getParent() == null){
            return false;
        }
        View currentView = view;
        while (currentView.getParent() instanceof ViewGroup) {
            ViewGroup currentParent = (ViewGroup) currentView.getParent();
            if (currentParent.getVisibility() != View.VISIBLE){//if the parent of view is not visible,return true
                return true;
            }
            //下面代码会有 3-4 ms的耗时，主要检测是否有覆盖物,暂时关闭
//            int start = indexOfViewInParent(currentView, currentParent);
//            if(start == -1){
//                return false;
//            }
//            for (int i = start + 1; i < currentParent.getChildCount(); i++) {
//                Rect viewRect = new Rect();
//                view.getGlobalVisibleRect(viewRect);
//                View otherView = currentParent.getChildAt(i);
//                if(otherView == null){
//                    continue;
//                }
//                Rect otherViewRect = new Rect();
//                otherView.getGlobalVisibleRect(otherViewRect);
//                if (Rect.intersects(viewRect, otherViewRect)){//if view intersects its older brother(covered),return true
//                    return true;
//                }
//            }
            currentView = currentParent;
        }
        return false;
    }

    private int indexOfViewInParent(View view, ViewGroup parent) {
        int index = -1;
        if(parent != null){
            for (index = 0; index < parent.getChildCount(); index++) {
                if (parent.getChildAt(index) == view)
                    break;
            }
        }
        return index;
    }

    private boolean isViewShow(View view){
        if (view == null || view.getVisibility() != View.VISIBLE || view.getAlpha() == 0.0f) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 19 && !view.isAttachedToWindow() || view.getRootView() == null){
            return false;
        }
        return true;
    }
}
