/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.http;

import android.content.Context;
import android.util.Log;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.http.RequestBase;
import com.cloud.hisavana.sdk.common.http.listener.DrawableResponseListener;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.transsion.core.CoreUtil;
import com.transsion.http.HttpClient;
import com.transsion.http.RequestCall;
import com.transsion.http.builder.ImageRequestBuilder;
import com.transsion.http.impl.HttpCallbackImpl;
import com.transsion.http.impl.IHttpCallback;
import java.util.List;
import java.util.Map;

public class DownLoadRequest
extends RequestBase<DrawableResponseListener> {
    boolean isSuccess = false;
    private AdsDTO adsDTO;
    private int m_type;
    private String url = "";
    private int isPreCache = 1;

    public DownLoadRequest setAdsDTO(AdsDTO ads, int type) {
        this.adsDTO = ads;
        this.m_type = type;
        return this;
    }

    public DownLoadRequest setUrl(String url) {
        this.url = url;
        return this;
    }

    public DownLoadRequest setListener(DrawableResponseListener listener) {
        this.mListener = listener;
        return this;
    }

    public DownLoadRequest setPreCache(int preCache) {
        this.isPreCache = preCache;
        return this;
    }

    @Override
    public void netRequestPreExecute() {
        this.netRequestPosExecute();
    }

    @Override
    protected void netRequestPosExecute() {
        try {
            RequestCall requestCall = ((ImageRequestBuilder)((ImageRequestBuilder)((ImageRequestBuilder)((ImageRequestBuilder)HttpClient.image((Context)CoreUtil.getContext()).log(false)).cache(true).connectTimeout(15000)).readTimeout(20000)).url(this.url)).build();
            requestCall.execute((IHttpCallback)new HttpCallbackImpl(true){

                public void onSuccess(int statusCode, byte[] data) {
                    if (DownLoadRequest.this.mListener != null && DownLoadRequest.this.mListener instanceof DrawableResponseListener) {
                        ((DrawableResponseListener)DownLoadRequest.this.mListener).onServerRequestSuccess(DownLoadRequest.this.isPreCache, statusCode, data, null);
                    }
                    DownLoadRequest.this.isSuccess = true;
                }

                public void onResponseHeader(Map<String, List<String>> map) {
                    super.onResponseHeader(map);
                    if (DownLoadRequest.this.isSuccess) {
                        List<String> strings;
                        DownLoadRequest.this.isSuccess = false;
                        String cdn = "";
                        if (null != map && !map.isEmpty() && null != (strings = map.get("x-response-cdn")) && !strings.isEmpty()) {
                            cdn = strings.get(0);
                        }
                        DownLoadRequest.this.downloadSuccess(1, cdn);
                    }
                }

                public void onFailure(int statusCode, byte[] bytes, Throwable throwable) {
                    if (DownLoadRequest.this.mListener != null) {
                        ((DrawableResponseListener)DownLoadRequest.this.mListener).onServerRequestFailure(statusCode, bytes, throwable);
                    }
                    DownLoadRequest.this.downloadError(1, throwable.getMessage());
                }

                public void onSuccess(int statusCode, byte[] responseBody, String filePath) {
                    if (DownLoadRequest.this.mListener != null && DownLoadRequest.this.mListener instanceof DrawableResponseListener) {
                        ((DrawableResponseListener)DownLoadRequest.this.mListener).onServerRequestSuccess(DownLoadRequest.this.isPreCache, statusCode, responseBody, filePath);
                    }
                    DownLoadRequest.this.isSuccess = true;
                }
            });
        }
        catch (Throwable e2) {
            AdLogUtil.Log().e(Log.getStackTraceString((Throwable)e2));
        }
    }

    private void downloadStart(int download_way) {
        AthenaTracker.trackImageDownload(this.adsDTO, download_way, 1, "", this.m_type, "");
    }

    private void downloadSuccess(int download_way, String cdn) {
        AthenaTracker.trackImageDownload(this.adsDTO, download_way, 2, "", this.m_type, cdn);
    }

    private void downloadError(int download_way, String errorMsg) {
        AthenaTracker.trackImageDownload(this.adsDTO, download_way, 3, errorMsg, this.m_type, "");
    }
}

