/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.transsion.core.utils.ScreenUtil;

public class ImageCompressUtil {
    public static Bitmap compressBytesArray(byte[] bitmapBytes) {
        if (bitmapBytes == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            AdLogUtil.Log().d("ssp", "BlurBgUtils ImageCompressUtil compressBytesArray \u56fe\u7247\u539f\u59cb\u5927\u5c0f\uff1a" + BitmapFactory.decodeByteArray((byte[])bitmapBytes, (int)0, (int)bitmapBytes.length).getAllocationByteCount());
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])bitmapBytes, (int)0, (int)bitmapBytes.length, (BitmapFactory.Options)options);
        int toWidth = ScreenUtil.getWinWidth();
        if (options.outWidth == 0 || options.outHeight == 0 || toWidth == 0) {
            return BitmapFactory.decodeByteArray((byte[])bitmapBytes, (int)0, (int)bitmapBytes.length);
        }
        AdLogUtil.Log().d("ssp", "BlurBgUtils ImageCompressUtil compressBytesArray \u539f\u59cb\u56fe\u7247\u7684\u5bbdwidth\uff1a" + options.outWidth + "\u539f\u59cb\u56fe\u7247\u7684\u9ad8height\uff1a" + options.outHeight);
        int toHeight = options.outHeight * toWidth / options.outWidth;
        options.inSampleSize = options.outWidth / toWidth;
        options.outWidth = toWidth;
        options.outHeight = toHeight;
        options.inPreferredConfig = Bitmap.Config.RGB_565;
        options.inPurgeable = true;
        options.inInputShareable = true;
        options.inJustDecodeBounds = false;
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])bitmapBytes, (int)0, (int)bitmapBytes.length, (BitmapFactory.Options)options);
        AdLogUtil.Log().d("ssp", "BlurBgUtils ImageCompressUtil compressBytesArray  \u538b\u7f29\u540ewidth\uff1a" + options.outWidth + "\u538b\u7f29\u540e\u56fe\u7247\u7684\u9ad8height\uff1a" + options.outHeight);
        AdLogUtil.Log().d("ssp", "BlurBgUtils ImageCompressUtil compressBytesArray  bitmap\u538b\u7f29\u540e\u56fe\u7247\u5185\u5b58\u5927\u5c0f\uff1a" + bitmap.getByteCount());
        return bitmap;
    }
}

