package com.cloud.hisavana.sdk.common.constant;

/**
 * @author: wenjing.luo
 * @date: 2021/08/09
 * ==================================
 * Copyright (c) 2021 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class Constants {

    public interface ResponseCode {
        /**
         * 业务成功
         * a
         */
        int BUSINESS_SUCCESS_CODE = 0;
    }

    public interface HOST {
        //TEST环境
        String ADN_TEST_SERVER_ADDRESS = "http://api.test.hisavana.com";
        //DEV环境
//        String ADN_DEV_SERVER_ADDRESS = "http://10.150.109.97:8081";
        //MOCK数据地址
        String ADN_MOCK_SERVER_ADDRESS = "http://mock-tmc.shalltry.com/mock/61810a476f76570a70b2098d";
        //RELEASE环境
        String ADN_RELEASE_SERVER_ADDRESS = "https://api.hisavana.com";
        //FAT环境
        String ADN_FAT_SERVER_ADDRESS = "http://api.fat1.hisavana.com";

        String API = "/isavana/trafficdispatch/v1/consumer-not-login/addispatch/query/getAdData";

        //1.3.0服务端曝光新增
        String ADN_FAT_SERVER_IMPRESSSION = "api.fat1.eagllwin.com";
        String ADN_TEST_SERVER_IMPRESSSION = "api.test.eagllwin.com";
        String ADN_PRE_SERVER_IMPRESSSION = "api.pre.eagllwin.com";
        String ADN_RELEASE_SERVER_IMPRESSSION = "api.eagllwin.com";
        //离线广告
        String OFF_LINE_URL = "https://transsion-eagllwin-website-static.oss-eu-central-1.aliyuncs.com/ad.json";//请求离线广告的url
    }

    public static int adChoiceViewSize = 9;
    public static String AD_SOURCE = "0";
    //clickUrls调起短信编辑页
    public static String SMSTO = "smsto:";
    public static String SMS_BODY = "sms_body";

    //代码位类型，1 native，2 banner，3插屏， 4 开屏
    public interface AdType {
        /**
         * Banner广告类型
         */
        int BANNER = 2;
        /**
         * 插屏广告类型
         */
        int INTERSTITIAL = 3;
        /**
         * Native广告类型
         */
        int NATIVE = 1;
        /**
         * Splash-Native广告类型
         */
        int SPLASH_NATIVE = 4;
    }
    //广告类别
    public interface AdCategory {
        int NORMAL_AD=0;
        int DEFAULT_AD = 1;
        int OFFLINE_AD = 2;
    }

    //展现上报时机类型
    public interface SHOW_REPORT_TIME_TYPE {
        /**
         * 展现时上报
         */
        int TYPE_SHOW = 1;
        /**
         * 达标时上报
         */
        int TYPE_UP_TO_STANDARD = 2;
        /**
         * 离开时上报
         */
        int TYPE_LEAVE = 3;
    }

    //曝光，点击上报 是否安装推广应用1.非下载类广告 2. 已安装目标下载应用 3.未安装目标下载应用
    public interface INSTALL_APK_STATUS {
        /**
         * 异常情况，android11+因为隐私保护，无法根据包名在安装列表中找到对应app
         */
        int ERROR_SITUATION = -1;
        /**
         * 非下载类广告
         */
        int NON_DOWNLOAD_AD = 1;
        /**
         * 已安装目标下载应用
         */
        int DOWNLOAD_APP_INSTALLED = 2;
        /**
         * 未安装目标下载应用
         */
        int DOWNLOAD_APP_NOT_INSTALLED = 3;
    }
    public static String ACTION_INTERSTITIAL_PREIMP = "_pre_imp";
    public static String ACTION_INTERSTITIAL_SHOW = "_show";
    public static String ACTION_INTERSTITIAL_ERROR = "_error";
    public static String ACTION_INTERSTITIAL_CLOSE = "_close";
    public static String ACTION_INTERSTITIAL_CLICK = "_click";
    public static String ACTION_INTERSTITIAL_ADCHOICE_CLICK = "_adchoice_click";
    /**
     * 约定无缓存是返回1
     */
    public static final long NO_CACHE_EXPIRA_TIME = 1;

    public interface LoadType {

        int CACHE = 0;
        int NET = 1;
    }

    /**
     * Media类型
     */
    public interface MIME {

        int IMG = 1;
        int GIF = 2;
        int VIDEO = 3;
    }

    public static final String JAVASCRIPT_INTERFACE = "VideoLoadInterface";

    /**
     * MediaView Tag
     */
    public interface ImageTag {

        String IMAGE_WEBVIEW = "image_webview";

        String ADX_CHOICE = "adxAdChoice";

        String DEFULT_BG = "#000000";
    }


    /**
     * MediaView Tag
     */
    public interface ImageLoadType {

        // 1 no cache/memory || 2 cache no memory || 3 cache memory

        int IMAGE_RAM_INCLUDED = 1;

        int IMAGE_PARSE = 2;

        int IMAGE_DISK_INCLUDED = 3;
    }

    public interface Config {
        String ALLOW_SKIP_OUT = "isAllowSkipOut";
        boolean ALLOW_SKIP_OUT_DEFAULT = true;
        String SENSITIVE_KEYWORDS = "sensitive_keywords";
    }

    public final static String PREF_NEW_CLOUD_CONTROL_VERSION = "new_config_ver";
    public final static String CLOUD_CONTROL_VERSION = "cloudControlVersion";
    public static final String OFF_LINE_CONFIG_VERSION = "off_line_config_version";//请求离线广告的配置version
    public static final String OFF_LINE_ENABLE = "off_line_enable";//是否展示离线广告的开关
    public static final String OFF_LINE_SHOW_COUNT_LIMIT = "off_line_show_count_limit";//每条离线广告的最多展示数
    public static final String OFF_LINE_REQUEST_TIME_INTERVAL = "off_line_request_time_interval";//离线广告配置请求间隔
    public static final String GET_OFF_LINE_AD_TIME = "get_off_line_ad_time";//缓存最新一次离线请求的时间
    /**
     * 保存 手机本地时间戳和 服务器差值
     */
    public final static String SERVICES_TIME_DIFFERENCE_VALUE="services_time_difference_value";

    /**
     * Banner 样式
     */
    public static final String BANNER_MATERIAL_STYLE_B3201 = "B3201";
    public static final String BANNER_MATERIAL_STYLE_B20301 = "B20301";
    public static final String BANNER_MATERIAL_STYLE_B20302 = "B20302";
    public static final String BANNER_MATERIAL_STYLE_B20303 = "B20303";
    public static final String BANNER_MATERIAL_STYLE_B20304 = "B20304";

    /**
     * 插屏样式
     */
    public static final String INTERSTITIAL_MATERIAL_STYLE_I1101 = "I1101";
    public static final String INTERSTITIAL_MATERIAL_STYLE_I1102 = "I1102";
    public static final String INTERSTITIAL_MATERIAL_STYLE_I1103 = "I1103";
    public static final String INTERSTITIAL_MATERIAL_STYLE_I1106 = "I1106";
    public static final String INTERSTITIAL_MATERIAL_STYLE_I1107 = "I1107";
    public static final String INTERSTITIAL_MATERIAL_STYLE_FA14 = "FA14";

    /**
     * 插屏广告 数据还原
     */
    public final static String INTERSTITIAL_APP_ID = "interstitial_app_id";

    public interface HTTP_TIME_OUT{
        int TIMEOUT_IN_MILLIONS = 15*1000;
        int READ_TIMEOUT_IN_MILLIONS = 15*1000;
    }

    public interface REQUEST_TYPE{

        int CLOD_START = 5;
        int NET_BROADCAST = 6;
        int AD_FILL = 7;
        int SWITCH_BACKSTAGE=8;
    }


    /**
     * 加载物料的时候 try-catch 了
     */
    public static final int DOWNLOAD_IMG_ERROR_CATCH_CODE = 101;

}
