package com.cloud.hisavana.sdk.common.tranmeasure;

import static com.cloud.hisavana.sdk.common.util.AdLogUtil.MEASURE_TAG;

import android.os.SystemClock;
import android.text.TextUtils;
import com.cloud.hisavana.sdk.R;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.common.tracking.ADExposureManager;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.offline.OffLineManager;

/**
 * 检测在这里完成的
 */
public class ImpressionValidChecker {

    private MeasureSession session;

    /**
     * 转交给这个来处理的
     */
    private VisibilityChecker visibilityChecker;

    /**
     * 计时用的时间戳
     */
    private long periodStartTimeStamp;

    /**
     * View 展示的累计时间
     */
    private long totalImpressionTime;

    /**
     * 是否已经曝光了
     */
    private boolean hasExposure = false;

    /**
     * 历史出现过的最高曝光比例
     */
    private int historyHighestExposureRatio = 0;

    /**
     * 曝光面积，宽*高，用于埋点上报
     */
    private String showAreaHighest;


    protected ImpressionValidChecker(MeasureSession session) {
        this.session = session;
        visibilityChecker = VisibilityChecker.getChecker(session.mMeasureInfo);
    }

    /**
     * 当前曝光面积是否大于0
     */
    protected int getVisibleArea() {
        if (null == session || null ==session.mMeasureInfo || null == visibilityChecker){
            return 0;
        }
        return visibilityChecker.check(session.mMeasureInfo, session.getAdView());
    }

    /**
     * 检查有效性
     */
    protected void checkValid() {
        if(visibilityChecker == null || session == null || session.mMeasureInfo == null || session.getAdView() == null){
            return;
        }
        if ((session.getmKey() instanceof AdsDTO) && session.getAdView().getTag(R.id.native_view_source) != null
                && !TextUtils.equals(Constants.AD_SOURCE,session.getAdView().getTag(R.id.native_view_source).toString())) {
           if (session.getAdView().getTag(R.id.native_view_source) != null){
               AdLogUtil.Log().d(MEASURE_TAG,"session.AdView.Tag" + session.getAdView().getTag(R.id.native_view_source).toString());
            }
            return;
        }

        // 如果界面 stop 了 直接 上报离开事件 默认 false
        if (session.isStop()){
            trackLeaveShow();
            return;
        }

        // 检查View在Window的可见性 返回百分比
        int exposureRatio = getVisibleArea();

        // 曝光回调
        if (exposureRatio > 0 && !session.isImpression() && null != session.mImpressionListener){
            session.setImpression(true);
            session.mImpressionListener.onViewImpressed(session.getmKey());

            // 展现上报
            AdsDTO info = (AdsDTO) session.getmKey();
            info.setShowReportTimeType(Constants.SHOW_REPORT_TIME_TYPE.TYPE_SHOW);
            ADExposureManager.exposureInvalid(info);
        }

        // 保存历史出现过的最大曝光比例
        if (exposureRatio > historyHighestExposureRatio){
            historyHighestExposureRatio = exposureRatio;
            //当前曝光历史最高曝光面积，宽*高，用于埋点上报
            showAreaHighest = visibilityChecker.showAreaStr;
        }

        // 可见一个像素，即可开始计时
        if (exposureRatio > 0) {
            if (!hasExposure) {
                AdLogUtil.Log().d(MEASURE_TAG,"检查View在Window的可见性 返回百分比 --> exposureRatio = " + exposureRatio + " totalImpressionTime=" + totalImpressionTime);
            }

            if (periodStartTimeStamp > 0) {
                totalImpressionTime = totalImpressionTime + (SystemClock.uptimeMillis() - periodStartTimeStamp);
            }
            periodStartTimeStamp = SystemClock.uptimeMillis();

            // 曝光时长>1000ms && 曝光面积>50 && 是否有效曝光过
            if (checkImpressionTime() && exposureRatio >= session.mMeasureInfo.minVisiblePercent && !hasExposure) {
                // 有效曝光
                hasExposure = true;
                //1.3.0达标时上报
                if (session.getmKey() instanceof AdsDTO) {
                    AdsDTO info = (AdsDTO) session.getmKey();
                    if (null != info){
                        info.setShowReportTimeType(Constants.SHOW_REPORT_TIME_TYPE.TYPE_UP_TO_STANDARD);
                        info.setActualShowRate(historyHighestExposureRatio);
                        info.setShowArea(showAreaHighest);
                        info.setActualShowTime(totalImpressionTime);
                    }
                    if(session.getAdValid()){
                        ADExposureManager.exposureValid(info);
                    }else{
                        ADExposureManager.exposureInvalid(info);
                    }

                } else {
                    AdLogUtil.Log().d(MEASURE_TAG,"session.getmKey() instanceof AdsDTO --> false");
                }
            }
        } else {
            //1.3.0离开时上报
            trackLeaveShow();
        }
    }

    /**
     * 1.3.0 离开时上报
     */
    private void trackLeaveShow(){
        // 不可见的时候判断一下 曾经是否可见过
        if (totalImpressionTime > 0) {
            // 曾经曝光面积大于过 50% --> 有效曝光
            if (historyHighestExposureRatio >= session.mMeasureInfo.minVisiblePercent && totalImpressionTime > 1000){
                // 有效曝光
                if (session.getmKey() instanceof AdsDTO) {
                    AdsDTO info = (AdsDTO) session.getmKey();
                    if (null != info){
                        info.setShowReportTimeType(Constants.SHOW_REPORT_TIME_TYPE.TYPE_LEAVE);
                        info.setActualShowRate(historyHighestExposureRatio);
                        info.setShowArea(showAreaHighest);
                        info.setActualShowTime(totalImpressionTime);
                    }
                    if(session.getAdValid()){
                        ADExposureManager.exposureValid(info);
                    }else{
                        ADExposureManager.exposureInvalid(info);
                    }
                } else {
                    AdLogUtil.Log().d(MEASURE_TAG,"session.getmKey() instanceof AdsDTO --> false");
                }
            }else{
                // 无效曝光
                if (session.getmKey() instanceof AdsDTO) {
                    AdsDTO info = (AdsDTO) session.getmKey();
                    if (null != info){
                        info.setShowReportTimeType(Constants.SHOW_REPORT_TIME_TYPE.TYPE_LEAVE);
                        info.setActualShowRate(historyHighestExposureRatio);
                        info.setShowArea(showAreaHighest);
                        info.setActualShowTime(totalImpressionTime);
                    }
                    ADExposureManager.exposureInvalid(info);
                } else {
                    AdLogUtil.Log().d(MEASURE_TAG,"session.getmKey() instanceof AdsDTO --> false");
                }
            }

            AdLogUtil.Log().d(MEASURE_TAG,"totalImpressionTime=" + totalImpressionTime);
        }
        // 重置数据
        totalImpressionTime = 0;
        hasExposure = false;
        periodStartTimeStamp = 0;
        historyHighestExposureRatio = 0;
        showAreaHighest = "";
    }
    /**
     * 检查曝光时间是否满足
     */
    private boolean checkImpressionTime() {
        if (session != null && session.mMeasureInfo != null) {
            return totalImpressionTime >= session.mMeasureInfo.minImpressionTime;
        }
        return false;
    }

    /**
     * 销毁时进行离开时上报
     */
    protected void beforeFinish2Impression() {
        trackLeaveShow();
    }


}
