package com.cloud.hisavana.sdk.internal.native_;

import android.text.TextUtils;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;

import com.cloud.hisavana.sdk.api.config.AdsConfig;
import com.cloud.hisavana.sdk.api.config.AdsConfig.DownloadType;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.bean.AdImage;
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.EmptyUtil;
import com.cloud.hisavana.sdk.common.util.ImageDownloadHelper;
import com.cloud.hisavana.sdk.common.util.ImageDownloadHelper.ImageListener;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * 传音原生广告
 *
 * @author 孙志刚.
 * @date 2016/12/12.
 * ==================================
 * Copyright (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class NativeGemini {

    private long oldTime;
    private static final long DOUBLECLICK = 2 * 1000;

    private TranNative mNative;
    private List<AdsDTO> mAdBeans;
    private List<TaNativeInfo> nativeInfos = null;
    /**
     * 保存当前所有广告和View信息
     */
    private Map<TaNativeInfo, List<View>> mViewMap = new HashMap<>();


    // =============================================================================================


    NativeGemini(TranNative tranNative) {
        this.mNative = tranNative;
    }


    // =============================================================================================


    public boolean loadAd() {
        this.mAdBeans = mNative.adBeans();
        boolean isResetTimer = false;
        if (EmptyUtil.isCollectionNotEmpty(mAdBeans)) {

            // TODO  数据类型 转换 从这里开始 数据类型就变了 ==============================================
            nativeInfos = mNative.polyNative().getNativeInfoList(mAdBeans);

            if (EmptyUtil.isCollectionNotEmpty(nativeInfos)) {
                if (mNative.isUnifiedCallback()) {
                    unifiedDownload(); //目前Native不支持多条，只开放这种方式
                } else {
                    singleDownload();
                }
                isResetTimer = true;
            } else {
                if (mNative.adListener() != null) {
                    mNative.adListener().onError(
                            new TaErrorCode(TaErrorCode.UNKNOWN_ERROR_CODE_2, "PlatformUtil.getTadNativeInfoList(mAdBeans) return is empty"));
                }
            }
        } else {
            if (mNative.adListener() != null) {
                mNative.adListener().onError(TaErrorCode.RESPONSE_AD_IS_EMPTY);
            }
        }
        return isResetTimer;
    }

    private void unifiedDownload() {
        switch (mNative.getFillType()) {
            case AdsConfig.FillType.ALL:
                // 下载图片
                downloadUnifiedMedia(getImages(nativeInfos));
                break;

            case AdsConfig.FillType.ICON:
                downloadUnifiedMedia(getImages(nativeInfos, false, true));
                break;

            case AdsConfig.FillType.IMAGE:
            default:
                downloadUnifiedMedia(getImages(nativeInfos, true, false));
                ImageDownloadHelper.preCacheNativeImageList(
                        getImages(nativeInfos, false, true), null, true);
                break;
        }
        for (TaNativeInfo nativeInfo : nativeInfos) {
            downloadAdChoice(nativeInfo);
        }
    }

    private void downloadUnifiedMedia(List<AdImage> images) {
        ImageDownloadHelper.preCacheNativeImageList(images, getImageListener(), true);
    }

    private void singleDownload() {
        final AtomicInteger counter = new AtomicInteger(nativeInfos.size());
        List<TaNativeInfo> infoList = new ArrayList<>();
        for (final TaNativeInfo nativeInfo : nativeInfos) {
            switch (mNative.getFillType()) {
                case AdsConfig.FillType.ALL:
                    infoList.clear();
                    infoList.add(nativeInfo);
                    ImageDownloadHelper.preCacheNativeImageList(getImages(infoList),
                            getImageListener(nativeInfo, counter, DownloadType.SINGLE), false);
                    break;

                case AdsConfig.FillType.ICON:
                    downloadSingleMedia(counter, nativeInfo, nativeInfo.getIconImage());
                    break;

                case AdsConfig.FillType.IMAGE:
                default:
                    if (nativeInfo.getImage() != null) {
                        nativeInfo.getImage().preCache = Constants.ImageLoadType.IMAGE_PARSE;
                    }
                    ImageDownloadHelper.preCacheNativeImage(nativeInfo.getIconImage(), null);
                    downloadSingleMedia(counter, nativeInfo, nativeInfo.getImage());
                    break;
            }

            downloadAdChoice(nativeInfo);
        }
    }

    private void downloadSingleMedia(AtomicInteger counter, TaNativeInfo nativeInfo, AdImage image) {
        ImageDownloadHelper.preCacheNativeImage(image, getImageListener(nativeInfo, counter, DownloadType.SINGLE));
    }

    void downloadMedia(final TaNativeInfo ad) {
        if (mNative == null || ad == null || EmptyUtil.isCollectionNotEmpty(mAdBeans)) {
            return;
        }
        ImageDownloadHelper.preCacheNativeImage(ad.getImage(),
                getImageListener(ad, DownloadType.MEDIA));
    }

    private void downloadAdChoice(final TaNativeInfo nativeInfo) {
        if (!containAdChoice(nativeInfo)) {
            return;
        }

        ImageDownloadHelper.downloadImage(nativeInfo.acImageUrl,
                Constants.ImageLoadType.IMAGE_DISK_INCLUDED, nativeInfo.adItem, AthenaTracker.M_TYPE_AD_CHOICE_VIEW, getImageListener(nativeInfo, DownloadType.ADCHOICE));
    }

    private ImageDownloadHelper.ImageListener getImageListener() {
        return getImageListener(null, null, DownloadType.UNIFIED);
    }

    private ImageListener getImageListener(TaNativeInfo nativeInfo, int downloadType) {
        return getImageListener(nativeInfo, null, downloadType);
    }

    private ImageListener getImageListener(final TaNativeInfo nativeInfo,
                                           final AtomicInteger counter, final int downloadType) {
        return new ImageListener() {
            @Override
            public void onImagesCached(byte[] data) {
                switch (downloadType) {
                    case AdsConfig.DownloadType.UNIFIED:
                        mNative.setLoading(false);
                        if (mNative.adListener() != null) {
                            mNative.adListener().onAdLoaded(nativeInfos);
                        }
                        break;

                    case DownloadType.ADCHOICE:
                        if (nativeInfo != null) {
                            nativeInfo.isACReady = true;
                        }
                        break;

                    case DownloadType.MEDIA:
                        if (mNative.adListener() != null) {
                            mNative.adListener().onMediaDownloaded(nativeInfo);
                        }
                        break;

                    case DownloadType.SINGLE:
                    default:
                        if (counter.decrementAndGet() == 0) {
                            mNative.loadFinished();
                        }

                        if (mNative.adListener() != null) {
                            mNative.setOneByOne(nativeInfos != null && nativeInfos.size() > 1);
                            mNative.adListener().onAdLoaded(nativeInfos);
                        }
                        break;
                }
            }

            @Override
            public void onImagesFailedToCache(TaErrorCode errorCode) {
                switch (downloadType) {
                    case DownloadType.UNIFIED:
                        mNative.setLoading(false);
                        break;

                    case DownloadType.ADCHOICE:
                        if (nativeInfo != null) {
                            nativeInfo.isACReady = false;
                        }
                        break;

                    case DownloadType.MEDIA:
                        break;

                    case DownloadType.SINGLE:
                    default:
                        if (counter.decrementAndGet() == 0) {
                            mNative.setLoading(false);
                        }
                        break;
                }

                if (mNative.adListener() != null && DownloadType.ADCHOICE != downloadType) {
                    mNative.setOneByOne(DownloadType.SINGLE == downloadType
                            && nativeInfos != null && nativeInfos.size() > 1);
                    mNative.adListener().onError(errorCode);
                }
            }
        };
    }

    private boolean containAdChoice(TaNativeInfo nativeInfo) {
        return null != nativeInfo && !TextUtils.isEmpty(nativeInfo.acImageUrl);
    }

    List<TaNativeInfo> getNativeInfos() {
        return nativeInfos;
    }

    void adImpression(TaNativeInfo nativeInfo) {
        if (mNative.adListener() != null) {
            mNative.adListener().onAdShow();
        }
    }

    /**
     * View 点击事件 注册
     */
    void registerViewForInteraction(View view, List<View> adContains, TaNativeInfo nativeInfo, AdsDTO adBean) {
        if (adContains != null) {
            Iterator iterator = adContains.iterator();
            mViewMap.put(nativeInfo, adContains);
            TChildViewOnTouchListener onTouchListener = new TChildViewOnTouchListener();
            TChildViewOnClickListener clickListener = new TChildViewOnClickListener(adBean, nativeInfo);
            if (view != null) {
                view.setOnTouchListener(onTouchListener);
                view.setOnClickListener(clickListener);
            }
            while (iterator.hasNext()) {
                View child = (View) iterator.next();
                if (child == null) {
                    continue;
                }
                if (getTagContinue(child)) {
                    continue;
                }
                child.setOnClickListener(clickListener);
            }
        }
    }

    private boolean getTagContinue(View v) {
        if (v == null || v.getTag() == null) {
            return false;
        }
        if (v.getTag().equals(Constants.ImageTag.ADX_CHOICE)
                || v.getTag().equals(Constants.ImageTag.IMAGE_WEBVIEW)) {
            return true;
        }
        return false;
    }

    private void unregisterView() {
        for (Map.Entry entry : mViewMap.entrySet()) {
            List<View> views = (List<View>) entry.getValue();
            if (views == null) {
                continue;
            }
            for (View view : views) {
                view.setOnClickListener(null);
                view.setOnTouchListener(null);
            }
        }
        mViewMap.clear();
    }

    void unregisterView(TaNativeInfo adNativeInfo) {
        if (adNativeInfo == null) {
            return;
        }
        List<View> adContains = mViewMap.get(adNativeInfo);
        if (EmptyUtil.isCollectionNotEmpty(adContains)) {
            for (View view : adContains) {
                view.setOnClickListener(null);
                view.setOnTouchListener(null);
            }
            mViewMap.remove(adNativeInfo);
        }
    }

    public void destroy() {
        unregisterView();
        AdLogUtil.Log().d(AdLogUtil.TAG,"destroy");
    }


    private float downX = -1;
    private float downY = -1;
    private float upX = -1;
    private float upY = -1;

    private class TChildViewOnTouchListener implements View.OnTouchListener {

        @Override
        public boolean onTouch(View v, MotionEvent event) {
            switch (event.getAction()) {
                case MotionEvent.ACTION_DOWN:
                    downX = event.getX();
                    downY = event.getY();

                case MotionEvent.ACTION_UP:
                    upX = event.getX();
                    upY = event.getY();
                    break;

                default:
                    break;
            }
            return false;
        }
    }

    private class TChildViewOnClickListener implements View.OnClickListener {
        private AdsDTO adBean;
        private TaNativeInfo nativeInfo;

        TChildViewOnClickListener(AdsDTO adBean, TaNativeInfo nativeInfo) {
            this.adBean = adBean;
            this.nativeInfo = nativeInfo;
        }

        @Override
        public void onClick(View v) {

            if (v != null && adBean != null) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - oldTime > DOUBLECLICK) {
                    try {
                        Log.i("zxb_log", "onClick: 点击广告");
                        // ADX Tracker
                        mNative.polyNative().startLandingPage(v.getContext(),  adBean,
                                new DownUpPointBean(downX, downY, upX, upY,
                                        v.getMeasuredHeight(), v.getMeasuredWidth()));
                        if (mNative.adListener() != null) {
                            mNative.adListener().onAdClicked(new DownUpPointBean(downX, downY, upX, upY,
                                    v.getMeasuredHeight(), v.getMeasuredWidth()));
                        }
                        oldTime = currentTime;
                    } catch (Throwable e) {
                        AdLogUtil.Log().e(Log.getStackTraceString(e));
                    }
                }
            }
        }
    }

    private List<AdImage> getImages(List<TaNativeInfo> nativeInfos) {
        return getImages(nativeInfos, true, true);
    }

    private List<AdImage> getImages(List<TaNativeInfo> nativeInfos,
                                    boolean witchImage, boolean withIcon) {
        final List<AdImage> images = new ArrayList<>();
        for (TaNativeInfo nativeInfo : nativeInfos) {
            if (nativeInfo == null) {
                continue;
            }


            if (nativeInfo.getImage() != null && witchImage) {
                nativeInfo.getImage().preCache = Constants.ImageLoadType.IMAGE_PARSE;

                // 埋点用的
                nativeInfo.getImage().adsDTO = nativeInfo.adItem;
                images.add(nativeInfo.getImage());
            }
            if (nativeInfo.getIconImage() != null && withIcon) {
                nativeInfo.getIconImage().preCache = Constants.ImageLoadType.IMAGE_RAM_INCLUDED;

                // 埋点用的
                nativeInfo.getIconImage().adsDTO = nativeInfo.adItem;
                nativeInfo.getIconImage().setmType(AthenaTracker.M_TYPE_LOGO);
                images.add(nativeInfo.getIconImage());
            }
        }
        return images;
    }
}