/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.http;

import android.content.Context;
import android.util.Log;
import com.cloud.hisavana.sdk.api.config.SspAd;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.http.RequestBase;
import com.cloud.hisavana.sdk.common.http.listener.DrawableResponseListener;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.transsion.core.CoreUtil;
import com.transsion.http.HttpClient;
import com.transsion.http.ImageURL;
import com.transsion.http.RequestCall;
import com.transsion.http.builder.ImageRequestBuilder;
import com.transsion.http.cache.IDiskCache;
import com.transsion.http.d;
import com.transsion.http.impl.HttpCallbackImpl;
import com.transsion.http.impl.IHttpCallback;
import java.io.File;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public class DownLoadRequest
extends RequestBase<DrawableResponseListener> {
    private static final int HTTP_IMAGE_CACHE = 250;
    boolean isSuccess = false;
    long fileSize = 0L;
    String cdn = "";
    long startTime = 0L;
    int errorCode = -1;
    int downloadWay = 1;
    private AdsDTO adsDTO;
    private int mType;
    private int requestType = 1;
    private boolean isFetchFilePath = false;
    private boolean isOffLine = false;
    private String url = "";
    private int isPreCache = 1;

    public DownLoadRequest setAdsDTO(AdsDTO ads, int type) {
        this.adsDTO = ads;
        this.mType = type;
        if (ads != null) {
            this.isOffLine = ads.isOffLineAd();
        }
        return this;
    }

    public DownLoadRequest setUrl(String url) {
        this.url = url;
        return this;
    }

    public DownLoadRequest setOffLine(boolean isOffLine) {
        this.isOffLine = isOffLine;
        return this;
    }

    public DownLoadRequest setFetchFilePath(boolean isFetchFilePath) {
        this.isFetchFilePath = isFetchFilePath;
        return this;
    }

    public DownLoadRequest setListener(DrawableResponseListener listener) {
        this.mListener = listener;
        return this;
    }

    public DownLoadRequest setPreCache(int preCache) {
        this.isPreCache = preCache;
        return this;
    }

    @Override
    public void netRequestPreExecute() {
        this.netRequestPosExecute();
    }

    @Override
    protected void netRequestPosExecute() {
        AdLogUtil.Log().d("offline", "\u5f00\u59cb\u4e0b\u8f7d -- type =" + this.mType);
        try {
            RequestCall requestCall = ((ImageRequestBuilder)((ImageRequestBuilder)((ImageRequestBuilder)((ImageRequestBuilder)((ImageRequestBuilder)HttpClient.image((Context)CoreUtil.getContext()).log(false)).useOffLineCache(this.isOffLine).fetchFilePath(this.isFetchFilePath)).cache(true).connectTimeout(15000)).readTimeout(20000)).url(this.url)).build();
            IDiskCache iDiskCache = requestCall.getDiskCache();
            ImageURL imageURL = new ImageURL(this.url);
            AdLogUtil.Log().d("offline", "\u56fe\u7247url\u7684MD5\u503c ==" + (SspAd.isDebug() ? imageURL.toMD5() : ""));
            File file = iDiskCache.get((d)imageURL);
            if (file != null && file.exists()) {
                AdLogUtil.Log().d("ssp", "netRequestPosExecute cache is true,url " + this.url);
                AdLogUtil.Log().d("DownLoadRequest", "\u5f53\u524d\u7684file\u7684\u8def\u5f84 == " + file.getAbsolutePath());
                this.requestType = 2;
            } else {
                AdLogUtil.Log().d("ssp", "\u8be5\u56fe\u7247\u4e0d\u5b58\u5728---- url == " + this.url);
                this.requestType = 1;
            }
            this.startTime = System.currentTimeMillis();
            this.downloadTrack(1);
            requestCall.execute((IHttpCallback)new HttpCallbackImpl(true){

                public void onSuccess(int statusCode, byte[] data) {
                    AdLogUtil.Log().d("ssp", "onSuccess statusCode " + statusCode + " url " + DownLoadRequest.this.url);
                    if (DownLoadRequest.this.mListener != null && DownLoadRequest.this.mListener instanceof DrawableResponseListener) {
                        ((DrawableResponseListener)DownLoadRequest.this.mListener).onServerRequestSuccess(DownLoadRequest.this.isPreCache, statusCode, data, null);
                    }
                    DownLoadRequest.this.isSuccess = true;
                    if (null != data) {
                        DownLoadRequest.this.fileSize = data.length;
                    }
                    if (statusCode == 250) {
                        DownLoadRequest.this.downloadTrack(2);
                    }
                }

                public void onResponseHeader(Map<String, List<String>> map) {
                    super.onResponseHeader(map);
                    if (DownLoadRequest.this.isSuccess) {
                        List<String> strings;
                        DownLoadRequest.this.isSuccess = false;
                        if (null != map && !map.isEmpty() && null != (strings = map.get("x-response-cdn")) && !strings.isEmpty()) {
                            DownLoadRequest.this.cdn = strings.get(0);
                        }
                        DownLoadRequest.this.downloadTrack(2);
                    }
                }

                public void onFailure(int statusCode, byte[] bytes, Throwable throwable) {
                    AdLogUtil.Log().d("ssp", "onFailure statusCode " + statusCode + " e" + throwable + " url " + DownLoadRequest.this.url);
                    if (DownLoadRequest.this.mListener != null) {
                        ((DrawableResponseListener)DownLoadRequest.this.mListener).onServerRequestFailure(statusCode, bytes, throwable);
                    }
                    DownLoadRequest.this.errorCode = statusCode;
                    DownLoadRequest.this.downloadTrack(3);
                }

                public void onSuccess(int statusCode, byte[] responseBody, String filePath) {
                    AdLogUtil.Log().d("ssp", "onSuccess statusCode " + statusCode + " filePath " + filePath + " url" + DownLoadRequest.this.url);
                    if (DownLoadRequest.this.mListener != null && DownLoadRequest.this.mListener instanceof DrawableResponseListener) {
                        ((DrawableResponseListener)DownLoadRequest.this.mListener).onServerRequestSuccess(DownLoadRequest.this.isPreCache, statusCode, responseBody, filePath);
                    }
                    DownLoadRequest.this.isSuccess = true;
                    if (null != responseBody) {
                        DownLoadRequest.this.fileSize = responseBody.length;
                    }
                    if (statusCode == 250) {
                        DownLoadRequest.this.downloadTrack(2);
                    }
                }
            });
        }
        catch (Throwable e2) {
            AdLogUtil.Log().e(Log.getStackTraceString((Throwable)e2));
            this.errorCode = 101;
            this.downloadTrack(3);
        }
    }

    private void downloadTrack(int mStatus) {
        AthenaTracker.trackImageDownload(this.adsDTO, this.requestType, this.downloadWay, mStatus, this.errorCode, this.mType, this.cdn, System.currentTimeMillis() - this.startTime, DownLoadRequest.getSize(this.fileSize));
    }

    public static int getSize(long byteSize) {
        int size = 0;
        try {
            BigDecimal sizeNew = new BigDecimal(byteSize);
            size = sizeNew.divide(BigDecimal.valueOf(1024L), 0, 4).intValue();
        }
        catch (Exception e2) {
            AdLogUtil.Log().d("ssp", Log.getStackTraceString((Throwable)e2));
        }
        return size;
    }
}

