/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Environment;
import android.text.TextUtils;
import com.cloud.hisavana.sdk.api.config.SspAd;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.transsion.core.CoreUtil;
import com.transsion.core.utils.PermissionUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;

public class FileUtil {
    public static File getAppDateFilePath() {
        Context context = CoreUtil.getContext();
        if (PermissionUtil.lacksPermissions((String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"})) {
            return null;
        }
        return context.getExternalFilesDir(null);
    }

    public static File getAppDateCachePath() {
        Context context = CoreUtil.getContext();
        return context.getExternalCacheDir();
    }

    public static File getDiskCacheDir(Context context, String uniqueName) {
        String cachePath = "mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable() ? context.getExternalCacheDir().getPath() : context.getCacheDir().getPath();
        return new File(cachePath + File.separator + uniqueName);
    }

    public static void saveBitmapToFile(File dirFile, Bitmap bm, String fileName) throws IOException {
        if (dirFile == null || bm == null || TextUtils.isEmpty((CharSequence)fileName)) {
            return;
        }
        if (!dirFile.exists()) {
            dirFile.mkdir();
        }
        File myCaptureFile = new File(dirFile + File.separator + fileName);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(myCaptureFile));
        bm.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)bos);
        bos.flush();
        bos.close();
    }

    public static void saveBytesToFile(File dir, byte[] bytes, String fileName) throws IOException {
        if (dir == null || bytes == null || bytes.length == 0 || TextUtils.isEmpty((CharSequence)fileName)) {
            return;
        }
        if (!dir.exists()) {
            dir.mkdir();
        }
        File myCaptureFile = new File(dir + File.separator + fileName);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(myCaptureFile));
        bos.write(bytes);
        bos.flush();
        bos.close();
    }

    public static String getStrFile(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return "";
        }
        File file = new File(filePath);
        if (file == null) {
            return "";
        }
        try {
            int charsRead;
            int bufferSize = 1024;
            char[] buffer = new char[1024];
            StringBuilder out = new StringBuilder();
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
            InputStreamReader in = new InputStreamReader((InputStream)stream, "UTF-8");
            while ((charsRead = ((Reader)in).read(buffer, 0, buffer.length)) > 0) {
                out.append(buffer, 0, charsRead);
            }
            AdLogUtil.Log().d("ssp", "\u8bfb\u53d6\u7684\u5185\u5bb9 === " + (SspAd.isDebug() ? out.toString() : ""));
            return out.toString();
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
            return "";
        }
        catch (IOException e3) {
            e3.printStackTrace();
            return "";
        }
    }
}

