/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.widget;

import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.widget.ViewGestureListener;

public class ViewGestureDetector
extends GestureDetector {
    private final View mView;
    private ViewGestureListener mGestureListener = null;
    private boolean mTouchOutOfView = false;
    private UserClickListener mUserClickListener;

    public ViewGestureDetector(Context context, View view) {
        this(context, view, new ViewGestureListener());
    }

    private ViewGestureDetector(Context context, View view, ViewGestureListener listener) {
        super(context, (GestureDetector.OnGestureListener)listener);
        this.mGestureListener = listener;
        this.mView = view;
        this.setIsLongpressEnabled(false);
    }

    public void sendTouchEvent(MotionEvent motionEvent) {
        switch (motionEvent.getAction()) {
            case 1: {
                if (!this.mTouchOutOfView && this.mUserClickListener != null) {
                    this.mUserClickListener.onUserClick(motionEvent.getX(), motionEvent.getY());
                    break;
                }
                AdLogUtil.Log().d("ssp", "View's onUserClick() is not registered.");
                break;
            }
            case 0: {
                this.mTouchOutOfView = false;
                this.onTouchEvent(motionEvent);
                break;
            }
            case 2: {
                if (this.isMotionEventInView(motionEvent, this.mView)) {
                    this.onTouchEvent(motionEvent);
                    break;
                }
                this.mTouchOutOfView = true;
                break;
            }
        }
    }

    public void setUserClickListener(UserClickListener listener) {
        this.mUserClickListener = listener;
    }

    void resetAdFlaggingGesture() {
    }

    private boolean isMotionEventInView(MotionEvent motionEvent, View view) {
        if (motionEvent == null || view == null) {
            return false;
        }
        float x = motionEvent.getX();
        float y = motionEvent.getY();
        return x >= 0.0f && x <= (float)view.getWidth() && y >= 0.0f && y <= (float)view.getHeight();
    }

    public static interface UserClickListener {
        public void onUserClick(float var1, float var2);
    }
}

