package com.cloud.hisavana.sdk.ad.base;

import static com.cloud.hisavana.sdk.common.util.AdLogUtil.LOAD_TAG;
import static com.cloud.hisavana.sdk.common.util.AdLogUtil.OFF_LINE_TAG;
import static com.cloud.hisavana.sdk.common.util.AdLogUtil.SPLASH_OFF_LINE_TAG;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.widget.RelativeLayout;

import com.cloud.hisavana.sdk.api.config.SspAd;
import com.cloud.hisavana.sdk.api.view.AAdChoicesView;
import com.cloud.hisavana.sdk.common.adapter.IAdPoly;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.callback.InternalAdListener;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.AdServerRequest;
import com.cloud.hisavana.sdk.common.http.ServicesTimeUtil;
import com.cloud.hisavana.sdk.common.http.listener.CommonResponseListener;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.ImageDownloadHelper;
import com.cloud.hisavana.sdk.config.AdxServerConfig;
import com.cloud.hisavana.sdk.data.bean.request.AdxImpBean;
import com.cloud.hisavana.sdk.data.bean.response.AdResponseBody;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.offline.OffLineManager;
import com.transsion.core.CoreUtil;
import com.transsion.core.utils.ScreenUtil;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * Created by jianbing.yu on 2019/3/26.
 */

public abstract class AdxBaseAd implements IAdPoly {

    protected InternalAdListener mBridgeListener = null;
    private AdServerRequest adServerRequest;
    private int mAdType;
    protected int mAdCount;
    protected String mPlacementId;
    protected List<AdsDTO> mAdBeans = null;
    private AdxImpBean impBean;

    public AdxBaseAd(String placementId, int adType) {
        this.mPlacementId = placementId;
        this.mAdType = adType;
        this.mAdCount = 1;
    }

    protected void setAdCount(int adCount) throws IndexOutOfBoundsException {
        if (adCount > 5) {
            this.mAdCount = 5;
        } else if (adCount < 1) {
            this.mAdCount = 1;
        } else {
            this.mAdCount = adCount;
        }
    }

    /**
     * 所有的广告点击 都走这里
     */
    @Override
    public boolean startLandingPage(Context context, AdsDTO adBean, DownUpPointBean pointBean) {
        if (adBean != null) {
            return PlatformUtil.startActivity(context, adBean, pointBean);
        }
        return false;
    }

    @Override
    public void setAdListener(@NonNull InternalAdListener bridgeListener) {
        this.mBridgeListener = bridgeListener;
    }

    /**
     * 加载广告
     */
    public boolean loadAd(final String requestId, int requestType) {

        AdLogUtil.Log().w(LOAD_TAG, "*----> start load ad...  当前环境 url = " + AdxServerConfig.getServerUrl());

        /**
         * 申请广告
         */
        reset();

        /**
         * 广告请求信息
         */
        impBean = new AdxImpBean();
        impBean.adt = mAdType;
        impBean.pmid = mPlacementId;
        impBean.mAdCount = mAdCount;
        impBean.defaultAd = false;
        impBean.requestId = requestId;
        impBean.requestType = requestType;


        /**
         * 网络请求
         */
        adServerRequest = new AdServerRequest().setListener(new CommonResponseListener<AdResponseBody>() {
            @Override
            protected void onRequestSuccess(int statusCode, AdResponseBody response) {

                // 保存服务器时间
                ServicesTimeUtil.saveServicesTime(response);

                if (response != null && response.getCode() == Constants.ResponseCode.BUSINESS_SUCCESS_CODE) {
                    AdLogUtil.Log().d(LOAD_TAG, "start load ad... \n -1-> impBean = " + impBean.toString() + " \n -2-> got data from net, response is : " + response.toString());

                    if (response.getData() != null
                            && response.getData().getAds() != null
                            && response.getData().getAds().size() > 0) {
                        mAdBeans = response.getData().getAds();
                        if (!TextUtils.equals(response.getData().getCodeSeatId(), mPlacementId)) {
                            AdLogUtil.Log().d(LOAD_TAG, "response pmid is diffrent with request's");

                            if (mBridgeListener != null) {
                                mBridgeListener.onErrorInternal(mAdBeans, TaErrorCode.RESPONSE_PMID_DIFFRENT_ERROR, impBean);
                            }
                            return;
                        }
                        if (mAdType != response.getData().getCodeSeatType()) {
                            AdLogUtil.Log().d(LOAD_TAG, "response adt is diffrent with request's");

                            if (mBridgeListener != null) {
                                mBridgeListener.onErrorInternal(mAdBeans, TaErrorCode.RESPONSE_ADT_DIFFRENT_ERROR, impBean);
                            }
                            return;
                        }
                        Iterator<AdsDTO> it = mAdBeans.iterator();
                        while (it.hasNext()) {
                            final AdsDTO adBean = it.next();
                            if (adBean == null) {
                                AdLogUtil.Log().d(LOAD_TAG, "ad is null,remove from list");

                                it.remove();
                                continue;
                            }
                            if (adBean.getCodeSeatType() == AdType.NATIVE
                                    && (adBean.getNativeObject() == null
                                    || adBean.getNativeObject().getMainImages() == null
                                    || adBean.getNativeObject().getMainImages().size() == 0
                                    || TextUtils.isEmpty(adBean.getNativeObject().getMainImages().get(0).getUrl()))) {
                                AdLogUtil.Log().d(LOAD_TAG, "Native ad's image is empty,remove from list");

                                it.remove();
                                continue;
                            }

                            adBean.setFill_ts(System.currentTimeMillis());
                            adBean.setCacheTime(response.getData().getCacheTime());
                            adBean.setAbTest(response.getData().getAbTest());
                            adBean.setExtInfo(response.getData().getExtInfo());
                            adBean.setImpBeanRequest(impBean);
                        }
                        if (mBridgeListener != null) {
                            if (mAdBeans.size() > 0) {
                                mBridgeListener.onAdResponse(mAdBeans);
                            } else {
                                mBridgeListener.onErrorInternal(null, TaErrorCode.SELF_AD_BE_FILTER, impBean);
                            }
                        }

                    } else {
                        AdLogUtil.Log().d(LOAD_TAG, "a ds list is empty");
                        if (mBridgeListener != null) {
                            mBridgeListener.onErrorInternal(null, TaErrorCode.RESPONSE_AD_IS_EMPTY, impBean);
                        }
                    }
                } else {
                    AdLogUtil.Log().d(LOAD_TAG, "业务错误 --> " + (response != null ?
                            ("error,response code is :" + response.getCode() + "," + "response msg is " + response.getMessage() + " ******")
                            : " error, response is null"));
                    if (mBridgeListener != null) {
                        if (response != null) {
                            mBridgeListener.onErrorInternal(null, new TaErrorCode(response.getCode(), response.getMessage()), impBean);
                        } else {
                            mBridgeListener.onErrorInternal(null, new TaErrorCode(TaErrorCode.UNKNOWN_ERROR_CODE_1, "response is null"), impBean);
                        }
                    }
                }
            }

            @Override
            protected void onRequestError(TaErrorCode adError) {
                if (mBridgeListener != null) {
                    mBridgeListener.onErrorInternal(null, adError, impBean);
                }

                if (null != adError) {
                    AdLogUtil.Log().d(LOAD_TAG, "load ad error adError=" + adError.getErrorMessage());
                }
            }

        }).setPostBody(new AdServerRequest.IAdPostBody() {
            @Override
            public String getPostBody() {
                return PostBody.getAdPostBody(impBean);
            }
        })
                .setDebug(SspAd.isDebug())
                .setUrl(AdxServerConfig.getServerUrl() + AdxServerConfig.getServerApi())
                .setPlacementId(mPlacementId)
                .setAdxImpBean(impBean);
        if (adServerRequest != null) {
            adServerRequest.netRequestPreExecute();
        }
        return true;
    }

    @Override
    public void loadOffLineAd(final int type, final String requestId, final int requestType) {
        AdLogUtil.Log().d(OFF_LINE_TAG, "AdxBaseAd ---loadOffLineAd()：start load offline ad,and type = " + type);
        OffLineManager.getInstance().getOffLineAd(type, new OffLineManager.AdDataListener() {
            @Override
            public void getAdData(AdsDTO adsDTO) {
                if (null != adsDTO) {
                    AdxImpBean impBean = adsDTO.getImpBeanRequest();
                    if (impBean == null) {
                        impBean = new AdxImpBean();
                    }
                    impBean.adt = mAdType;
                    impBean.pmid = mPlacementId;
                    impBean.defaultAd = false;
                    impBean.requestId = requestId;
                    impBean.isOffLineAd = true;
                    adsDTO.setImpBeanRequest(impBean);
                    List<AdsDTO> adBeanList = new ArrayList<>();
                    adBeanList.add(adsDTO);
                    // 从缓存中获取到数据
                    AdLogUtil.Log().d(OFF_LINE_TAG, "AdxBaseAd --- loadOffLineAd()：from splash offLine success," +
                            " adItem=" + (SspAd.isDebug() ? adsDTO.toString() : ""));
                    if (mBridgeListener != null) {
                        if (type == Constants.AdType.SPLASH_NATIVE) {
                            mBridgeListener.onSplashCacheGet(adBeanList);
                        } else {
                            mBridgeListener.onAdResponse(adBeanList);
                        }
                    }
                }
            }

            @Override
            public void getAdDataFail() {
                AdxImpBean impBean = new AdxImpBean();
                impBean.adt = mAdType;
                impBean.pmid = mPlacementId;
                impBean.defaultAd = false;
                impBean.requestId = requestId;
                impBean.isOffLineAd = true;
                if (mBridgeListener != null) {
                    mBridgeListener.onErrorInternal(null, TaErrorCode.RESPONSE_PMID_DIFFRENT_ERROR, impBean);
                }
            }
        });
    }

    /**
     * 重置
     */
    private void reset() {
        if (adServerRequest != null) {
            AdLogUtil.Log().d(LOAD_TAG, "Called AdxBannerView more than once. Auto reset request.");

            adServerRequest.cancelRequest();
            adServerRequest = null;
        }
    }


    @Override
    public long getResidualExpirationTime() {
        return Constants.NO_CACHE_EXPIRA_TIME;
    }

    /**
     * 销毁view
     */
    @Override
    public void destroy() {
        reset();
        mBridgeListener = null;
        AdLogUtil.Log().d(LOAD_TAG, "adx ad destroy");
    }

    @Override
    public void setPlacementId(String placementId) {
        this.mPlacementId = placementId;
    }

    @Override
    public AAdChoicesView getAdChoicesView(Context context, final AdsDTO adsDTO) {
        if (adsDTO != null && adsDTO.getACReady() != null && adsDTO.getACReady()) {
            AAdChoicesView adChoicesView = new AAdChoicesView(context);
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(ScreenUtil.dip2px(12), ScreenUtil.dip2px(12));
            adChoicesView.setLayoutParams(params);
            ImageDownloadHelper.loadImageView(adsDTO.getAdChoiceImageUrl(), adChoicesView, adsDTO, AthenaTracker.M_TYPE_AD_CHOICE_VIEW, null);
            adChoicesView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (adsDTO.isOffLineAd()) {
                        return;
                    }
                    PlatformUtil.startPageByWebView(CoreUtil.getContext(), adsDTO.getAdChoiceClickUrl());
                    if (mBridgeListener != null) mBridgeListener.onAdChoiceClick();
                }
            });
            return adChoicesView;
        }
        return null;
    }
}
