package com.cloud.hisavana.sdk.common.gsonutil;

import android.text.TextUtils;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

import java.io.IOException;
import java.math.BigDecimal;

/**
 * @author xinbing.zhang
 * @date :2021/12/8 3:02 下午
 * @description:
 */
public class LongTypeAdapter extends TypeAdapter<Long> {

    @Override
    public Long read(JsonReader in) throws IOException {
        if (null == in) {
            return null;
        }

        switch (in.peek()) {
            case NUMBER:
                try {
                    return in.nextLong();
                } catch (NumberFormatException e) {
                    // 如果带小数点则会抛出这个异常
                    return new BigDecimal(in.nextString()).longValue();
                }
            case STRING:
                String result = in.nextString();
                if (TextUtils.isEmpty(result)) {
                    return null;
                }
                try {
                    return Long.parseLong(result);
                } catch (NumberFormatException e) {
                    // 如果带小数点则会抛出这个异常
                    return new BigDecimal(result).longValue();
                }
            default:
                in.skipValue();
                return null;
        }
    }

    @Override
    public void write(JsonWriter out, Long value) throws IOException {
        out.value(value);
    }
}