package com.cloud.hisavana.sdk.common.util;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;

/**
 * Drawable工具类
 */
public class DrawableUtil {
    /**
     * 获得Drawable的宽
     *
     * @param drawable 图片
     * @return 图片宽度
     */
    public static int getDrawableWidth(Drawable drawable, int def) {
        if (drawable != null) {
            if (drawable instanceof BitmapDrawable) {
                if(((BitmapDrawable) drawable).getBitmap() == null){
                    return def;
                }
                int width = ((BitmapDrawable) drawable).getBitmap().getWidth();
                AdLogUtil.Log().d(AdLogUtil.TAG,"BitmapDrawable width:=" + width);
                return width > 0 ? width : 0;
            } else if (drawable instanceof Drawable) {
                int width = drawable.getIntrinsicWidth();
                AdLogUtil.Log().d(AdLogUtil.TAG,"Drawable width:=" + width);
                return width > 0 ? width : 0;
            }
        }
        return def;
    }

    /**
     * 获得Drawable的高
     *
     * @param drawable 图片
     * @return 图片高度
     */
    public static int getDrawableHeight(Drawable drawable, int def) {
        if (drawable != null) {
            if (drawable instanceof BitmapDrawable) {
                Bitmap bitmap = ((BitmapDrawable) drawable).getBitmap();
                if (bitmap != null) {
                    int height = bitmap.getHeight();
                    AdLogUtil.Log().d(AdLogUtil.TAG,"BitmapDrawable height:=" + height);
                    return height > 0 ? height : 0;
                }
            } else if (drawable instanceof Drawable) {
                int height = drawable.getIntrinsicHeight();
                AdLogUtil.Log().d(AdLogUtil.TAG,"Drawable height:=" + height);
                return height > 0 ? height : 0;
            }
        }
        return def;
    }
}
