package com.cloud.hisavana.sdk.offline;

import static com.cloud.hisavana.sdk.common.util.AdLogUtil.OFF_LINE_TAG;
import android.text.TextUtils;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.bean.AdImage;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.DownLoadRequest;
import com.cloud.hisavana.sdk.common.http.listener.DrawableResponseListener;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.ImageDownloadHelper;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;

import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * Created by xuhui.fang ON 2022/4/25
 */
public class DownLoadOffLineAd {

    private DownLoadOffLineAd next;
    private AdsDTO adsDTO;
    private LoadListener loadListerner;

    public DownLoadOffLineAd(AdsDTO adsDTO) {
        this.adsDTO = adsDTO;
    }

    public AdsDTO getAdsDTO() {
        return adsDTO;
    }

    public void nextExecutor(DownLoadOffLineAd nextExecutor) {
        this.next = nextExecutor;
    }

    public DownLoadOffLineAd getNext() {
        return next;
    }

    public void setLoadListener(LoadListener loadListerner) {
        this.loadListerner = loadListerner;
    }

    /**
     * 并行下载
     */
    public void loadTogether(final DownLoadOffLineAd downLoadOffLineAd) {
        AdLogUtil.Log().d(OFF_LINE_TAG, "开始并行下载");
        if (downLoadOffLineAd == null) {
            if (loadListerner != null) {
                loadListerner.loadComplete();
            }
            return;
        }
        final AdsDTO adsDTO = downLoadOffLineAd.getAdsDTO();
        if (adsDTO == null) {
            if (loadListerner != null) {
                loadListerner.loadComplete();
            }
            return;
        }
        if (adsDTO.getNativeObject() == null || adsDTO.getNativeObject().getMainImages() == null
                || adsDTO.getNativeObject().getMainImages().get(0) == null) {
            if (loadListerner != null) {
                loadListerner.loadComplete();
            }
            return;
        }
        String imageUrl = adsDTO.getNativeObject().getMainImages().get(0).getUrl();
        String clickUrl = adsDTO.getClickUrl();

        if (TextUtils.isEmpty(OffLineManager.getInstance().getCacheFilePath(imageUrl)) ||
                TextUtils.isEmpty(OffLineManager.getInstance().getCacheFilePath(clickUrl))) {
            AthenaTracker.trackOffLineSource(adsDTO, 2);
        } else {
            if (downLoadOffLineAd.getNext() != null) {
                loadTogether(downLoadOffLineAd.getNext());
            } else {
                if (loadListerner != null) {
                    loadListerner.loadComplete();
                }
            }
            return;
        }
        AdLogUtil.Log().d(OFF_LINE_TAG, "当前的下载内容为 ：" + adsDTO.toString());
        final AtomicInteger connCount = new AtomicInteger(2);
        final AtomicInteger countSuccess = new AtomicInteger(0);
        ImageDownloadHelper.downloadImage(imageUrl, Constants.ImageLoadType.IMAGE_DISK_INCLUDED,
                adsDTO, AthenaTracker.M_TYPE_LARGE_IMG, DownLoadRequest.TYPE_DOWNLOAD,new ImageDownloadHelper.ImageListener() {
                    @Override
                    public void onImagesCached(byte[] data) {
                        AdLogUtil.Log().d(AdLogUtil.TAG, "image cache success");
                        connCount.decrementAndGet();
                        adsDTO.setImageIsDownload(true);
                        countSuccess.addAndGet(1);
                        AdLogUtil.Log().d("offline_pkg_down", "下载成功 ：" + countSuccess.get());
                        if (connCount.get() == 0) {
                            if (countSuccess.get() == 2) {
                                AthenaTracker.trackOffLineSourceComplete(adsDTO, 2);
                            }
                            if (downLoadOffLineAd.getNext() != null) {
                                loadTogether(downLoadOffLineAd.getNext());
                            } else {
                                if (loadListerner != null) {
                                    loadListerner.loadComplete();
                                }
                            }
                        }
                    }

                    @Override
                    public void onImagesFailedToCache(TaErrorCode errorCode) {
                        AdLogUtil.Log().d(AdLogUtil.TAG, "image cache fail,code:"
                                + errorCode.getErrorCode() + ",message:" + errorCode.getErrorMessage());
                        connCount.decrementAndGet();
                        adsDTO.setImageIsDownload(false);
                        if (connCount.get() == 0) {
                            if (downLoadOffLineAd.getNext() != null) {
                                loadTogether(downLoadOffLineAd.getNext());
                            } else {
                                if (loadListerner != null) {
                                    loadListerner.loadComplete();
                                }
                            }
                        }
                    }
                });
        final DownLoadRequest downLoadFileRequest = new DownLoadRequest()
                .setOffLine(true)
                .setListener(new DrawableResponseListener() {
                    @Override
                    protected void onRequestError(TaErrorCode adError) {
                        AdLogUtil.Log().d(OFF_LINE_TAG, "web资源下载失败 ---- message："
                                + adError.getErrorMessage() + " ---" + Thread.currentThread().getName());
                        connCount.decrementAndGet();
                        AdLogUtil.Log().d(OFF_LINE_TAG, "下载成功 ：" + countSuccess.get());
                        if (connCount.get() == 0) {
                            if (downLoadOffLineAd.getNext() != null) {
                                loadTogether(downLoadOffLineAd.getNext());
                            } else {
                                if (loadListerner != null) {
                                    loadListerner.loadComplete();
                                }
                            }
                        }
                    }

                    @Override
                    public void onRequestSuccess(int statusCode, byte[] data, AdImage mediaBean) {
                        connCount.decrementAndGet();
                        countSuccess.addAndGet(1);
                        AdLogUtil.Log().d(OFF_LINE_TAG, "下载成功 ：" + countSuccess.get());
                        if (connCount.get() == 0) {
                            if (countSuccess.get() == 2) {
                                AthenaTracker.trackOffLineSourceComplete(adsDTO, 2);
                            }
                            if (downLoadOffLineAd.getNext() != null) {
                                loadTogether(downLoadOffLineAd.getNext());
                            } else {
                                if (loadListerner != null) {
                                    loadListerner.loadComplete();
                                }
                            }
                        }
                    }

                });
        downLoadFileRequest.setUrl(clickUrl).setAdsDTO(adsDTO, AthenaTracker.M_TYPE_AD_WEB_FILE)
                .setLoadType(DownLoadRequest.TYPE_DOWNLOAD).netRequestPreExecute();
    }

    /**
     * 串行下载
     */
    public void loadOrder(final DownLoadOffLineAd downLoadOffLineAd) {
        AdLogUtil.Log().d(OFF_LINE_TAG, "开始串行下载 --- " + Thread.currentThread().getName());
        if (downLoadOffLineAd == null) {
            if (loadListerner != null) {
                loadListerner.loadComplete();
            }
            return;
        }
        final AdsDTO adsDTO = downLoadOffLineAd.getAdsDTO();
        if (adsDTO == null) {
            if (loadListerner != null) {
                loadListerner.loadComplete();
            }
            return;
        }
        if (adsDTO.getNativeObject() == null || adsDTO.getNativeObject().getMainImages() == null
                || adsDTO.getNativeObject().getMainImages().get(0) == null) {
            if (loadListerner != null) {
                loadListerner.loadComplete();
            }
            return;
        }
        String imageUrl = adsDTO.getNativeObject().getMainImages().get(0).getUrl();
        final String clickUrl = adsDTO.getClickUrl();
        if (TextUtils.isEmpty(OffLineManager.getInstance().getCacheFilePath(imageUrl)) ||
                TextUtils.isEmpty(OffLineManager.getInstance().getCacheFilePath(clickUrl))) {
            AthenaTracker.trackOffLineSource(adsDTO, 1);
        } else {
            if (downLoadOffLineAd.getNext() != null) {
                loadOrder(downLoadOffLineAd.getNext());
            } else {
                if (loadListerner != null) {
                    loadListerner.loadComplete();
                }
            }
            return;
        }
        final AtomicInteger countSuccess = new AtomicInteger(0);
        // final boolean isNeedLoadH5 = (storeDeeplink == null || storeDeeplink.isEmpty()) && !TextUtils.isEmpty(clickUrl);
        AdLogUtil.Log().d(OFF_LINE_TAG, "当前的下载内容为 ：" + adsDTO.toString());

        final DownLoadRequest downLoadFileRequest = new DownLoadRequest()
                .setOffLine(true)
                .setListener(new DrawableResponseListener() {
                    @Override
                    protected void onRequestError(TaErrorCode adError) {
                        AdLogUtil.Log().d(OFF_LINE_TAG, "web资源下载失败 ---- message："
                                + adError.getErrorMessage() + " ---" + Thread.currentThread().getName());
                        if (downLoadOffLineAd.getNext() != null) {
                            loadOrder(downLoadOffLineAd.getNext());
                        } else {
                            if (loadListerner != null) {
                                loadListerner.loadComplete();
                            }
                        }
                    }

                    @Override
                    public void onRequestSuccess(int statusCode, byte[] data, AdImage mediaBean) {
                        countSuccess.addAndGet(1);
                        AdLogUtil.Log().d(OFF_LINE_TAG, "下载成功 ：" + countSuccess.get());
                        if (countSuccess.get() == 2) {
                            AthenaTracker.trackOffLineSourceComplete(adsDTO, 1);
                        }
                        if (downLoadOffLineAd.getNext() != null) {
                            loadOrder(downLoadOffLineAd.getNext());
                        } else {
                            if (loadListerner != null) {
                                loadListerner.loadComplete();
                            }
                        }
                    }

                });
        downLoadFileRequest.setUrl(clickUrl).setAdsDTO(adsDTO, AthenaTracker.M_TYPE_AD_WEB_FILE)
                .setLoadType(DownLoadRequest.TYPE_DOWNLOAD);

        ImageDownloadHelper.downloadImage(imageUrl, Constants.ImageLoadType.IMAGE_DISK_INCLUDED,
                adsDTO, AthenaTracker.M_TYPE_LARGE_IMG,DownLoadRequest.TYPE_DOWNLOAD, new ImageDownloadHelper.ImageListener() {
                    @Override
                    public void onImagesCached(byte[] data) {
                        countSuccess.addAndGet(1);
                        AdLogUtil.Log().d(OFF_LINE_TAG, "图片下载成功 --- " + Thread.currentThread().getName());
                        adsDTO.setImageIsDownload(true);
                        AdLogUtil.Log().d(OFF_LINE_TAG, "开始下载H5 --- " + Thread.currentThread().getName());
                        downLoadFileRequest.netRequestPreExecute();
                    }

                    @Override
                    public void onImagesFailedToCache(TaErrorCode errorCode) {
                        AdLogUtil.Log().d(OFF_LINE_TAG, "图片下载失败:" + errorCode.getErrorCode());
                        adsDTO.setImageIsDownload(false);
                        AdLogUtil.Log().d(OFF_LINE_TAG, "开始下载H5 --- " + Thread.currentThread().getName());
                        //     downLoadFileRequest.downLoadFile(OFF_LINE_FILE_DIR + "/landPage" + adsDTO.getId() + ".html");
                        downLoadFileRequest.netRequestPreExecute();
                    }
                });
    }

    public interface LoadListener {
        void loadComplete();
    }
}

