/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.util;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.widget.ImageView;
import com.cloud.hisavana.sdk.common.bean.AdImage;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.DownLoadRequest;
import com.cloud.hisavana.sdk.common.http.listener.DrawableResponseListener;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ImageDownloadHelper {
    public static void downloadImage(@NonNull String url, @NonNull int isPreCache, AdsDTO adsDTO, int m_type, ImageListener listener) {
        ImageDownloadHelper.downloadImage(url, isPreCache, adsDTO, m_type, 0, listener);
    }

    public static void downloadImage(final @NonNull String url, @NonNull int isPreCache, AdsDTO adsDTO, int m_type, int loadType, final ImageListener listener) {
        DownLoadRequest downLoadRequest = new DownLoadRequest().setPreCache(isPreCache).setListener(new DrawableResponseListener(){

            @Override
            public void onRequestSuccess(int statusCode, byte[] data, AdImage mediaBean) {
                AdLogUtil.Log().d("ssp", "image cache success:" + url);
                if (listener != null) {
                    listener.onImagesCached(data);
                }
            }

            @Override
            protected void onRequestError(TaErrorCode adError) {
                AdLogUtil.Log().d("ssp", "image load fail,error code:" + adError.getErrorCode() + ",error message:" + adError.getErrorMessage());
                if (listener != null) {
                    listener.onImagesFailedToCache(adError);
                }
            }
        }).setUrl(url).setLoadType(loadType).setAdsDTO(adsDTO, m_type);
        downLoadRequest.netRequestPreExecute();
    }

    public static void loadImageView(final @NonNull String url, final @NonNull ImageView imageView, AdsDTO adsDTO, int m_type, final ImageListener listener) {
        DownLoadRequest downLoadRequest = new DownLoadRequest().setListener(new DrawableResponseListener(){

            @Override
            public void onRequestSuccess(int statusCode, byte[] data, AdImage mediaBean) {
                AdLogUtil.Log().d("ssp", "image load success " + url);
                if (mediaBean == null) {
                    return;
                }
                mediaBean.attachView(imageView);
                if (listener != null) {
                    listener.onImagesCached(data);
                }
            }

            @Override
            protected void onRequestError(TaErrorCode adError) {
                AdLogUtil.Log().d("ssp", "image load fail,code:" + adError.getErrorCode() + ",message:" + adError.getErrorMessage());
                if (listener != null) {
                    listener.onImagesFailedToCache(adError);
                }
            }
        }).setUrl(url).setAdsDTO(adsDTO, m_type);
        downLoadRequest.netRequestPreExecute();
    }

    public static void preCacheSplashImages(@NonNull List<String> imageUrls, AdsDTO adsDTO, int m_type, @NonNull ImageListener imageListener) {
        ImageDownloadHelper.preCacheSplashImages(imageUrls, adsDTO, m_type, false, imageListener);
    }

    public static void preCacheSplashImages(@NonNull List<String> imageUrls, AdsDTO adsDTO, int m_type, boolean isOffLine, final @NonNull ImageListener imageListener) {
        final AtomicInteger imageCounter = new AtomicInteger(imageUrls.size());
        final AtomicBoolean anyFailures = new AtomicBoolean(false);
        if (adsDTO != null) {
            isOffLine = adsDTO.isOffLineAd();
        }
        for (String url : imageUrls) {
            if (TextUtils.isEmpty((CharSequence)url)) continue;
            AdLogUtil.Log().d("ssp", "request url:" + url);
            DownLoadRequest downLoadRequest = new DownLoadRequest().setPreCache(3).setOffLine(isOffLine).setListener(new DrawableResponseListener(){

                @Override
                public void onRequestSuccess(int statusCode, byte[] data, AdImage mediaBean) {
                    AdLogUtil.Log().d("ssp", "image cache success");
                    int count = imageCounter.decrementAndGet();
                    if (count == 0 && !anyFailures.get() && imageListener != null) {
                        imageListener.onImagesCached(data);
                    }
                }

                @Override
                protected void onRequestError(TaErrorCode adError) {
                    AdLogUtil.Log().d("ssp", "image cache fail,code:" + adError.getErrorCode() + ",message:" + adError.getErrorMessage());
                    boolean anyPreviousErrors = anyFailures.getAndSet(true);
                    imageCounter.decrementAndGet();
                    if (!anyPreviousErrors && imageListener != null) {
                        imageListener.onImagesFailedToCache(adError);
                    }
                }
            });
            downLoadRequest.setUrl(url).setAdsDTO(adsDTO, m_type).netRequestPreExecute();
        }
    }

    public static void preCacheNativeImageList(@NonNull List<AdImage> images, final ImageListener imageListener, boolean unified) {
        final AtomicInteger imageCounter = new AtomicInteger(images.size());
        if (unified) {
            for (AdImage image : images) {
                ImageDownloadHelper.preCacheNativeImage(image, new ImageListener(){

                    @Override
                    public void onImagesCached(byte[] data) {
                        int count = imageCounter.decrementAndGet();
                        if (count == 0 && imageListener != null) {
                            imageListener.onImagesCached(data);
                        }
                    }

                    @Override
                    public void onImagesFailedToCache(TaErrorCode errorCode) {
                        int count = imageCounter.decrementAndGet();
                        if (count == 0 && imageListener != null) {
                            imageListener.onImagesFailedToCache(errorCode);
                        }
                    }
                });
            }
        } else {
            final boolean[] stop = new boolean[]{false};
            for (AdImage image : images) {
                if (!stop[0]) {
                    ImageDownloadHelper.preCacheNativeImage(image, new ImageListener(){

                        @Override
                        public void onImagesCached(byte[] data) {
                            int count = imageCounter.decrementAndGet();
                            if (count == 0 && imageListener != null) {
                                imageListener.onImagesCached(data);
                            }
                        }

                        @Override
                        public void onImagesFailedToCache(TaErrorCode errorCode) {
                            stop[0] = true;
                            if (imageListener != null) {
                                imageListener.onImagesFailedToCache(errorCode);
                            }
                        }
                    });
                    continue;
                }
                break;
            }
        }
    }

    public static void preCacheNativeImage(final @NonNull AdImage image, final ImageListener listener) {
        if (image == null) {
            AdLogUtil.Log().d("ssp", "image url is null");
            return;
        }
        String url = image.getImgUrl();
        AdLogUtil.Log().d("ssp", "\u5f00\u59cb\u7f13\u5b58\u56fe\u7247\uff0crequest url:" + url);
        DownLoadRequest downLoadRequest = new DownLoadRequest().setPreCache(image.preCache).setListener(new DrawableResponseListener(){

            @Override
            public void onRequestSuccess(int statusCode, byte[] data, AdImage mediaBean) {
                AdLogUtil.Log().d("ssp", "\u56fe\u7247\u7f13\u5b58\u6210\u529f\uff0cimage cache success");
                if (image.preCache == 2 && mediaBean != null && image.getMime() != 3) {
                    image.setMime(mediaBean.getMime());
                }
                image.setCached(true);
                if (image.preCache == 1) {
                    if (mediaBean == null) {
                        return;
                    }
                    if (mediaBean.getMime() == 1 || mediaBean.getMime() == 2) {
                        image.setDrawable(mediaBean.getDrawable());
                    }
                }
                if (listener != null) {
                    listener.onImagesCached(data);
                }
            }

            @Override
            protected void onRequestError(TaErrorCode adError) {
                AdLogUtil.Log().d("ssp", "\u56fe\u7247\u7f13\u5b58\u5931\u8d25\uff0curl:" + image.getImgUrl() + ", code:" + adError.getErrorCode() + ",message:" + adError.getErrorMessage());
                if (listener != null) {
                    listener.onImagesFailedToCache(new TaErrorCode(adError.getErrorCode(), "cache image fail, url:" + image.getImgUrl() + ", " + adError.getErrorMessage()));
                }
            }
        }).setUrl(url).setAdsDTO(image.adsDTO, image.getmType());
        downLoadRequest.netRequestPreExecute();
    }

    public static interface ImageListener {
        public void onImagesCached(byte[] var1);

        public void onImagesFailedToCache(TaErrorCode var1);
    }
}

