/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.offline;

import android.content.Context;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.cloud.hisavana.sdk.api.config.SspAd;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.gsonutil.GsonUtil;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.DeviceUtil;
import com.cloud.hisavana.sdk.common.util.ImageDownloadHelper;
import com.cloud.hisavana.sdk.common.util.MitNetUtil;
import com.cloud.hisavana.sdk.common.util.Preconditions;
import com.cloud.hisavana.sdk.data.bean.request.AdxImpBean;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.data.control.AdxPreferencesHelper;
import com.cloud.hisavana.sdk.offline.OffLineData;
import com.cloud.hisavana.sdk.offline.OffLineResponseBody;
import com.cloud.hisavana.sdk.offline.a;
import com.transsion.core.CoreUtil;
import com.transsion.core.pool.TranssionPoolManager;
import com.transsion.http.HttpClient;
import com.transsion.http.ImageURL;
import com.transsion.http.RequestCall;
import com.transsion.http.builder.GetRequestBuilder;
import com.transsion.http.builder.ImageRequestBuilder;
import com.transsion.http.cache.IDiskCache;
import com.transsion.http.d;
import com.transsion.http.impl.IHttpCallback;
import com.transsion.http.impl.StringCallback;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class OffLineManager {
    private AtomicBoolean a = new AtomicBoolean(false);
    private OffLineData b;
    private String c;
    @Keep
    private OffLineLoadListener listener;
    private int d = -1;
    private int e = -1;
    private int f = -1;
    private int g = -1;
    private long h;
    private long i;

    public static OffLineManager getInstance() {
        return com.cloud.hisavana.sdk.offline.OffLineManager$b.a;
    }

    public OffLineManager setListener(OffLineLoadListener offLineLoadListener) {
        this.listener = offLineLoadListener;
        return this;
    }

    public int getOfflineAdCounts(int adType) {
        switch (adType) {
            case 4: {
                if (this.d < 0) {
                    this.c();
                }
                return Math.max(this.d, 0);
            }
            case 1: {
                if (this.e < 0) {
                    this.c();
                }
                return Math.max(this.e, 0);
            }
            case 3: {
                if (this.f < 0) {
                    this.c();
                }
                return Math.max(this.f, 0);
            }
        }
        return 0;
    }

    private boolean a() {
        if (this.h == 0L) {
            this.h = AdxPreferencesHelper.getInstance().getLong("off_line_request_time_interval", 60000L);
        }
        if (this.i == 0L) {
            this.i = AdxPreferencesHelper.getInstance().getLong("get_off_line_ad_time", 0L);
        }
        AdLogUtil.Log().d("offline", "\u5f53\u524d\u95f4\u9694\u65f6\u95f4==" + this.h);
        AdLogUtil.Log().d("offline", "\u8bf7\u6c42\u7684\u95f4\u9694\u65f6\u95f4==" + (System.currentTimeMillis() - this.i));
        return System.currentTimeMillis() - this.i >= this.h;
    }

    private void a(final String json) {
        if (TextUtils.isEmpty((CharSequence)json)) {
            return;
        }
        AdLogUtil.Log().d("offline", "\u8981\u5199\u5165\u7684\u5e7f\u544a\u6570\u636e ====" + (SspAd.isDebug() ? json : ""));
        TranssionPoolManager.getInstance().addTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String temporaryName = System.currentTimeMillis() + ".json";
                File offlineDir = new File(CoreUtil.getContext().getFilesDir() + "/offlineAd");
                File temporaryFile = new File(offlineDir, temporaryName);
                File file = new File(offlineDir, "off_line_ad.json");
                if (!offlineDir.exists()) {
                    offlineDir.mkdir();
                }
                BufferedWriter bw = null;
                try {
                    if (!temporaryFile.exists()) {
                        temporaryFile.createNewFile();
                    }
                    FileWriter fileWriter = new FileWriter(temporaryFile);
                    bw = new BufferedWriter(fileWriter);
                    bw.write(json);
                    bw.flush();
                    bw.close();
                    if (file.exists()) {
                        file.delete();
                    }
                    temporaryFile.renameTo(file);
                    temporaryFile.delete();
                    AdLogUtil.Log().d("offline", "offline ad write json ====" + (SspAd.isDebug() ? json : ""));
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                finally {
                    try {
                        if (bw != null) {
                            bw.close();
                        }
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OffLineData b() {
        File file = new File(CoreUtil.getContext().getFilesDir() + "/offlineAd", "off_line_ad.json");
        if (!file.exists()) {
            return null;
        }
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            char[] bt = new char[1024];
            StringBuffer sb = new StringBuffer();
            int len = 0;
            while ((len = fileReader.read(bt)) != -1) {
                sb.append(bt, 0, len);
            }
            if (sb.length() == 0) {
                OffLineData offLineData = null;
                return offLineData;
            }
            AdLogUtil.Log().d("offline", "offline ad read json ====" + (SspAd.isDebug() ? sb.toString() : ""));
            OffLineData offLineData = GsonUtil.fromJson(sb.toString(), OffLineData.class);
            fileReader.close();
            OffLineData offLineData2 = offLineData;
            return offLineData2;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            OffLineData offLineData = null;
            return offLineData;
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        }
    }

    public void requestOffLineAd(final boolean isRunForeground, final int requestType) {
        if (!MitNetUtil.isNetWorkAvailable() || this.a.get()) {
            AdLogUtil.Log().d("offline", "\u65e0\u7f51\u7edc\u6216\u6b63\u5728\u8bf7\u6c42\u5f53\u4e2d");
            return;
        }
        final long requestTs = System.currentTimeMillis();
        this.c = DeviceUtil.getUUID();
        AdLogUtil.Log().d("offline", "offline ad request ---requestOffLineAd()");
        this.a.set(true);
        if (!this.a()) {
            if (this.b == null) {
                this.b = this.b();
            }
            this.a(isRunForeground);
            AdLogUtil.Log().d("offline", "\u8bf7\u6c42\u95f4\u9694\u65f6\u95f4\u672a\u8fbe\u5230\u76f4\u63a5\u53bb\u8bf7\u6c42\u7d20\u6750");
            return;
        }
        AthenaTracker.trackOffLineSspRequest(requestTs, requestType, this.c);
        AdLogUtil.Log().d("offline", "\u8bf7\u6c42\u95f4\u9694\u65f6\u95f4\u5df2\u7ecf\u8fbe\u5230\uff0c\u8bf7\u6c42\u4e91\u63a7\u6570\u636e");
        ((GetRequestBuilder)((GetRequestBuilder)((GetRequestBuilder)((GetRequestBuilder)((GetRequestBuilder)((GetRequestBuilder)((GetRequestBuilder)HttpClient.get().log(SspAd.isDebug())).sslSocketFactory(null)).connectTimeout(15000)).readTimeout(15000)).addHeader("x-tr-signature", "h5")).url("https://transsion-eagllwin-website-static.oss-eu-central-1.aliyuncs.com/ad.json")).addHeader("Accept-Timezone", "UTC")).build().execute((IHttpCallback)new StringCallback(true){

            public void onFailure(final int statusCode, final String message, final Throwable throwable) {
                Preconditions.runOnMainThread(new Preconditions.Callback(){

                    @Override
                    public void onRun() {
                        AthenaTracker.trackOffLineSspReturn(requestTs, requestType, OffLineManager.this.c, null, statusCode + "", message);
                        AdLogUtil.Log().d("offline", "offline ad request ---onFailure == throwable:" + throwable.getMessage());
                        if (null != OffLineManager.this.listener) {
                            OffLineManager.this.listener.complete();
                        }
                        OffLineManager.this.a.set(false);
                    }
                });
            }

            public void onSuccess(int statusCode, final String response) {
                Preconditions.runOnMainThread(new Preconditions.Callback(){

                    @Override
                    public void onRun() {
                        block6: {
                            AdLogUtil.Log().d("offline", "offline ad request ---onSuccess ==" + response);
                            if (TextUtils.isEmpty((CharSequence)response)) {
                                OffLineManager.this.a.set(false);
                                if (null != OffLineManager.this.listener) {
                                    OffLineManager.this.listener.complete();
                                }
                                AthenaTracker.trackOffLineSspReturn(requestTs, requestType, OffLineManager.this.c, null, null, null);
                                return;
                            }
                            try {
                                OffLineResponseBody responseBody = GsonUtil.fromJson(response, OffLineResponseBody.class);
                                OffLineManager.this.i = System.currentTimeMillis();
                                AdxPreferencesHelper.getInstance().putLong("get_off_line_ad_time", OffLineManager.this.i);
                                AdxPreferencesHelper.getInstance().putBoolean("off_line_enable", responseBody.getData().getEnable().booleanValue());
                                OffLineManager.this.g = responseBody.getData().getShowCountLimit();
                                AdxPreferencesHelper.getInstance().putInt("off_line_show_count_limit", OffLineManager.this.g);
                                OffLineManager.this.h = responseBody.getData().getRequestInterval() * 60 * 1000;
                                AdxPreferencesHelper.getInstance().putLong("off_line_request_time_interval", OffLineManager.this.h);
                                if (responseBody.getData() == null || !responseBody.getData().getEnable().booleanValue()) {
                                    OffLineManager.this.a.set(false);
                                    if (null != OffLineManager.this.listener) {
                                        OffLineManager.this.listener.complete();
                                    }
                                    AthenaTracker.trackOffLineSspReturn(requestTs, requestType, OffLineManager.this.c, null, TaErrorCode.RESPONSE_AD_IS_EMPTY.getErrorCode() + "", TaErrorCode.RESPONSE_AD_IS_EMPTY.getErrorMessage());
                                    return;
                                }
                                OffLineManager.this.b = responseBody.getData();
                                AdLogUtil.Log().d("offline", "\u5f53\u524d\u7684\u7ebf\u7a0b --- " + Thread.currentThread().getName());
                                OffLineManager.this.a(requestTs, requestType);
                                OffLineManager.this.a(isRunForeground, requestTs, requestType);
                            }
                            catch (Exception e2) {
                                AdLogUtil.Log().d("offline", e2.getMessage());
                                OffLineManager.this.a.set(false);
                                if (null == OffLineManager.this.listener) break block6;
                                OffLineManager.this.listener.complete();
                            }
                        }
                    }
                });
            }
        });
    }

    private void a(long requestTs, int requestType) {
        if (this.b == null) {
            return;
        }
        ArrayList<AdsDTO> adsDTOs = new ArrayList<AdsDTO>();
        if (this.b.getSplash() != null) {
            adsDTOs.addAll(this.b.getSplash());
        }
        if (this.b.getNativeAd() != null) {
            adsDTOs.addAll(this.b.getNativeAd());
        }
        if (this.b.getInterstitial() != null) {
            adsDTOs.addAll(this.b.getInterstitial());
        }
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (AdsDTO adsDTO : adsDTOs) {
            if (null == adsDTO) continue;
            ids.add(adsDTO.getId());
        }
        if (ids.isEmpty()) {
            AthenaTracker.trackOffLineSspReturn(requestTs, requestType, this.c, null, TaErrorCode.RESPONSE_AD_IS_EMPTY.getErrorCode() + "", TaErrorCode.RESPONSE_AD_IS_EMPTY.getErrorMessage());
        } else {
            AthenaTracker.trackOffLineSspReturn(requestTs, requestType, this.c, ids, null, null);
        }
    }

    private void a(boolean isRunForeground, long requestTs, int requestType) {
        if (this.b == null) {
            this.a.set(false);
            if (this.listener != null) {
                this.listener.complete();
            }
            return;
        }
        this.a(this.b.getSplash(), requestTs, requestType);
        this.a(this.b.getNativeAd(), requestTs, requestType);
        this.a(this.b.getInterstitial(), requestTs, requestType);
        this.a(GsonUtil.toJson(this.b));
        this.a(isRunForeground);
    }

    private void a(List<AdsDTO> newList, long requestTs, int requestType) {
        if (null == newList || newList.isEmpty()) {
            return;
        }
        Iterator<AdsDTO> newIterator = newList.iterator();
        while (newIterator.hasNext()) {
            AdsDTO adsDTO = newIterator.next();
            adsDTO.setOffLineAd(true);
            AdxImpBean impBean = adsDTO.getImpBeanRequest();
            if (impBean == null) {
                impBean = new AdxImpBean();
            }
            impBean.adt = adsDTO.getCodeSeatType();
            impBean.pmid = "";
            impBean.requestId = this.c;
            impBean.requestType = requestType;
            impBean.requestTs = requestTs;
            impBean.isOffLineAd = true;
            adsDTO.setImpBeanRequest(impBean);
            if (adsDTO.getCodeSeatType() == 4 && adsDTO.getNativeObject() != null) {
                adsDTO.getNativeObject().setLogo(null);
            }
            if (null != adsDTO && null != adsDTO.getNativeObject() && null != adsDTO.getNativeObject().getMainImages() && !adsDTO.getNativeObject().getMainImages().isEmpty() && !TextUtils.isEmpty((CharSequence)adsDTO.getNativeObject().getMainImages().get(0).getUrl())) continue;
            newIterator.remove();
        }
    }

    private void a(boolean isRunForeground) {
        if (this.b == null) {
            this.a.set(false);
            if (null != this.listener) {
                this.listener.complete();
            }
            return;
        }
        AdLogUtil.Log().d("offline", "loadMaterial \u5f00\u59cb\u8bf7\u6c42\u7269\u6599");
        final ArrayList<AdsDTO> adsDTOs = new ArrayList<AdsDTO>();
        if (this.b.getSplash() != null) {
            adsDTOs.addAll(this.b.getSplash());
        }
        if (this.b.getNativeAd() != null) {
            adsDTOs.addAll(this.b.getNativeAd());
        }
        if (this.b.getInterstitial() != null) {
            adsDTOs.addAll(this.b.getInterstitial());
        }
        if (adsDTOs.isEmpty()) {
            this.a.set(false);
            if (null != this.listener) {
                this.listener.complete();
            }
            return;
        }
        AdLogUtil.Log().d("offline", "\u4e0b\u8f7d\u7684\u7269\u6599size == " + adsDTOs.size());
        com.cloud.hisavana.sdk.offline.a temp = null;
        com.cloud.hisavana.sdk.offline.a head = null;
        for (AdsDTO impl : adsDTOs) {
            impl.setOffLineAd(true);
            com.cloud.hisavana.sdk.offline.a next = new com.cloud.hisavana.sdk.offline.a(impl);
            if (temp == null) {
                head = next;
            } else {
                temp.a(next);
            }
            temp = next;
        }
        if (head == null) {
            this.a.set(false);
            if (this.listener != null) {
                this.listener.complete();
            }
            return;
        }
        this.adSrcLoad(head, isRunForeground, new a.a(){

            @Override
            public void a() {
                OffLineManager.this.c();
                AdLogUtil.Log().d("offline", "\u5168\u90e8\u8d44\u6e90\u4e0b\u8f7d\u5b8c\u6210");
                if (!adsDTOs.isEmpty() && TextUtils.isEmpty((CharSequence)OffLineManager.this.getCacheFilePath(((AdsDTO)adsDTOs.get(0)).getAdChoiceImageUrl()))) {
                    ImageDownloadHelper.downloadImage(((AdsDTO)adsDTOs.get(0)).getAdChoiceImageUrl(), 3, (AdsDTO)adsDTOs.get(0), 3, null);
                }
                for (AdsDTO adsDTO : adsDTOs) {
                    if (adsDTO.getCodeSeatType() != 3 && adsDTO.getCodeSeatType() != 1 || !TextUtils.isEmpty((CharSequence)OffLineManager.this.getCacheFilePath(adsDTO.getLogoUrl()))) continue;
                    ImageDownloadHelper.downloadImage(adsDTO.getLogoUrl(), 3, adsDTO, 1, null);
                }
                OffLineManager.this.a.set(false);
                if (OffLineManager.this.listener != null) {
                    OffLineManager.this.listener.complete();
                }
            }
        });
    }

    public void adSrcLoad(@NonNull com.cloud.hisavana.sdk.offline.a downLoadOffLineAd, boolean isRunForeground, a.a loadListener) {
        downLoadOffLineAd.a(loadListener);
        if (isRunForeground) {
            downLoadOffLineAd.c(downLoadOffLineAd);
        } else {
            downLoadOffLineAd.b(downLoadOffLineAd);
        }
    }

    public void getOffLineAd(int type, a listener) {
        List<AdsDTO> adsDTOs;
        if (!AdxPreferencesHelper.getInstance().getBoolean("off_line_enable", false)) {
            if (listener != null) {
                listener.a();
            }
            return;
        }
        AdLogUtil.Log().d("offline", "\u5f53\u524d\u79bb\u7ebf\u5e7f\u544a\u529f\u80fd\u4e3atrue");
        if (this.b == null) {
            this.b = this.b();
        }
        if (null == this.b) {
            AdLogUtil.Log().d("offline", "\u672c\u5730\u7684\u79bb\u7ebf\u5e7f\u544a\u4e3a\u7a7a");
            if (listener != null) {
                listener.a();
            }
            return;
        }
        switch (type) {
            case 4: {
                adsDTOs = this.b.getSplash();
                break;
            }
            case 1: {
                adsDTOs = this.b.getNativeAd();
                break;
            }
            case 3: {
                adsDTOs = this.b.getInterstitial();
                break;
            }
            default: {
                adsDTOs = new ArrayList<AdsDTO>();
            }
        }
        if (null == adsDTOs || adsDTOs.isEmpty()) {
            if (listener != null) {
                listener.a();
            }
            return;
        }
        AdLogUtil.Log().d("offline", "\u79bb\u7ebf\u5e7f\u544a\u6570\u636e\uff1a" + (SspAd.isDebug() ? adsDTOs : ""));
        if (this.g < 0) {
            this.g = AdxPreferencesHelper.getInstance().getInt("off_line_show_count_limit");
        }
        int count = adsDTOs.size();
        AdsDTO resultAd = null;
        for (int i2 = 0; i2 < count; ++i2) {
            if (!this.checkAdAvailable(adsDTOs.get(i2))) continue;
            resultAd = adsDTOs.get(i2);
            break;
        }
        if (resultAd == null) {
            if (listener != null) {
                listener.a();
            }
            return;
        }
        if (listener != null) {
            AdsDTO newResult = GsonUtil.fromJson(GsonUtil.toJson(resultAd), AdsDTO.class);
            listener.a(newResult);
            AdLogUtil.Log().d("offline", "\u79bb\u7ebf\u5e7f\u544a\u6570\u636e\uff1a" + (SspAd.isDebug() ? resultAd : ""));
        }
    }

    public void updateShowCount(AdsDTO adsDTO) {
        List<AdsDTO> adsDTOList;
        if (adsDTO == null || this.b == null) {
            return;
        }
        switch (adsDTO.getCodeSeatType()) {
            case 4: {
                adsDTOList = this.b.getSplash();
                break;
            }
            case 1: {
                adsDTOList = this.b.getNativeAd();
                break;
            }
            case 3: {
                adsDTOList = this.b.getInterstitial();
                break;
            }
            default: {
                adsDTOList = new ArrayList<AdsDTO>();
            }
        }
        if (adsDTOList == null || adsDTOList.isEmpty()) {
            return;
        }
        if (!adsDTOList.contains(adsDTO)) {
            return;
        }
        int showOffLineCount = adsDTO.getShowOffLineCount();
        adsDTO.setShowOffLineCount(showOffLineCount + 1);
        this.c();
        adsDTOList.remove(adsDTO);
        adsDTOList.add(adsDTO);
        this.a(GsonUtil.toJson(this.b));
    }

    public String getCacheFilePath(String url) {
        ImageURL imageURL;
        if (TextUtils.isEmpty((CharSequence)url)) {
            return "";
        }
        RequestCall requestImgCall = ((ImageRequestBuilder)HttpClient.image((Context)CoreUtil.getContext()).useOffLineCache(true).cache(true).url(url)).build();
        IDiskCache iDiskCacheImg = requestImgCall.getDiskCache();
        File file = iDiskCacheImg.get((d)(imageURL = new ImageURL(url)));
        if (file != null && file.exists()) {
            return file.getAbsolutePath();
        }
        return "";
    }

    private void c() {
        if (this.b == null) {
            this.b = this.b();
        }
        if (this.b == null) {
            this.e = 0;
            this.d = 0;
            this.f = 0;
            return;
        }
        List<AdsDTO> interstitial = this.b.getInterstitial();
        List<AdsDTO> splash = this.b.getSplash();
        List<AdsDTO> nativeAd = this.b.getNativeAd();
        this.f = this.a(interstitial);
        this.d = this.a(splash);
        this.e = this.a(nativeAd);
    }

    private int a(List<AdsDTO> adsDTOList) {
        if (adsDTOList == null || adsDTOList.size() == 0) {
            return 0;
        }
        int listCount = 0;
        for (AdsDTO adsDTO : adsDTOList) {
            if (!this.checkAdAvailable(adsDTO)) continue;
            ++listCount;
        }
        return listCount;
    }

    public boolean checkAdAvailable(AdsDTO adsDTO) {
        if (adsDTO == null) {
            return false;
        }
        String imgUrl = "";
        if (adsDTO.getNativeObject() != null && adsDTO.getNativeObject().getMainImages() != null && !adsDTO.getNativeObject().getMainImages().isEmpty()) {
            imgUrl = adsDTO.getNativeObject().getMainImages().get(0).getUrl();
        }
        String clickUrl = adsDTO.getClickUrl();
        String imgFilePath = this.getCacheFilePath(imgUrl);
        if (TextUtils.isEmpty((CharSequence)imgFilePath)) {
            return false;
        }
        String h5FilePath = this.getCacheFilePath(clickUrl);
        if ((adsDTO.getStoreDeeplink() == null || adsDTO.getStoreDeeplink().isEmpty()) && TextUtils.isEmpty((CharSequence)h5FilePath)) {
            return false;
        }
        if (this.g <= 0) {
            this.g = AdxPreferencesHelper.getInstance().getInt("off_line_show_count_limit");
        }
        return adsDTO.getShowOffLineCount() < this.g;
    }

    public static interface a {
        public void a(AdsDTO var1);

        public void a();
    }

    public static interface OffLineLoadListener {
        public void complete();
    }

    private static class b {
        private static OffLineManager a = new OffLineManager();
    }
}

