package com.cloud.hisavana.sdk.api.adx;


import android.support.annotation.NonNull;

import com.cloud.hisavana.sdk.api.listener.TaRequest;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.internal.interstitial.TranInterstitial;

/**
 * Created by jianbing.yu on 2019/2/22.
 *
 * 媒体入口
 */
public class AInterstitial {

    private static final String TAG = "InterstitialApi";
    private TranInterstitial mInterstitial = null;

    /**
     * 构造方法
     *
     * @param placementId
     */
    public AInterstitial(String placementId) {
        mInterstitial = new TranInterstitial(placementId);
    }


    // =============================================================================================


    /**
     * 设置广告来源
     */
    public void setAdCategory(int adCategory) {
        mInterstitial.setAdCategory(adCategory);
    }

    /**
     * 设置placementid
     *
     * @param placementId
     */
    public void setPlacementId(String placementId) {
        mInterstitial.setPlacementId(placementId);
    }

    /**
     * 设置请求类型
     * @param requestType
     */
    public void setRequestType(int requestType) {
        mInterstitial.setRequestType(requestType);
    }
    public void setAdRequest(@NonNull TaRequest taRequest) {
        mInterstitial.setAdRequest(taRequest);
    }

    public double getBidPrice(){
        return mInterstitial.getBidPrice();
    }

    public void setSecondPrice(double secondPrice){
        mInterstitial.setSecondPrice(secondPrice);
    }

    public String getDefaultAdRequestId() {
       return mInterstitial.getDefaultAdRequestId();
    }
    public boolean isAdValid() {
        return mInterstitial.isAdValid();
    }

    public void loadAd(String requestId) {
        mInterstitial.loadAd(requestId);
    }

    public void show() {
        mInterstitial.show();
    }

    public boolean isLoaded() {
        return mInterstitial.isLoaded();
    }

    public void destroy() {
        mInterstitial.destroy();
    }

}
