package com.cloud.hisavana.sdk.common.athena;

import static com.cloud.hisavana.sdk.common.util.AdLogUtil.TAG;

import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.data.bean.request.AdxImpBean;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import java.util.ArrayList;
/**
 * Created by wenjing.luo on 2021/8/24.
 */

public class AthenaTracker {


    // 下载途径
    public static final int DOWNLOAD_WAY_HTTP_URL_CONNECTION = 1;
    public static final int DOWNLOAD_WAY_OKHTTP = 2;

    // 下载状态
    public static final int M_STATUS_STAR = 1;
    public static final int M_STATUS_SUCCESS = 2;
    public static final int M_STATUS_ERROR = 3;

    // 下载类型
    public static final int M_TYPE_LOGO = 1;
    public static final int M_TYPE_LARGE_IMG = 2;
    public static final int M_TYPE_AD_CHOICE_VIEW = 3;
    public static final int M_TYPE_AD_WEB_FILE = 4;
    public static Handler handler;
    public static HandlerThread handlerThread;

    private synchronized static void initHandler() {
        if (handler == null) {
            handlerThread = AthenaUtil.getHanderThread();
            AthenaUtil.start();
            handler = new Handler(handlerThread.getLooper());
            AdLogUtil.Log().d(TAG, "AthenaTracker initHandlerThread");
        }
    }

    /**
     * @return 获取公参
     */
    public static Bundle getBundle(Bundle bundle) {
        return AthenaTrackerInvoker.getBundle(bundle);
    }

    /**
     * 上报埋点新开一个子线程
     *
     * @param runnable
     */
    public static void trackInNewThread(final Runnable runnable) {
        initHandler();
        handler.post(runnable);
    }

    /**
     * 展示上报新开一个子线程
     *
     * @param info
     */
    public static void trackShow(final AdsDTO info) {
        trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackShow(info);
            }
        });
    }

    /**
     * deeplink应用拉起成功上报
     *
     * @param info
     */
    public static void trackDeeplink(final AdsDTO info) {
        trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackDeeplink(info);
            }
        });
    }


    /**
     * SSP SDK 物料加载日志
     *
     * @param info 广告详情
     * @param requestType 请求方式 1. 从网络获取；2. 从本地缓存获取
     * @param downloadWay 下载方式 1.HttpUrlConnection 2.Okhttp  int
     * @param mStatus     下载状态 1.开始下载 2.下载成功 3.下载失败
     * @param errorCode   错误信息
     * @param mType       资源类型
     * @param cdn         资源来源
     * @param timeConsuming 耗时
     * @param fileSize   文件大小
     */
    public static void trackImageDownload(final AdsDTO info,
                                          final int requestType,
                                          final int downloadWay,
                                          final int mStatus,
                                          final int errorCode,
                                          final int mType,
                                          final String cdn,
                                          final long timeConsuming,
                                          final int fileSize) {
        trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackImageDownload(info,requestType, downloadWay, mStatus, errorCode, mType,cdn,timeConsuming,fileSize);
            }
        });
    }

    /**
     * 请求广告埋点
     *
     * @param info
     */
    public static void trackSspRequest(final AdxImpBean info) {
        trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackSspRequest(info);
            }
        });
    }

    /**
     * 离线广告请求埋点
     *
     * @param request_ts
     * @param request_type
     * @param request_id
     */
    public static void trackOffLineSspRequest(final long request_ts, final int request_type, final String request_id) {
        trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackOffLineSspRequest(request_ts, request_type, request_id);
            }
        });
    }

    /**
     * 返回广告埋点
     *
     * @param info
     */
    public static void trackSspReturn(final AdsDTO info, final TaErrorCode adError, final AdxImpBean adxImpBean) {
        trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackSspReturn(info, adError, adxImpBean);
            }
        });
    }


    /**
     * 离线广告请求返回
     *
     * @param request_ts
     * @param request_type
     * @param request_id
     */
    public static void trackOffLineSspReturn(final long request_ts, final int request_type, final String request_id, final ArrayList<Integer> offlineId, final String errorCode, final String errorMessage) {
        trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackOffLineSspReturn(request_ts, request_type, request_id,offlineId,errorCode,errorMessage);
            }
        });
    }
    /**
     * 触发离线广告请求的埋点
     *
     * @param request_ts
     * @param request_type
     */
    public static void trackOffLinePreRequest(final long request_ts, final int request_type, final String request_id) {
        trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackOffLinePreRequest(request_ts, request_type, request_id);
            }
        });
    }

    /**
     * 离线包开始下载的埋点
     *
     * @param info
     */
    public static void trackOffLineSource(final AdsDTO info, final int taskCount) {
        trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackOffLineSource(info, taskCount);
            }
        });
    }

    /**
     * 离线包开始全部成功的埋点
     *
     * @param info
     */
    public static void trackOffLineSourceComplete(final AdsDTO info, final int taskCount) {
        trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.trackOffLineSourceComplete(info, taskCount);
            }
        });
    }

    /**
     * 离线广告的web加载完成埋点
     */
    public static void offLineWebComplete(final AdsDTO info, final long webDuration) {
        trackInNewThread(new Runnable() {
            @Override
            public void run() {
                AthenaTrackerInvoker.offLineWebComplete(info, webDuration);
            }
        });
    }
}
