package com.cloud.hisavana.sdk.common.constant;

import android.text.TextUtils;

/**
 * @author: peng.sun
 * @date: 2018/7/12 16:14
 * ==================================
 * Copyright (c) 2018 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class TaErrorCode {
    public static final int SUCCESS_CODE = 200;
    public static final int UNKNOWN_ERROR_CODE = 10000;
    public static final int UNKNOWN_ERROR_CODE_1 = 10001;
    public static final int UNKNOWN_ERROR_CODE_2 = 10002;
    private static final int NETWORK_ERROR_CODE = 9000;
    private static final int AD_IS_EMPTY_CODE = 9003;
    private static final int OFFLINE_IS_UNENABLE = 90010;//离线开关关闭
    private static final int OFFLINE_NO_Material = 90011;//离线素材下载不成功
    private static final int OFFLINE_SHOW_COUNT_LIMIT = 90012;//达到最大展示次数
    private static final int HTTP_RESPONSE_ERROR_CODE = 9006;
    public static final int TIMEOUT_ERROR_CODE = 9007;
    public static final int INVALID_CRVT_CODE = 9010;
    private static final int RESPONSE_PMID_DIFFRENT_CODE = 9011;
    private static final int RESPONSE_ADT_DIFFRENT_CODE = 9012;
    public static final int PARSE_BITMAP_ERROR = 9013;

    private static final int AD_BE_FILTER_CODE = 1001;
    private static final int NO_AD_CODE = 1002;
    private static final int SENSITIVE_ERROR_CODE = 1003;
    private static final int ADMEDIA_NO_FILL_CODE = 1004;
    private static final int REGISTER_VIEW_ERROR_CODE = 1005;
    private static final int INVALID_URL_CODE = 1006;
    private static final int SPLASH_AD_EXPIRED = 1007;
    private static final int SPLASH_AD_NO_CACHED = 1008;
    private static final int PLATFORM_NOT_EXIT = 1009;
    //    private static final int UNKNOWN_ERROR_CODE = 1010;
    private static final int NOT_SELF_AD_CODE = 1011;
    public static final int NOT_ALLOW_DEEPLINK_CODE = 1012;

    public static final int NATIVE_ = 1012;

    private static final int SPLASH_AD_NOT_AVALID = 1013;
    private static final int AD_CONFIG_SILENCE_CODE = 1014;

    // 广告网络请求 --> 数据解析异常
    private static final int AD_DATA_PARSE_RESPONSE_ERROR_CODE = 1015;


//    private static final int SENSITIVE_ERROR_CODE = 9001;
//    private static final int AD_TYPE_ERROR_CODE = 9002;
//    private static final int AD_MODEL_ERROR_CODE = 9004;
//    private static final int HTTP_FRAME_ERROR_CODE = 9005;
//    private static final int MEDIATION_CLOSE_ERROR_CODE = 9009;


    public static final TaErrorCode NETWORK_ERROR = new TaErrorCode(NETWORK_ERROR_CODE, "Network Error");
    public static final TaErrorCode RESPONSE_PMID_DIFFRENT_ERROR = new TaErrorCode(RESPONSE_PMID_DIFFRENT_CODE, "request's pmid is diffrent with response's");
    public static final TaErrorCode RESPONSE_ADT_DIFFRENT_ERROR = new TaErrorCode(RESPONSE_PMID_DIFFRENT_CODE, "request's adt is diffrent with response's");

    public static final TaErrorCode RESPONSE_AD_IS_EMPTY = new TaErrorCode(AD_IS_EMPTY_CODE, "Response Ad is empty");
    public static final TaErrorCode AD_OFFLINE_IS_UNENABLE = new TaErrorCode(OFFLINE_IS_UNENABLE, "Offline AD is unEnable");
    public static final TaErrorCode AD_OFFLINE_NO_Material= new TaErrorCode(OFFLINE_NO_Material, "Offline AD don't has Material");
    public static final TaErrorCode AD_OFFLINE_SHOW_COUNT_LIMIT = new TaErrorCode(OFFLINE_SHOW_COUNT_LIMIT, "Offline AD had show max count");
    public static final TaErrorCode HTTP_RESPONSE_ERROR = new TaErrorCode(HTTP_RESPONSE_ERROR_CODE, "http response is empty");
    public static final TaErrorCode INVALID_CRVT_TYPE = new TaErrorCode(INVALID_CRVT_CODE, "Invalid Crvt type.");
    public static final TaErrorCode SELF_AD_BE_FILTER = new TaErrorCode(AD_BE_FILTER_CODE, "ad be filter");
    public static final TaErrorCode NOT_SELF_AD = new TaErrorCode(NOT_SELF_AD_CODE, "not self ad error");
    public static final TaErrorCode NO_AD = new TaErrorCode(NO_AD_CODE, "no ad show, set visible gone");
    public static final TaErrorCode SENSITIVE_ERROR = new TaErrorCode(SENSITIVE_ERROR_CODE, "Sensitive AD");
    public static final TaErrorCode ADMEDIA_NO_FILL = new TaErrorCode(ADMEDIA_NO_FILL_CODE, "Admedia can not provide ad to this device, please contact the ad manager.");
    public static final TaErrorCode REGISTER_VIEW_ERROR = new TaErrorCode(REGISTER_VIEW_ERROR_CODE, "register view error");
    public static final TaErrorCode INVALID_URL = new TaErrorCode(INVALID_URL_CODE, "Invalid url.");
    public static final TaErrorCode AD_EXPIRE = new TaErrorCode(SPLASH_AD_EXPIRED,"ad expired");
    public static final TaErrorCode AD_NO_CACHED = new TaErrorCode(SPLASH_AD_NO_CACHED,"no ad");
    public static final TaErrorCode AD_NOT_AVALID = new TaErrorCode(SPLASH_AD_NOT_AVALID,"ad not avalid");
    public static final TaErrorCode AD_CONFIG_SILENCE = new TaErrorCode(AD_CONFIG_SILENCE_CODE,"ad is at silence");
    public static final TaErrorCode PLATFORM_IS_NOT_EXIT = new TaErrorCode(PLATFORM_NOT_EXIT, "ad platform is not exit.");
    public static final TaErrorCode UNKNOWN_ERROR = new TaErrorCode(UNKNOWN_ERROR_CODE, "Unkown error.");
    public static final TaErrorCode NOT_ALLOW_DEEPLINK = new TaErrorCode(NOT_ALLOW_DEEPLINK_CODE, "Not_allow_deeplink");

    // 解析异常
    public static final TaErrorCode AD_DATA_PARSE_RESPONSE_ERROR = new TaErrorCode(AD_DATA_PARSE_RESPONSE_ERROR_CODE, "ad data parse response error");

//    public static final TaErrorCode SENSITIVE_ERROR = new TaErrorCode(SENSITIVE_ERROR_CODE, "Sensitive AD");
//    public static final TaErrorCode AD_TYPE_ERROR = new TaErrorCode(AD_TYPE_ERROR_CODE, "Ad type is wrong");
//    public static final TaErrorCode AD_MODEL_ERROR = new TaErrorCode(AD_MODEL_ERROR_CODE, "Ad model is error");
//    public static final TaErrorCode HTTP_FRAME_ERROR = new TaErrorCode(HTTP_FRAME_ERROR_CODE, "http frame error");
//    public static final TaErrorCode ADX_TIMEOUT_ERROR = new TaErrorCode(ADX_TIMEOUT_ERROR_CODE, "tan time out");
//    public static final TaErrorCode MEDIATION_CLOSE_ERROR = new TaErrorCode(MEDIATION_CLOSE_ERROR_CODE, "mediation is closed by operational staff");

    private final int errorCode;
    private final String errorMessage;

    public TaErrorCode(int errorCode, String errorMessage) {
        if (TextUtils.isEmpty(errorMessage)) {
            errorMessage = "empty msg";
        }

        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public int getErrorCode() {
        return errorCode;
    }

    public String getErrorMessage() {
        return errorMessage;
    }
}
