package com.cloud.hisavana.sdk.common.tracking;

import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;

import java.io.Serializable;
import java.util.ArrayList;

/**
 * 服务端广告点击，曝光事件，相关字段存储
 */
public class TrackingBean implements Serializable {

    private String landingUrl;
    private String clickid;
    private String price;
    private int isInstallApk;
    private AdsDTO adsDTO;

    public TrackingBean(String landingUrl, String clickid, String price, int isInstallApk) {
        this.landingUrl = landingUrl;
        this.clickid = clickid;
        this.price = price;
        this.isInstallApk = isInstallApk;
    }
    public TrackingBean(String landingUrl, String clickid, String price, int isInstallApk, AdsDTO adsDTO) {
        this.landingUrl = landingUrl;
        this.clickid = clickid;
        this.price = price;
        this.isInstallApk = isInstallApk;
        this.adsDTO = adsDTO;
    }

    public String getLandingUrl() {
        return landingUrl;
    }

    public void setLandingUrl(String landingUrl) {
        this.landingUrl = landingUrl;
    }

    public String getClickid() {
        return clickid;
    }

    public String getPrice() {
        return price;
    }

    public int getIsInstallApk() {
        return isInstallApk;
    }

    public AdsDTO getAdsDTO() {
        return adsDTO;
    }
}
