package com.cloud.hisavana.sdk.data.bean.response;

import com.cloud.hisavana.sdk.R;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.transsion.core.CoreUtil;

import java.io.Serializable;
import java.util.List;

/**
 * Created by jianbing.yu on 2018/8/30.
 */

public class NativeBean implements Serializable {

    private String version; // 版本
    private Integer rating; // 评级(几星 1 2 3 4 5)
    private TitleDTO title; // 标题
    private DescriptDTO descript; // 描述
    private ButtonDTO button; // 按钮
    private LogoDTO logo; // logo
    private List<MainImagesDTO> mainImages; // 主图

    /**
     * 获取数据 统一判空 处理
     *
     * @return
     */
    public String getVersion() {
        return null == version ? "" : version;
    }

    public Integer getRating() {
        return rating == null ? 0 : rating;
    }

    public String getTitleTxt() {
        return null == title ? "" : title.getText();
    }

    public String getDescriptionTxt() {
        return null == descript ? "" : descript.getText();
    }

    /**
     * @param isInstallApk 是否安装推广应用1.非下载类广告 2. 已安装目标下载应用 3.未安装目标下载应用
     * @return 下载类广告展现时，按钮显示文案根据对方是否已安装目标应用区别显示： 已安装：打开应用/OPEN ,未安装：立即下载/INSTALL
     */
    public String getButtonTxt(int isInstallApk) {
        switch (isInstallApk){
            case Constants.INSTALL_APK_STATUS.DOWNLOAD_APP_INSTALLED:
                return CoreUtil.getContext().getResources().getString(R.string.open);
            case Constants.INSTALL_APK_STATUS.DOWNLOAD_APP_NOT_INSTALLED:
                return CoreUtil.getContext().getResources().getString(R.string.install);
        }
        return null == button ? "" : button.getText();
    }

    public String getLogoUrl() {
        return null == logo ? "" : logo.getUrl();
    }

    public LogoDTO getLogo() {
        return logo;
    }

    public void setLogo(LogoDTO logo) {
        this.logo = logo;
    }

    public List<MainImagesDTO> getMainImages() {
        return mainImages;
    }


    @Override
    public String toString() {
        return "NativeBean{" +
                "version='" + version + '\'' +
                ", rating=" + rating +
                ", title=" + title +
                ", descript=" + descript +
                ", button=" + button +
                ", logo=" + logo +
                ", mainImages=" + mainImages +
                '}';
    }


    // =============================================================================================


    public static class TitleDTO implements Serializable {

        private String text; //标题文本

        public String getText() {
            return null == text ? "" : text;
        }

        @Override
        public String toString() {
            return "TitleDTO{" +
                    "text='" + text + '\'' +
                    '}';
        }
    }

    public static class DescriptDTO implements Serializable {

        private String text; // 描述文本

        public String getText() {
            return null == text ? "" : text;
        }

        @Override
        public String toString() {
            return "DescriptDTO{" +
                    "text='" + text + '\'' +
                    '}';
        }
    }

    public static class ButtonDTO implements Serializable {

        private String text; // 按钮文本

        public String getText() {
            return null == text ? "" : text;
        }

        @Override
        public String toString() {
            return "ButtonDTO{" +
                    "text='" + text + '\'' +
                    '}';
        }
    }

    public static class LogoDTO implements Serializable {

        private String url; // Logo url
        private Integer width; // Logo 宽度
        private Integer height; // Logo 高度

        public String getUrl() {
            return null == url ? "" : url;
        }

        public Integer getWidth() {
            return null == width ? 0 : width;
        }

        public Integer getHeight() {
            return null == height ? 0 : height;
        }


        @Override
        public String toString() {
            return "LogoDTO{" +
                    "url='" + url + '\'' +
                    ", width=" + width +
                    ", height=" + height +
                    '}';
        }
    }

    public static class MainImagesDTO implements Serializable {

        private String url; // 主图片 url
        private Integer width; // 主图片 宽度
        private Integer height; // 主图片 高度

        public String getUrl() {
            return null == url ? "" : url;
        }

        public Integer getWidth() {
            return null == width ? 0 : width;
        }

        public Integer getHeight() {
            return null == height ? 0 : height;
        }

        @Override
        public String toString() {
            return "MainImagesDTO{" +
                    "url='" + url + '\'' +
                    ", width=" + width +
                    ", height=" + height +
                    '}';
        }
    }

}
