package com.cloud.hisavana.sdk.common.activity;
/* Top Secret */

import static com.cloud.hisavana.sdk.common.util.AdLogUtil.TRACK_TAG;
import static com.transsion.core.CoreUtil.getContext;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;

import com.cloud.hisavana.sdk.R;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.hisavana.sdk.common.tracking.TrackingBean;
import com.cloud.hisavana.sdk.common.tracking.TrackingManager;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * usage
 *
 * @author peng.sun
 * @data 2018/08/16
 * ========================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */

public class TAdExposureActivity extends Activity {

    private WebView webView;
    private ProgressBar bar;
    private boolean isRedirected = false;
    private static final String GPLINK_HTTPS = "https://play.google.com/store/apps/";
    private static final String GPLINK_HTTP = "http://play.google.com/store/apps/";
    private static final String GPLINK_MARKET = "market://";
    private static final String GPLINK_DOMAINNAME = "play.google.com/store/apps/";
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.tad_exposure_activity);
        bar = findViewById(R.id.pb_progress);
        initWebView();

        Log.i("zxb_log", "onCreate --> initWebView 完成");
    }

    private void initWebView() {
        TrackingBean trackingBean = (TrackingBean) getIntent().getSerializableExtra("trackingBean");
        String url = "";
        if (trackingBean != null){
             url = trackingBean.getLandingUrl();
        }

        //是gp地址，跳转到gp应用商店
        if (checkGpUrl(url)){
            return;
        }
        webView = (WebView) findViewById(R.id.wv_webview);
        webView.getSettings().setJavaScriptEnabled(true);
        webView.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        webView.getSettings().setSupportZoom(true);
        webView.getSettings().setUseWideViewPort(true);
        webView.getSettings().setLoadWithOverviewMode(true);
        webView.getSettings().setDisplayZoomControls(true);
        webView.getSettings().setAppCacheEnabled(true);
        webView.getSettings().setDomStorageEnabled(true);
        webView.setWebChromeClient(new WebChromeClient() {
            @Override
            public void onProgressChanged(WebView view, int newProgress) {
                if (newProgress == 100) {
                    bar.setVisibility(View.GONE);
                } else {
                    if (View.GONE == bar.getVisibility()) {
                        bar.setVisibility(View.VISIBLE);
                    }
                }
            }
        });
        webView.setWebViewClient(new WebViewClient() {
            /**
             * 多页面在同一个WebView中打开，就是不新建activity或者调用系统浏览器打开
             */
            @Override
            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                //AdLogUtil.Log().d(TAG,"shouldOverrideUrlLoading url=" + url);
                AdLogUtil.Log().d(TRACK_TAG,"shouldOverrideUrlLoading url=" + url);
                return goToNext(url);
            }

            @Override
            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {

                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                    if (request != null && request.getUrl() != null) {
                        if (!TextUtils.isEmpty(request.getUrl().toString())) {
                            AdLogUtil.Log().d(AdLogUtil.TAG,"shouldOverrideUrlLoading url=" + request.getUrl().toString());
                            return goToNext(request.getUrl().toString());
                        }
                    }
                }
                return true;
            }

            @Override
            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
                Log.i("zxb_log", "onPageStarted --> url="+url);
            }

            @Override
            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);

                if(webView.getProgress()==100){
                    AdLogUtil.Log().d("webview--","TAdExposureActivity onPageFinished time = " +" url=" + url);
                }

                Log.i("zxb_log", "onPageFinished: url="+url);

                if (!isRedirected) {
                    //  数据上报位置
                    AdLogUtil.Log().d(AdLogUtil.TAG,"onPageFinished" + ":" + webView == null ? "" : webView.getUrl());
                    if (bar != null && bar.getVisibility() != View.GONE) {
                        bar.setVisibility(View.GONE);
                    }

                    //String title = view.getTitle();
                    //if (!TextUtils.isEmpty(title)) {
                    //    tvTitle.setText(title);
                    //}
                    //if (!TextUtils.isEmpty(view.getUrl())) {
                    //    tvUrl.setText(view.getUrl());
                    //}
                }
                isRedirected = false;
            }

            /**
             *# android7.0 https无法正常显示修复
             */
            @Override
            public void onReceivedSslError(WebView view, final SslErrorHandler handler, SslError error) {
//                AdLogUtil.Log().d(AdLogUtil.TAG, "sslerror " + error.getPrimaryError());
//                handler.proceed();
//                super.onReceivedSslError(view, handler, error);
                AdLogUtil.Log().d(AdLogUtil.TAG,"sslerror " + error.getPrimaryError());
                final AlertDialog.Builder builder = new AlertDialog.Builder(TAdExposureActivity.this);
                builder.setMessage(R.string.web_ssl_error);
                builder.setPositiveButton("continue", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        handler.proceed();
                    }
                });
                builder.setNegativeButton("cancel", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        handler.cancel();
                        finish();
                    }
                });
                final AlertDialog dialog = builder.create();
                dialog.show();
            }
        });

        // 判断是 AdChoices 还是 Ad 点击事件
        if (getIntent() != null && getIntent().getBooleanExtra("isAdClick", false)) {

            // 广告点击事件  --> url 埋点数据
            DownUpPointBean pointBean = (DownUpPointBean) getIntent().getSerializableExtra("pointBean");
            url = processServerClickUrl(pointBean,trackingBean);
            Map<String, String > map = new HashMap() ;
            map.put( "Accept-Timezone" , "UTC") ;
            webView.loadUrl(url ,map);
        }else{
            webView.loadUrl(url);
        }
    }

    /**
     * 校验是否是gp地址
     * @param url
     * @return
     */
    private boolean checkGpUrl(String url){
        if (url.contains(GPLINK_DOMAINNAME)) {
            url = url.replaceAll(GPLINK_HTTPS, GPLINK_MARKET).replaceAll(GPLINK_HTTP,GPLINK_MARKET);
            startGp(url);
            return true;
        } else if (url.startsWith(GPLINK_MARKET)) {
            startGp(url);
            return true;
        }
        return false;
    }
    private void startGp(String url) {
        try {
            Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
            intent.setPackage("com.android.vending");
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            getContext().startActivity(intent);
            TAdExposureActivity.this.finish();
        } catch (Throwable e) {
        }
    }

    public boolean goToNext(String url) {
        Log.d("TAG", "webview get redirect url is:" + url);
        if (url != null && (!(url.startsWith("http:") || url.startsWith("https:")))) {
            try {
                //处理intent协议
                if (url.startsWith("intent://")) {
                    Intent intent;
                    intent = Intent.parseUri(url, Intent.URI_INTENT_SCHEME);
                    intent.addCategory("android.intent.category.BROWSABLE");
                    intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                    intent.setComponent(null);
                    intent.setSelector(null);
                    getContext().startActivity(intent);
                    TAdExposureActivity.this.finish();
                } else {
                    Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
                    intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                    getContext().startActivity(intent);
                    TAdExposureActivity.this.finish();
                }
            } catch (URISyntaxException e) {
                //pass
            } catch (Throwable e) {
                AdLogUtil.Log().e("No App to open receive the intent" + Log.getStackTraceString(e));
            }
            return true;
        } else {
            //校验是否是gp地址，是gp地址，跳转到gp应用商店，return true。否则，return false，webview处理url
            return checkGpUrl(url);
        }
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK && webView != null && webView.canGoBack()) {
            webView.goBack();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    protected void onDestroy() {
        if (webView != null) {
            ViewParent parent = webView.getParent();
            if (parent != null) {
                ((ViewGroup) parent).removeView(webView);
            }
            webView.stopLoading();
            // 退出时调用此方法，移除绑定的服务，否则某些特定系统会报错
            webView.getSettings().setJavaScriptEnabled(false);
            webView.clearHistory();
            webView.removeAllViews();
            webView.destroy();
        }
        super.onDestroy();
    }



    /**
     *
     * webview打开clickurl，处理clickurl
     * @param pointBean
     * @param trackingBean
     * @return
     */
    private String processServerClickUrl(DownUpPointBean pointBean, TrackingBean trackingBean){
        if (trackingBean == null || TextUtils.isEmpty(trackingBean.getLandingUrl())) {
            AdLogUtil.Log().d(TRACK_TAG, "processServerClickUrl --> null == url || null == pointBean");
            return "";
        }

        //是eagllwin地址才需要上报参数给服务器
        if (pointBean == null || !TrackingManager.isEagllwinLink(trackingBean.getLandingUrl())){
            return trackingBean.getLandingUrl();
        }

        AdLogUtil.Log().d(TRACK_TAG, "TrackingManager --> processUrl --> pointBean = " + pointBean.toString());
        return TrackingManager.processReportServerField(pointBean, trackingBean, true);
    }
}

