package com.cloud.hisavana.sdk.common.http;

import static com.cloud.hisavana.sdk.common.util.AdLogUtil.IMG_TAG;
import static com.transsion.core.CoreUtil.getContext;

import android.util.Log;

import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.listener.DrawableResponseListener;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.transsion.http.HttpClient;
import com.transsion.http.ImageURL;
import com.transsion.http.RequestCall;
import com.transsion.http.cache.IDiskCache;
import com.transsion.http.impl.HttpCallbackImpl;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Created by peng.sun on 2017/6/19.
 */

public class DownLoadRequest extends RequestBase<DrawableResponseListener> {


    boolean isSuccess = false;

    /**
     * 用于埋点
     */
    private AdsDTO adsDTO;
    //  物料类型 1=logo 2=大图 int
    private int m_type;

    public DownLoadRequest setAdsDTO(AdsDTO ads,int type){
        this.adsDTO=ads;
        this.m_type=type;
        return this;
    }

    private String url = "";
    private int isPreCache = Constants.ImageLoadType.IMAGE_RAM_INCLUDED;

    public DownLoadRequest setUrl(String url) {
        this.url = url;
        return this;
    }

    public DownLoadRequest setListener(DrawableResponseListener listener) {
        this.mListener = listener;
        return this;
    }

    public DownLoadRequest setPreCache(int preCache) {
        this.isPreCache = preCache;
        return this;
    }

    /**
     * 前期执行检查网络
     */
    public void netRequestPreExecute() {
//        20211014 1.0版本暂时去除
//        if (ADOkHttpClient.getInstance().getOkHttpClient() != null) {
//            AdLogUtil.Log().d(AdLogUtil.TAG,IMG_TAG,"媒体使用了 Okhttp");
//            try {
//                switchOkhttp();
//            }catch (Exception e){
//                AdLogUtil.Log().d(AdLogUtil.TAG,IMG_TAG,"媒体使用 Okhttp 异常 " + e.getMessage());
//                mListener.onServerRequestFailure(new TaErrorCode(0, "Okhttp - " + e.getMessage()));
//            }
//            return;
//        }
//
//        AdLogUtil.Log().d(IMG_TAG,"媒体没有使用 Okhttp 正常走流程 ");

        /**
         * 分发网络请求
         */
        netRequestPosExecute();
    }

    @Override
    protected void netRequestPosExecute() {
        try {

            RequestCall requestCall =HttpClient.image(getContext())
                    .log(false)
                    .cache(true)
                    .connectTimeout(TIMEOUT_IN_MILLIONS)
                    .readTimeout(20 * 1000)
                    .url(url)
                    .build();

            IDiskCache iDiskCache = requestCall.getDiskCache();
            File file  = iDiskCache.get(new ImageURL(url));
            boolean isCache = (file != null && file.exists());

            // 不是缓存才上报
            if (!isCache){
                downloadStart(AthenaTracker.DOWNLOAD_WAY_HTTP_URL_CONNECTION);
            }

            requestCall.execute(new HttpCallbackImpl(true) {
                        @Override
                        public void onSuccess(int statusCode, byte[] data) {
                            if (mListener != null && mListener instanceof DrawableResponseListener) {
                                mListener.onServerRequestSuccess(isPreCache, statusCode, data, null);
                            }
                            isSuccess = true;
                        }

                        @Override
                        public void onResponseHeader(Map<String, List<String>> map) {
                            super.onResponseHeader(map);
                            // 如果是客户端读取的应该是x-response-cdn
                            // 如果是服务端应该是拿x-request-cdn
                            if (isSuccess){
                                isSuccess = false;
                                String cdn = "";
                                if (null != map && !map.isEmpty()){
                                    List<String> strings = map.get("x-response-cdn");
                                    if (null != strings && !strings.isEmpty()){
                                        cdn = strings.get(0);
                                    }
                                }
                                downloadSuccess(AthenaTracker.DOWNLOAD_WAY_HTTP_URL_CONNECTION,cdn);
                            }
                        }

                        @Override
                        public void onFailure(int statusCode, byte[] bytes, Throwable throwable) {
                            if (mListener != null) {
                                mListener.onServerRequestFailure(statusCode, bytes, throwable);
                            }
                            downloadError(AthenaTracker.DOWNLOAD_WAY_HTTP_URL_CONNECTION,throwable.getMessage());
                        }

                        @Override
                        public void onSuccess(int statusCode, byte[] responseBody, final String filePath) {
                            if (mListener != null && mListener instanceof DrawableResponseListener) {
                                mListener.onServerRequestSuccess(isPreCache, statusCode, responseBody, filePath);
                            }
                            isSuccess = true;
                        }
                    });
        } catch (Throwable e) {
            AdLogUtil.Log().e(Log.getStackTraceString(e));
        }
    }

    /**
     * 开始下载 下载成功 下载失败 日志上报
     * info          广告详情
     * download_way 下载方式 1.HttpUrlConnection 2.Okhttp  int
     * m_status     物料事件状态  1=开始加载 2=加载成功 3=加载失败 int
     * errorcode    失败原因 string
     * m_type       物料类型 1=logo 2=大图 int
     */
    private void downloadStart(int download_way){
        AthenaTracker.trackImageDownload(adsDTO,download_way,AthenaTracker.M_STATUS_STAR,"",m_type,"");
    }

    private void downloadSuccess(int download_way,String cdn){
        AthenaTracker.trackImageDownload(adsDTO,download_way,AthenaTracker.M_STATUS_SUCCESS,"",m_type,cdn);
    }

    private void downloadError(int download_way,String errorMsg){
        AthenaTracker.trackImageDownload(adsDTO,download_way,AthenaTracker.M_STATUS_ERROR,errorMsg,m_type,"");
    }


}
