package com.cloud.hisavana.sdk.data.bean.response;

import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;

import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.util.AESUtils;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.data.bean.request.AdxImpBean;
import com.google.gson.annotations.SerializedName;
import com.transsion.core.CoreUtil;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author: wenjing.luo
 * @date: 2021/8/5
 * ==================================
 * Copyright (c) 2021 TRANSSION.Co.Ltd.
 * All rights reserved.
 * <p>
 * 广告返回数据bean
 */
public class AdsDTO implements Serializable {

    /**
     * 下面是 服务器返回字段 ===========================================================================
     */
    private Integer id; //自增id
    private Long advertiserId; //广告主id
    private Long planId; //计划id

    @Deprecated
    private String planType; //1.5版本新增 计划类型
    private Long adGroupId; //广告组id
    private Long adCreativeId; //广告创意id
    @Deprecated
    private Integer cost; //价格(美分）/CPM
    @Deprecated
    private Double bidPrice; // 1.5版本新增 竞价价格（美分）
    private String packageName; // 包名

    private String clickUrl; // 点击链接地址
    //1.3.0之前的版本需要
    @Deprecated
    private String deepLinkUrl; //应用深链接地址
    @SerializedName("clickUrls")
    private ArrayList<String> storeDeeplink; //应用深链接地址
    private ArrayList<String> showTrackingUrls; // 当广告展示后，触发此字段中的tracking url
    private String showTrackingSecretKey; //曝光加密串
    private ArrayList<String> clickTrackingUrls; //当广告被点击后，触发此字段中的tracking url

    private String adChoiceImageUrl;//广告平台标志图片地址 商标
    private String adChoiceClickUrl;//广告平台标志链接地址 点击商标后的落地
    private String adChoiceLegalText;//广告平台标志法律条文 不用

    private String defaultAdExpirationTime;//打底广告到期时间,时间格式同上
    private Integer defaultAdShowCount;//打底广告曝光次数

    // 1.5版本之后 弃用，保留字段兼容老版本
    @Deprecated
    private String imageUrl;//图片链接
    @Deprecated
    private Integer imageWidth;
    @Deprecated
    private Integer imageHeight;

    private NativeBean nativeObject; // Native material
    private String extInfo;

    @Deprecated
    private String scale;//1.5版本新增 广告尺寸
    @Deprecated
    private String advSeatType;//1.5版本新增 广告位类型 通过这个判断使用老版本还是新版本广告样式
    private String materialStyle;//1.5版本新增 广告样式


    //1.3.0版本新增
    private Double firstPrice;//一价
    private Double secondPrice;//二价
    private Integer commissionRatio;//分成系数
    private String deepLinkUrlFirst; //deepLinkUrl中的第一个可拉起的应用深链接地址

    private int is_timeout;
    //曝光上报 二价曝光
    public String getNewPrice() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("_first_price=");
            stringBuilder.append(firstPrice);
            stringBuilder.append("&");
            stringBuilder.append("_second_price=");
            stringBuilder.append(secondPrice);
            stringBuilder.append("&");
            stringBuilder.append("_ratio=");
            stringBuilder.append(commissionRatio);
            AdLogUtil.Log().d(AdLogUtil.SECOND_PRICE_TAG, "*----> AdsDTO getNewPrice() = " + stringBuilder.toString());
            //AES加密
            byte[] bytes = AESUtils.encrypt(stringBuilder.toString()).getBytes();
            //Base64 加密
            return Base64.encodeToString(bytes, Base64.NO_WRAP);
        } catch (Exception e) {
            AdLogUtil.Log().e("AdsDTO getNewPrice() error = " + Log.getStackTraceString(e));
        }
        return "";
    }

    //点击上报 二价曝光
    public String getNewPrice_Click() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("p1=");
            stringBuilder.append(firstPrice);
            stringBuilder.append("&");
            stringBuilder.append("p2=");
            stringBuilder.append(secondPrice);
            stringBuilder.append("&");
            stringBuilder.append("t=");
            stringBuilder.append(commissionRatio);
            AdLogUtil.Log().d(AdLogUtil.SECOND_PRICE_TAG, "*----> AdsDTO getNewPrice_Click() = " + stringBuilder.toString());
            return stringBuilder.toString();
        } catch (Exception e) {
            AdLogUtil.Log().e("AdsDTO getNewPrice_Click() error = " + Log.getStackTraceString(e));
        }
        return "";
    }

    //曝光，点击上报 是否安装推广应用1.非下载类广告 2. 已安装目标下载应用 3.未安装目标下载应用
    public int getInstallApk() {
        if (TextUtils.isEmpty(packageName)) {
            return Constants.INSTALL_APK_STATUS.NON_DOWNLOAD_AD;
        } else {
            if (CoreUtil.getContext() == null) {
                return Constants.INSTALL_APK_STATUS.ERROR_SITUATION;
            }
            try {
                // 通过包名获取此APP详细信息，包括Activities、services、versioncode、name等等
                PackageInfo packageinfo = CoreUtil.getContext().getPackageManager().getPackageInfo(packageName, 0);
                if (packageinfo == null) {
                    return Constants.INSTALL_APK_STATUS.DOWNLOAD_APP_NOT_INSTALLED;
                }
                // 创建一个类别为CATEGORY_LAUNCHER的该包名的Intent
                Intent resolveIntent = new Intent(Intent.ACTION_MAIN, null);
                resolveIntent.addCategory(Intent.CATEGORY_LAUNCHER);
                resolveIntent.setPackage(packageinfo.packageName);

                // 通过getPackageManager()的queryIntentActivities方法遍历
                List<ResolveInfo> resolveinfoList = CoreUtil.getContext().getPackageManager()
                        .queryIntentActivities(resolveIntent, 0);
                if (resolveinfoList == null || resolveinfoList.size() == 0){
                    return Constants.INSTALL_APK_STATUS.DOWNLOAD_APP_NOT_INSTALLED;
                }
                ResolveInfo resolveinfo = resolveinfoList.iterator().next();
                if (resolveinfo != null) {
                    return Constants.INSTALL_APK_STATUS.DOWNLOAD_APP_INSTALLED;
                }else {
                    return Constants.INSTALL_APK_STATUS.DOWNLOAD_APP_NOT_INSTALLED;
                }
            }catch (Exception e){
                AdLogUtil.Log().e(Log.getStackTraceString(e));
                if (Build.VERSION.SDK_INT >= 30){
                    return Constants.INSTALL_APK_STATUS.ERROR_SITUATION;
                }else {
                    return Constants.INSTALL_APK_STATUS.DOWNLOAD_APP_NOT_INSTALLED;
                }
            }
        }
    }

    public int getRequestType() {
        if (impBeanRequest != null){
            return impBeanRequest.requestType;
        }
        return -1;
    }

    public Double getFirstPrice() {
        return firstPrice == null ? 0 : firstPrice;
    }

    public void setSecondPrice(double secondPrice){
        AdLogUtil.Log().d(AdLogUtil.SECOND_PRICE_TAG,"new secondPrice" + secondPrice + "old secondPrice" + this.secondPrice);
        //高于旧二价，低于一价，才赋值
        if (secondPrice > this.getSecondPrice() && secondPrice <= this.getFirstPrice()){
            this.secondPrice = secondPrice;
        }
    }

    public Double getSecondPrice() {
         return secondPrice == null ? 0 : secondPrice;
    }

    public Long getRequestTs() {
        if (impBeanRequest != null){
            return impBeanRequest.getRequestTs();
        }
        return 0l;
    }
    public int getAdCount() {
        if (impBeanRequest != null){
            return impBeanRequest.mAdCount;
        }
        return 0;
    }

    public int getIs_timeout() {
        return is_timeout;
    }

    public void setIs_timeout(int is_timeout) {
        this.is_timeout = is_timeout;
    }

    public Integer getId() {
        return id == null ? 0 : id;
    }

    public Long getAdvertiserId() {
        return advertiserId == null ? 0 : advertiserId;
    }

    public Long getPlanId() {
        return planId == null ? 0 : planId;
    }

    public Long getAdGroupId() {
        return adGroupId == null ? 0 : adGroupId;
    }

    public Long getAdCreativeId() {
        return adCreativeId == null ? 0 : adCreativeId;
    }

    public String getPackageName() {
        return null == packageName ? "" : packageName;
    }

    public String getClickUrl() {
        return null == clickUrl ? "" : clickUrl;
    }

    public ArrayList<String> getStoreDeeplink() {
        return storeDeeplink;
    }

    public void setStoreDeeplink(ArrayList<String> storeDeeplink) {
        this.storeDeeplink = storeDeeplink;
    }

    public String getDeepLinkUrl() {
        return deepLinkUrl;
    }

    public String getDeepLinkUrlFirst() {
        return deepLinkUrlFirst == null ? "" : deepLinkUrlFirst;
    }

    public void setDeepLinkUrlFirst(String deepLinkUrlFirst) {
        this.deepLinkUrlFirst = deepLinkUrlFirst;
    }

    public List<String> getShowTrackingUrls() {
        return showTrackingUrls;
    }

    public String getAdChoiceImageUrl() {
        return null == adChoiceImageUrl ? "" : adChoiceImageUrl;
    }

    public String getAdChoiceClickUrl() {
        return null == adChoiceClickUrl ? "" : adChoiceClickUrl;
    }

    public String getAdChoiceLegalText() {
        return null == adChoiceLegalText ? "" : adChoiceLegalText;
    }

    public String getDefaultAdExpirationTime() {
        return null == defaultAdExpirationTime ? "" : defaultAdExpirationTime;
    }

    public Integer getDefaultAdShowCount() {
        return defaultAdShowCount == null ? 0 : defaultAdShowCount;
    }

    public void setDefaultAdShowCount(Integer defaultAdShowCount) {
        this.defaultAdShowCount = defaultAdShowCount;
    }

    public NativeBean getNativeObject() {
        return nativeObject;
    }

    public String getPlanType() {
        return null == planType ? "" : planType;
    }

    public String getShowTrackingSecretKey() {
        return null == showTrackingSecretKey ? "" : showTrackingSecretKey;
    }

    public ArrayList<String> getClickTrackingUrls() {
        return clickTrackingUrls;
    }

    public String getImageUrl() {
        return null == imageUrl ? "" : imageUrl;
    }

    public Integer getImageWidth() {
        return null == imageWidth ? 0 : imageWidth;
    }

    public Integer getImageHeight() {
        return null == imageHeight ? 0 : imageHeight;
    }

    public String getExtInfo() {
        return null == extInfo ? "" : extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }

    public String getScale() {
        return scale;
    }

    public String getAdvSeatType() {
        return advSeatType;
    }

    public String getMaterialStyle() {
        return null == materialStyle ? "" : materialStyle;
    }


    /**
     * 下面是 自定义 属性  ===========================================================================
     */
    private List<AbTestDTO> abTest;
    private Integer cacheTime;//缓存时长：开屏-4、其他-1 （小时）
    private AdxImpBean impBeanRequest;
    private Long fill_ts;//刚请求回数据的时间
    private Long imp_ts;//track使用
    private String uuid;//在native广告中用到
    //广告过期时间配置 (分钟)
    private Integer splashCountTime = 4; // 倒计时 5S 第4 秒开始才可以点击跳转
    private Boolean isACReady;//adchoice是否预加载成功
    //图片是否下载成功
    private Boolean imageIsDownload;
    //取打底广告时用到，取未曝光过的打底广告
    //如果都被曝光过，则全置为false，从第一个开始取
    private Boolean isExpiration;

    private Long actualShowTime;//广告素材实际曝光时间
    private Integer actualShowRate = 0;//广告素材实际曝光比例
    private String showArea = "0*0";//广告素材曝光面积，宽*高

    private Integer isEffectiveShow;//是否有效曝光 1/0 1=有效 0=无效
    private Integer isDefaultAdFirstShow = 0;//是否初次曝光（仅在打底广告时记录）   1=是 0=否 int
    private Integer showReportTimeType;//展现上报时机类型 1. 展现时上报 2. 达标时上报 3. 离开时上报

    public AdxImpBean getImpBeanRequest() {
        return impBeanRequest;
    }

    public void setImpBeanRequest(AdxImpBean impBeanRequest) {
        this.impBeanRequest = impBeanRequest;
    }

    public List<AbTestDTO> getAbTest() {
        return abTest;
    }

    public String getCodeSeatId() {
        if (impBeanRequest != null){
            return impBeanRequest.pmid;
        }
        return "";
    }

    public Integer getCodeSeatType() {
        if (impBeanRequest != null){
            return impBeanRequest.adt;
        }
        return -1;
    }

    public Integer getCacheTime() {
        return cacheTime == null ? 0 : cacheTime;
    }


    public Integer getIsDefaultAd() {
        if (impBeanRequest != null){
            return impBeanRequest.defaultAd ? 1 : 0;
        }
        return 0;
    }

    public String getRid() {
        if (impBeanRequest != null){
            return impBeanRequest.requestId;
        }
        return "";
    }

    public Long getFill_ts() {
        return fill_ts == null ? 0 : fill_ts;
    }

    public Long getImp_ts() {
        return imp_ts == null ? 0 : imp_ts;
    }

    public Integer getSplashCountTime() {
        return splashCountTime == null ? 0 : splashCountTime;
    }

    public Boolean getACReady() {
        return isACReady == null ? false : isACReady;
    }

    public Boolean getImageIsDownload() {
        return imageIsDownload == null ? false : imageIsDownload;
    }

    public Boolean getExpiration() {
        return isExpiration == null ? false : isExpiration;
    }

    public Integer getActualShowRate() {
        return actualShowRate == null ? 0 : actualShowRate;
    }

    public Long getActualShowTime() {
        return actualShowTime == null ? 0L : actualShowTime;
    }

    public Integer getIsEffectiveShow() {
        return isEffectiveShow == null ? 0 : isEffectiveShow;
    }

    public Integer getIsDefaultAdFirstShow() {
        return isDefaultAdFirstShow == null ? 0 : isDefaultAdFirstShow;
    }

    public String getUuid() {
        return null == uuid ? "" : uuid;
    }

    public Integer getShowReportTimeType() {
        return showReportTimeType;
    }

    public void setShowReportTimeType(Integer showReportTimeType) {
        this.showReportTimeType = showReportTimeType;
    }

    public String getShowArea() {
        return showArea;
    }

    public void setShowArea(String showArea) {
        this.showArea = showArea;
    }

    /**
     * =============================================================================================
     *
     * @return
     */
    @Override
    public String toString() {
        return "AdsDTO{" +
                "id=" + id +
                ", advertiserId=" + advertiserId +
                ", planId=" + planId +
                ", planType='" + planType + '\'' +
                ", adGroupId=" + adGroupId +
                ", adCreativeId=" + adCreativeId +
                ", cost=" + cost +
                ", bidPrice=" + bidPrice +
                ", packageName='" + packageName + '\'' +
                ", clickUrl='" + clickUrl + '\'' +
                ", deepLinkUrl='" + deepLinkUrl + '\'' +
                ", showTrackingUrls=" + showTrackingUrls +
                ", showTrackingSecretKey='" + showTrackingSecretKey + '\'' +
                ", clickTrackingUrls=" + clickTrackingUrls +
                ", adChoiceImageUrl='" + adChoiceImageUrl + '\'' +
                ", adChoiceClickUrl='" + adChoiceClickUrl + '\'' +
                ", adChoiceLegalText='" + adChoiceLegalText + '\'' +
                ", defaultAdExpirationTime='" + defaultAdExpirationTime + '\'' +
                ", defaultAdShowCount=" + defaultAdShowCount +
                ", imageUrl='" + imageUrl + '\'' +
                ", imageWidth=" + imageWidth +
                ", imageHeight=" + imageHeight +
                ", nativeObject=" + nativeObject +
                ", extInfo='" + extInfo + '\'' +
                ", scale='" + scale + '\'' +
                ", advSeatType='" + advSeatType + '\'' +
                ", materialStyle='" + materialStyle + '\'' +
                ", abTest=" + abTest +
                ", cacheTime=" + cacheTime +
                ", fill_ts=" + fill_ts +
                ", imp_ts=" + imp_ts +
                ", uuid='" + uuid + '\'' +
                ", splashCountTime=" + splashCountTime +
                ", isACReady=" + isACReady +
                ", imageIsDownload=" + imageIsDownload +
                ", isExpiration=" + isExpiration +
                ", actualShowRate=" + actualShowRate +
                ", isEffectiveShow=" + isEffectiveShow +
                ", isDefaultAdFirstShow=" + isDefaultAdFirstShow +
                '}';
    }


    /**
     * 获取 图片的地址 ================================================================================
     *
     * @return
     */
    public String getAdImgUrl() {
        String url = "";
        if (null != nativeObject && null != nativeObject.getMainImages() && nativeObject.getMainImages().size() > 0) {
            url = nativeObject.getMainImages().get(0).getUrl();
        }
        return url;
    }

    public Integer getAdImageWidth() {
        Integer width = 0;
        if (null != nativeObject && null != nativeObject.getMainImages() && nativeObject.getMainImages().size() > 0) {
            width = nativeObject.getMainImages().get(0).getWidth();
        }
        return width;
    }

    public Integer getAdImageHeight() {
        Integer height = 0;
        if (null != nativeObject && null != nativeObject.getMainImages() && nativeObject.getMainImages().size() > 0) {
            height = nativeObject.getMainImages().get(0).getHeight();
        }
        return height;
    }


    /**
     * 下面是所有类型的 set ===========================================================================
     *
     * @param id
     */
    public void setId(Integer id) {
        this.id = id;
    }

    public void setAdvertiserId(Long advertiserId) {
        this.advertiserId = advertiserId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public void setPlanType(String planType) {
        this.planType = planType;
    }

    public void setAdGroupId(Long adGroupId) {
        this.adGroupId = adGroupId;
    }

    public void setAdCreativeId(Long adCreativeId) {
        this.adCreativeId = adCreativeId;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setClickUrl(String clickUrl) {
        this.clickUrl = clickUrl;
    }

    public void setDeepLinkUrl(String deepLinkUrl) {
        this.deepLinkUrl = deepLinkUrl;
    }

    public void setShowTrackingUrls(ArrayList<String> showTrackingUrls) {
        this.showTrackingUrls = showTrackingUrls;
    }

    public void setShowTrackingSecretKey(String showTrackingSecretKey) {
        this.showTrackingSecretKey = showTrackingSecretKey;
    }

    public void setClickTrackingUrls(ArrayList<String> clickTrackingUrls) {
        this.clickTrackingUrls = clickTrackingUrls;
    }

    public void setAdChoiceImageUrl(String adChoiceImageUrl) {
        this.adChoiceImageUrl = adChoiceImageUrl;
    }

    public void setAdChoiceClickUrl(String adChoiceClickUrl) {
        this.adChoiceClickUrl = adChoiceClickUrl;
    }

    public void setAdChoiceLegalText(String adChoiceLegalText) {
        this.adChoiceLegalText = adChoiceLegalText;
    }

    public void setDefaultAdExpirationTime(String defaultAdExpirationTime) {
        this.defaultAdExpirationTime = defaultAdExpirationTime;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public void setImageWidth(Integer imageWidth) {
        this.imageWidth = imageWidth;
    }

    public void setImageHeight(Integer imageHeight) {
        this.imageHeight = imageHeight;
    }

    public void setNativeObject(NativeBean nativeObject) {
        this.nativeObject = nativeObject;
    }

    public void setScale(String scale) {
        this.scale = scale;
    }

    public void setAdvSeatType(String advSeatType) {
        this.advSeatType = advSeatType;
    }

    public void setMaterialStyle(String materialStyle) {
        this.materialStyle = materialStyle;
    }

    public void setAbTest(List<AbTestDTO> abTest) {
        this.abTest = abTest;
    }

    public void setCacheTime(Integer cacheTime) {
        this.cacheTime = cacheTime;
    }

    public void setFill_ts(Long fill_ts) {
        this.fill_ts = fill_ts;
    }

    public void setImp_ts(Long imp_ts) {
        this.imp_ts = imp_ts;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setSplashCountTime(Integer splashCountTime) {
        this.splashCountTime = splashCountTime;
    }

    public void setACReady(Boolean ACReady) {
        isACReady = ACReady;
    }

    public void setImageIsDownload(Boolean imageIsDownload) {
        this.imageIsDownload = imageIsDownload;
    }

    public void setExpiration(Boolean expiration) {
        isExpiration = expiration;
    }

    public void setActualShowRate(Integer actualShowRate) {
        this.actualShowRate = actualShowRate;
    }

    public void setActualShowTime(Long actualShowTime) {
        this.actualShowTime = actualShowTime;
    }

    public void setIsEffectiveShow(Integer isEffectiveShow) {
        this.isEffectiveShow = isEffectiveShow;
    }

    public void setIsDefaultAdFirstShow(Integer isDefaultAdFirstShow) {
        this.isDefaultAdFirstShow = isDefaultAdFirstShow;
    }
}
