/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.athena;

import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import com.cloud.hisavana.sdk.common.athena.AthenaTrackerInvoker;
import com.cloud.hisavana.sdk.common.athena.AthenaUtil;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.data.bean.request.AdxImpBean;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;

public class AthenaTracker {
    public static final int DOWNLOAD_WAY_HTTP_URL_CONNECTION = 1;
    public static final int DOWNLOAD_WAY_OKHTTP = 2;
    public static final int M_STATUS_STAR = 1;
    public static final int M_STATUS_SUCCESS = 2;
    public static final int M_STATUS_ERROR = 3;
    public static final int M_TYPE_LOGO = 1;
    public static final int M_TYPE_LARGE_IMG = 2;
    public static final int M_TYPE_AD_CHOICE_VIEW = 3;
    public static Handler handler;
    public static HandlerThread handlerThread;

    private static synchronized void initHandler() {
        if (handler == null) {
            handlerThread = AthenaUtil.getHanderThread();
            AthenaUtil.start();
            handler = new Handler(handlerThread.getLooper());
            AdLogUtil.Log().d("ssp", "AthenaTracker initHandlerThread");
        }
    }

    public static Bundle getBundle(Bundle bundle) {
        return AthenaTrackerInvoker.getBundle(bundle);
    }

    public static void trackInNewThread(Runnable runnable) {
        AthenaTracker.initHandler();
        handler.post(runnable);
    }

    public static void trackShow(final AdsDTO info) {
        AthenaTracker.trackInNewThread(new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackShow(info);
            }
        });
    }

    public static void trackDeeplink(final AdsDTO info) {
        AthenaTracker.trackInNewThread(new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackDeeplink(info);
            }
        });
    }

    public static void trackImageDownload(final AdsDTO info, final int download_way, final int m_status, final String errorcode, final int m_type, final String cdn) {
        AthenaTracker.trackInNewThread(new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackImageDownload(info, download_way, m_status, errorcode, m_type, cdn);
            }
        });
    }

    public static void trackSspRequest(final AdxImpBean info) {
        AthenaTracker.trackInNewThread(new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackSspRequest(info);
            }
        });
    }

    public static void trackSspReturn(final AdsDTO info, final TaErrorCode adError, final AdxImpBean adxImpBean) {
        AthenaTracker.trackInNewThread(new Runnable(){

            @Override
            public void run() {
                AthenaTrackerInvoker.trackSspReturn(info, adError, adxImpBean);
            }
        });
    }
}

