package com.cloud.hisavana.sdk.ad.base;

import android.util.Log;

import com.cloud.hisavana.sdk.BuildConfig;
import com.cloud.hisavana.sdk.common.athena.PostConstant;
import com.cloud.hisavana.sdk.common.gsonutil.GsonUtil;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.DeviceUtil;
import com.cloud.hisavana.sdk.data.bean.request.PSRequestBody;
import com.transsion.core.utils.AppUtil;

import java.util.Locale;

/**
 * Created by wenjing.luo on 2022/3/28.
 * ps素材请求参数
 */
public class PsPostBody {
    private static PSRequestBody requestParam = null;
    private final static String caller = "B1-SDK";

    public static String getAdPostBody(String gplink) {
        try {
            if (requestParam == null) {
                requestParam = new PSRequestBody();
                requestParam.setCaller(caller);
                requestParam.setGaid(DeviceUtil.getGAId());
                requestParam.setCountryCode(Locale.getDefault().getCountry());
                requestParam.setLang(Locale.getDefault().getLanguage());
                requestParam.setBrand(PostConstant.getBrand());
                requestParam.setModel(PostConstant.getModel());
                requestParam.setSystemVerCode(android.os.Build.VERSION.SDK_INT);
                requestParam.setCpu(android.os.Build.CPU_ABI);
                requestParam.setMediaPackageName(AppUtil.getPkgName());
                requestParam.setAdSdkVersionCode(BuildConfig.VERSION_CODE);
            }
            requestParam.setGpLink(gplink);
            requestParam.setTimestamp(System.currentTimeMillis());

            return GsonUtil.toJson(requestParam);
        }catch (Throwable e){
            AdLogUtil.Log().e(Log.getStackTraceString(e));
        }
        return "";
    }

}
