package com.cloud.hisavana.sdk.common.activity;

import android.app.Activity;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.constraintlayout.widget.ConstraintLayout;

import com.cloud.hisavana.sdk.R;
import com.cloud.hisavana.sdk.ad.base.PlatformUtil;
import com.cloud.hisavana.sdk.api.config.SspAd;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.bean.AdImage;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.DownLoadRequest;
import com.cloud.hisavana.sdk.common.http.listener.DrawableResponseListener;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.hisavana.sdk.common.tranmeasure.AdImpressionListenerImpl;
import com.cloud.hisavana.sdk.common.tranmeasure.MeasureSession;
import com.cloud.hisavana.sdk.common.tranmeasure.MeasureSessionManager;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.ImageDownloadHelper;
import com.cloud.hisavana.sdk.common.widget.TranCircleImageView;
import com.cloud.hisavana.sdk.common.widget.ViewGestureDetector;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.transsion.core.CoreUtil;

import java.util.List;


/**
 * sdk 1.5需求
 * https://k8sajlplqs.feishu.cn/docs/doccn6cruUTiZb7fHsDeRjO8MYg
 * https://k8sajlplqs.feishu.cn/docs/doccnFsETC3o5MMiLdockCZ3Ucc#
 * <p>
 * 模板广告
 */
public class TAdInterstitialActivity extends Activity {
    // adm展示的webView
    public static WebView webView;
    // 手势监视器
    private ViewGestureDetector gestureDetector;

    // 布局里面的View
    private TranCircleImageView ivImg;  // Banner 主图
    private ImageView ivAdChoices;      // 广告来源
    private ImageView ivIcon;           // icon
    private ViewGroup llRoot;        // 内容部分
    private TextView tvName;            // 标题
    private TextView tvDescription;     // 介绍
    private TextView tvBtn;             // 按钮

    // 传递过来的数据
    private AdsDTO mAdBean = null;
    private String broadCastPrefix = ""; // 广播用的

    /**
     * 埋点 坐标点
     */
    private float downX = -1;
    private float downY = -1;
    private float upX = -1;
    private float upY = -1;

    // 优化多次点击
    private long oldTime;

    private static final String TAG_CLOSE = "ad_close";

    /**
     * broadcast constants
     */
    public static final String ERROR_CODE = "error_code";
    public static final String ERROR_MSG = "error_msg";


    // =============================================================================================


    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        setTitle(null);
        super.onCreate(savedInstanceState);

        if (null != savedInstanceState) {
            SspAd.AppId = savedInstanceState.getString(Constants.INTERSTITIAL_APP_ID);
        }

        // 传递过来的数据
        if (getIntent() != null) {
            broadCastPrefix = (String) getIntent().getStringExtra("BroadCastPrefix");
            mAdBean = (AdsDTO) getIntent().getSerializableExtra("mAdBean");
        }

        if (null == mAdBean || null == mAdBean.getMaterialStyle()) {
            AdLogUtil.Log().d(AdLogUtil.TAG, "TAdInterstitialActivity --> null == mAdBean || null == mAdBean.materialStyle");
            this.finish();
            return;
        }

        AdLogUtil.Log().d(AdLogUtil.TAG, "*----> TAdInterstitialActivity --> 当前样式为=" + mAdBean.getMaterialStyle());

        // 根据不同的模板显示不同的布局
        if (TextUtils.isEmpty(mAdBean.getAdm())){
            switch (mAdBean.getMaterialStyle()) {
                case Constants.INTERSTITIAL_MATERIAL_STYLE_I1101:
                    setContentView(R.layout.activity_t_ad_interstitial_1101_layout);
                    break;
                case Constants.INTERSTITIAL_MATERIAL_STYLE_I1102:
                    setContentView(R.layout.activity_t_ad_interstitial_1102_layout);
                    break;
                case Constants.INTERSTITIAL_MATERIAL_STYLE_I1103:
                    setContentView(R.layout.activity_t_ad_interstitial1103_layout);
                    break;
                case Constants.INTERSTITIAL_MATERIAL_STYLE_I1106:
                    setContentView(R.layout.activity_t_ad_interstitial_1106_layout);
                    break;
                case Constants.INTERSTITIAL_MATERIAL_STYLE_FA14:
                    setContentView(R.layout.activity_t_ad_interstitial_1104_1105_layout);
                    break;
                case Constants.INTERSTITIAL_MATERIAL_STYLE_I1107:
                    setContentView(R.layout.activity_t_ad_interstitial_1107_layout);
                    break;
                default:
                    finish();
                    AdLogUtil.Log().d(AdLogUtil.TAG, "TAdTemplateActivity --> 没有匹配到 materialStyle --> 配置错误 materialStyle=" + mAdBean.getMaterialStyle());
                    return;
            }
        } else {
            setContentView(R.layout.activity_t_ad_interstitial_adm_layout);
        }


        // 全屏显示 必须在setContentViw之后设置全屏。否则不会生效。
        getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
        //设置点击外部空白处可以关闭Activity true:可以关闭 false:不能关闭
        this.setFinishOnTouchOutside(false);

        // 初始化 通用控件
        initView();
        // 下载图片
        downloadImg();
        // 动态显示布局
        setServerDeliveryStyle();
    }

    @Override
    public void onBackPressed() {
        AdLogUtil.Log().d(AdLogUtil.TAG, "sendBroadcast(TAG_CLOSE);");
        sendBroadcast(Constants.ACTION_INTERSTITIAL_CLOSE, null);
        super.onBackPressed();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        MeasureSessionManager.getInstance().destroySession(mAdBean);
        if (ivImg != null) {
            if (ivImg.getDrawable() != null) {
                if (ivImg.getDrawable() instanceof BitmapDrawable) {
                    BitmapDrawable bd = (BitmapDrawable) ivImg.getDrawable();
                    if (bd != null) {
                        Bitmap bitmap = bd.getBitmap();
                        if (bitmap != null && !bitmap.isRecycled()) {
                            bitmap.recycle();
                        }
                    }
                    ivImg.setImageDrawable(null);
                } else if (ivImg.getDrawable() != null) {
                    ivImg.setImageDrawable(null);
                }
            }
        }
        if (llRoot != null){
            llRoot.removeAllViews();
        }
        if (webView != null){
            webView.clearHistory();
            webView.clearCache(true);
            webView.loadUrl("about:blank"); // clearView() should be changed to loadUrl("about:blank"), since clearView() is deprecated now
            webView.freeMemory();
            webView.destroy();
//            webView.pauseTimers(); 这个方法不仅仅针对当前的webview而是全局的全应用程序的webview，它会暂停所有webview的layout，parsing，javascripttimer。降低CPU功耗。
            webView = null; // Note that mWebView.destroy() and mWebView = null do the exact same thing
        }
    }

    @Override
    protected void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        if (null != outState) {
            outState.putString(Constants.INTERSTITIAL_APP_ID, SspAd.AppId);
        }
    }


    /**
     * 切换系统设置后，关闭广告，否则广告不可点击
     * @param newConfig
     */
    @Override
    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        finish();
    }

    @Override
    protected void onStart() {
        super.onStart();
        if (null != mAdBean){
            MeasureSession session = MeasureSessionManager.getInstance().getMeasureSession(mAdBean);
            session.setStop(false);
        }
    }

    /**
     * 两个生命周期方法 控制 曝光测绘的 开启暂停  先回调 Application.ActivityLifecycleCallbacks 在回调当前的
     */
    @Override
    protected void onStop() {
        super.onStop();
        if (null != mAdBean){
            MeasureSession session = MeasureSessionManager.getInstance().getMeasureSession(mAdBean);
            session.setStop(true);
        }
    }


    // =============================================================================================


    /**
     * 初始化 View
     */
    private void initView() {

        if (TextUtils.isEmpty(mAdBean.getAdm())){
            ivImg = findViewById(R.id.ivImg);
        }
        ivAdChoices = findViewById(R.id.ivAdChoices);
        llRoot = findViewById(R.id.llRoot);
        ivIcon = findViewById(R.id.ivIcon);
        tvName = findViewById(R.id.tvName);
        tvDescription = findViewById(R.id.tvDescription);
        tvBtn = findViewById(R.id.tvBtn);

        // 取消 点击事件
        findViewById(R.id.ivCancel).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                v.setTag(TAG_CLOSE);
                asyncAction(v);
                finish();
            }
        });

        // 内容布局 整体点击事件
        if (null != llRoot) {
            llRoot.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    asyncAction(v);
                }
            });
        }

        // 广告来源 点击事件
        ivAdChoices.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent showIntent = new Intent();
                sendBroadcast(Constants.ACTION_INTERSTITIAL_ADCHOICE_CLICK, showIntent);
                PlatformUtil.startPageByWebView(CoreUtil.getContext(), mAdBean);
            }
        });

        // 注册View的显示测量
        MeasureSession session = MeasureSessionManager.getInstance().getMeasureSession(mAdBean);
        if (TextUtils.isEmpty(mAdBean.getAdm())){
            //非adm广告类型
            session.registerView(ivImg, impressionListener);
        } else {
            session.registerView(llRoot, impressionListener);
        }

    }

    /**
     * 下载图片
     */
    private void downloadImg() {
        if (mAdBean == null){
            return;
        }
        if (TextUtils.isEmpty(mAdBean.getAdm())){
            // 下载主图片
            DownLoadRequest downLoadRequest = new DownLoadRequest()
                    .setPreCache(Constants.ImageLoadType.IMAGE_RAM_INCLUDED)
                    .setListener(new DrawableResponseListener() {
                        @Override
                        public void onRequestSuccess(int statusCode, byte[] data, AdImage adMedia) {
                            if (adMedia == null || adMedia.isAdImageRecycled()) {
                                onAdError(statusCode, "bitmap is null");
                                TAdInterstitialActivity.this.finish();
                                return;
                            }

                            if (null != ivImg) {
                                adMedia.attachView(ivImg);
                                // 点击事件
                                ivImg.setOnTouchListener(new TAdOnTouchListener());
                                ivImg.setOnClickListener(new View.OnClickListener() {
                                    @Override
                                    public void onClick(View v) {
                                        asyncAction(v);
                                    }
                                });
                            }

                        }

                        @Override
                        protected void onRequestError(TaErrorCode adError) {
                            if (null != adError) {
                                onAdError(adError.getErrorCode(), adError.getErrorMessage());
                            } else {
                                onAdError(1000, "adError.getErrorMessage()");
                            }
                            TAdInterstitialActivity.this.finish();
                        }

                    }).setUrl(mAdBean.getAdImgUrl()).setAdsDTO(mAdBean, AthenaTracker.M_TYPE_LARGE_IMG);
            AdLogUtil.Log().d(AdLogUtil.TAG, "use image to show ad adm is:= " + mAdBean.getAdImgUrl());
            downLoadRequest.netRequestPreExecute();
        } else {
            //adm不为空展示adm广告
            attachAdmView();
        }


        //广告来源
        ImageDownloadHelper.loadImageView(mAdBean.getAdChoiceImageUrl(),
                ivAdChoices, mAdBean, AthenaTracker.M_TYPE_AD_CHOICE_VIEW, null);

        // 下载icon
        if (null != ivIcon && null != mAdBean.getNativeObject()) {
            ImageDownloadHelper.loadImageView(mAdBean.getNativeObject().getLogoUrl(),
                    ivIcon, mAdBean, AthenaTracker.M_TYPE_LOGO, null);
        }
    }

    private void attachAdmView(){
        AdLogUtil.Log().d(AdLogUtil.TAG,"TAdInterstitialActivity attachAdmView");
        if (webView !=null && llRoot!=null){
            List<String> scales = mAdBean.getScales();
            llRoot.removeAllViews();
            llRoot.addView(webView, ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
            ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams) llRoot.getLayoutParams();
            if (null != scales && scales.size() > 0) {
                /*代码位比例  //例子 ["16:9","3:2"]
                        (开屏、插屏、banner 只有一个比例)
                (native 可以有多个比例）*/
                //设置容器比例
                layoutParams.dimensionRatio = scales.get(0);
            } else {
                AdLogUtil.Log().e(AdLogUtil.TAG, "TAdInterstitialActivity attachAdmView scale is empty,finish");
                finish();
            }
            gestureDetector = new ViewGestureDetector(getApplicationContext());
            webView.setOnTouchListener(new TAdOnTouchListener());
            webView.setWebViewClient(new WebViewClient(){
                @Override
                public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                    if (gestureDetector.isClicked()){
                        gestureDetector.setClicked(false);
                        Uri uri = request.getUrl();
                        if (uri != null){
                            mAdBean.setClickUrl(uri.toString());
                            asyncAction(llRoot);
                            AdLogUtil.Log().d(AdLogUtil.TAG,"TAdInterstitialActivity shouldOverrideUrlLoading uri "+uri);
                        }
                        return true;
                    }
                    return super.shouldOverrideUrlLoading(view,request);
                }
            });
        }
    }

    /**
     * 服务器动态下发广告样式
     */
    private void setServerDeliveryStyle() {
        // I1107 不需要做任何操作的
        if (null == mAdBean || null == mAdBean.getNativeObject()) {
            return;
        }

        // 布局内容填充
        switch (mAdBean.getMaterialStyle()) {
            case Constants.INTERSTITIAL_MATERIAL_STYLE_I1101:
            case Constants.INTERSTITIAL_MATERIAL_STYLE_I1103:
                tvName.setText(mAdBean.getNativeObject().getTitleTxt());
                tvDescription.setText(mAdBean.getNativeObject().getDescriptionTxt());
                tvBtn.setText(mAdBean.getNativeObject().getButtonTxt(mAdBean.getInstallApk()));
                // 字重
                TextPaint tp1 = tvName.getPaint();
                tp1.setStrokeWidth(2.0f);
                tp1.setStyle(Paint.Style.FILL_AND_STROKE);
                break;

            case Constants.INTERSTITIAL_MATERIAL_STYLE_I1106:
            case Constants.INTERSTITIAL_MATERIAL_STYLE_FA14:
                tvName.setText(mAdBean.getNativeObject().getTitleTxt());
                tvDescription.setText(mAdBean.getNativeObject().getDescriptionTxt());
                tvBtn.setText(mAdBean.getNativeObject().getButtonTxt(mAdBean.getInstallApk()));
                // 字重
                TextPaint tp2 = tvDescription.getPaint();
                tp2.setStrokeWidth(2.0f);
                tp2.setStyle(Paint.Style.FILL_AND_STROKE);
                break;

            case Constants.INTERSTITIAL_MATERIAL_STYLE_I1102:
                tvName.setText(mAdBean.getNativeObject().getTitleTxt());
                tvBtn.setText(mAdBean.getNativeObject().getButtonTxt(mAdBean.getInstallApk()));
                TextPaint tp = tvName.getPaint();
                tp.setStrokeWidth(2.0f);
                tp.setStyle(Paint.Style.FILL_AND_STROKE);
                break;
        }

    }


    // =============================================================================================


    /**
     * 曝光测量 监听器
     */
    private MeasureSession.AdImpressionListener impressionListener = new AdImpressionListenerImpl()  {
        @Override
        public void onViewImpressed(AdsDTO adsDTO) {
            super.onViewImpressed(adsDTO);
            AdLogUtil.Log().d(AdLogUtil.TAG, "view has impression");
            AdLogUtil.Log().d(AdLogUtil.TAG, "track = onAdShow");
            Intent showIntent = new Intent();
            sendBroadcast(Constants.ACTION_INTERSTITIAL_SHOW, showIntent);
        }
    };

    /**
     * 主要是为了获取触摸点 数据
     */
    private class TAdOnTouchListener implements View.OnTouchListener {

        @Override
        public boolean onTouch(View v, MotionEvent event) {
            if (gestureDetector != null) {
                // gestureDetector不为空说明是adm广告类型，adm广告类型添加手势识别
                gestureDetector.onTouchEvent(event);
            }
            switch (event.getAction()) {
                case MotionEvent.ACTION_DOWN:
                    downX = event.getX();
                    downY = event.getY();
                    break;

                case MotionEvent.ACTION_UP:
                    upX = event.getX();
                    upY = event.getY();
                    break;
            }
            return false;
        }
    }

    /**
     * view分别有两种，一种渲染广告的view，一种是关闭按钮
     * view.getTag()用来区别点击的view属于哪一种view，响应不同行为
     * ad_close view 关闭广告，点击日志上报
     * ad view 响应点击，跳转着陆页或者deeplink，点击日志上报
     * 2秒内发生的重复点击不做处理，避免点击响应问题
     *
     * @param view 发生点击事件的view
     * @author 韦明微
     * @time 2017/4/10 17:02
     */
    private void asyncAction(View view) {
        try {
            AdLogUtil.Log().d(AdLogUtil.TAG, "asyncAction");
            long currentTime = System.currentTimeMillis();
            if (currentTime - oldTime > 2 * 1000) {
                if (view.getTag() instanceof String && TAG_CLOSE.equals(view.getTag())) {
                    sendBroadcast(Constants.ACTION_INTERSTITIAL_CLOSE, null);
                    if (!isFinishing()) {
                        finish();
                    }
                } else {
                    Intent intent = new Intent();
                    // 点击的坐标点
                    intent.putExtra("pointBean", new DownUpPointBean(downX, downY, upX, upY,
                            view.getMeasuredHeight(), view.getMeasuredWidth()));
                    intent.putExtra("mAdBean", mAdBean);
                    sendBroadcast(Constants.ACTION_INTERSTITIAL_CLICK, intent);
                }
                oldTime = currentTime;
            }
        } catch (Throwable e) {
            AdLogUtil.Log().e(Log.getStackTraceString(e));
        }
    }

    /**
     * 发送广播
     *
     * @param action
     * @param intent
     */
    private void sendBroadcast(String action, Intent intent) {
        if (intent == null) {
            intent = new Intent();
        }
        intent.setAction(broadCastPrefix + action);
        AdLogUtil.Log().d(AdLogUtil.TAG, "sendBroadcast action: " + intent.getAction());
        sendBroadcast(intent);
    }

    /**
     * 如果错误就发送错误回调
     *
     * @param errorCode
     * @param msg
     */
    private void onAdError(int errorCode, String msg) {
        Intent errorIntent = new Intent();
        errorIntent.putExtra(ERROR_MSG, msg);
        errorIntent.putExtra(ERROR_CODE, errorCode);
        sendBroadcast(Constants.ACTION_INTERSTITIAL_ERROR, errorIntent);
    }

}
