package com.cloud.hisavana.sdk.common.http;

import static com.cloud.hisavana.sdk.common.util.AdLogUtil.TAG;

import android.text.TextUtils;
import android.util.Log;

import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.http.listener.DrawableResponseListener;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.transsion.core.CoreUtil;
import com.transsion.http.HttpClient;
import com.transsion.http.ImageURL;
import com.transsion.http.RequestCall;
import com.transsion.http.cache.IDiskCache;
import com.transsion.http.impl.HttpCallbackImpl;

import java.io.File;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;


/**
 * Created by peng.sun on 2017/6/19.
 */

public class DownLoadRequest extends RequestBase<DrawableResponseListener> {

    boolean isSuccess = false;

    /***资源大小*/
    long fileSize = 0L;
    /***cdn 请求头获取*/
    String cdn = "";
    /***请求开始时间*/
    long startTime = 0L;
    /***网路请求错误代码*/
    int errorCode = -1;
    /***当前下载方式*/
    int downloadWay = AthenaTracker.DOWNLOAD_WAY_HTTP_URL_CONNECTION;

    /*** 用于埋点*/
    private AdsDTO adsDTO;
    //  物料类型 1=logo 2=大图 int
    private int mType;
    /***1. 从网络获取；2. 从本地缓存获取*/
    private int requestType = 1;

    public DownLoadRequest setAdsDTO(AdsDTO ads,int type){
        this.adsDTO=ads;
        this.mType=type;
        return this;
    }

    private String url = "";
    private int isPreCache = Constants.ImageLoadType.IMAGE_RAM_INCLUDED;

    public DownLoadRequest setUrl(String url) {
        this.url = url;
        return this;
    }

    public DownLoadRequest setListener(DrawableResponseListener listener) {
        this.mListener = listener;
        return this;
    }

    public DownLoadRequest setPreCache(int preCache) {
        this.isPreCache = preCache;
        return this;
    }

    /**
     * 前期执行检查网络
     */
    @Override
    public void netRequestPreExecute() {
//        20211014 1.0版本暂时去除
//        if (ADOkHttpClient.getInstance().getOkHttpClient() != null) {
//            AdLogUtil.Log().d(AdLogUtil.TAG,IMG_TAG,"媒体使用了 Okhttp");
//            try {
//                switchOkhttp();
//            }catch (Exception e){
//                AdLogUtil.Log().d(AdLogUtil.TAG,IMG_TAG,"媒体使用 Okhttp 异常 " + e.getMessage());
//                mListener.onServerRequestFailure(new TaErrorCode(0, "Okhttp - " + e.getMessage()));
//            }
//            return;
//        }
//
//        AdLogUtil.Log().d(IMG_TAG,"媒体没有使用 Okhttp 正常走流程 ");

        /**
         * 分发网络请求
         */
//        AdLogUtil.Log().d(TAG, "netRequestPreExecute");
        if (TextUtils.isEmpty(url)) {
            AdLogUtil.Log().e(TAG, "url is empty");
            return;
        }
        netRequestPosExecute();
    }

    @Override
    protected void netRequestPosExecute() {
        try {

            RequestCall requestCall = HttpClient.image(CoreUtil.getContext())
                    .log(false)
                    .cache(true)
                    .connectTimeout(TIMEOUT_IN_MILLIONS)
                    .readTimeout(20 * 1000)
                    .url(url)
                    .build();

            IDiskCache iDiskCache = requestCall.getDiskCache();
            File file  = iDiskCache.get(new ImageURL(url));
            boolean isCache = (file != null && file.exists());

            // 用于计算网络请求耗时
            startTime = System.currentTimeMillis();

            // 不是缓存才上报
            if (!isCache){
                downloadTrack(AthenaTracker.M_STATUS_STAR);
                requestType = 1;
            }else{
                requestType = 2;
            }

            requestCall.execute(new HttpCallbackImpl(true) {
                        @Override
                        public void onSuccess(int statusCode, byte[] data) {
                            AdLogUtil.Log().d(TAG, "onSuccess statusCode " + statusCode +" url "+url);
                            if (mListener != null && mListener instanceof DrawableResponseListener) {
                                mListener.onServerRequestSuccess(isPreCache, statusCode, data, null);
                            }
                            isSuccess = true;
                            if (null != data){
                                fileSize = data.length;
                            }
                        }

                        @Override
                        public void onResponseHeader(Map<String, List<String>> map) {
                            super.onResponseHeader(map);
                            // 如果是客户端读取的应该是x-response-cdn
                            // 如果是服务端应该是拿x-request-cdn
                            if (isSuccess){
                                isSuccess = false;
                                if (null != map && !map.isEmpty()){
                                    List<String> strings = map.get("x-response-cdn");
                                    if (null != strings && !strings.isEmpty()){
                                        cdn = strings.get(0);
                                    }
                                }
                                downloadTrack(AthenaTracker.M_STATUS_SUCCESS);
                            }
                        }

                        @Override
                        public void onFailure(int statusCode, byte[] bytes, Throwable throwable) {
                            AdLogUtil.Log().d(TAG, "onFailure statusCode " + statusCode + " e" + throwable+" url "+url);
                            if (mListener != null) {
                                mListener.onServerRequestFailure(statusCode, bytes, throwable);
                            }
                            errorCode = statusCode;
                            downloadTrack(AthenaTracker.M_STATUS_ERROR);
                        }

                        @Override
                        public void onSuccess(int statusCode, byte[] responseBody, final String filePath) {
                            AdLogUtil.Log().d(TAG, "onSuccess statusCode " + statusCode + " filePath " + filePath+" url"+url);
                            if (mListener != null && mListener instanceof DrawableResponseListener) {
                                mListener.onServerRequestSuccess(isPreCache, statusCode, responseBody, filePath);
                            }
                            isSuccess = true;
                            if (null !=responseBody){
                                fileSize = responseBody.length;
                            }
                        }
                    });
        } catch (Throwable e) {
            AdLogUtil.Log().e(Log.getStackTraceString(e));
            // 上报下载失败
            errorCode = Constants.DOWNLOAD_IMG_ERROR_CATCH_CODE;
            downloadTrack(AthenaTracker.M_STATUS_ERROR);
        }
    }


    // =============================================================================================


    /**
     * 开始下载 下载成功 下载失败 日志上报
     *  info 广告详情
     *  requestType 请求方式 1. 从网络获取；2. 从本地缓存获取
     *  downloadWay 下载方式 1.HttpUrlConnection 2.Okhttp  int
     *  mStatus     下载状态 1.开始下载 2.下载成功 3.下载失败
     *  errorCode   错误信息
     *  mType       资源类型
     *  cdn         资源来源
     *  timeConsuming 耗时
     *  fileSize   文件大小
     */
    private void downloadTrack(int mStatus){

        AthenaTracker.trackImageDownload(adsDTO,
                requestType,
                downloadWay,
                mStatus,
                errorCode,
                mType,
                cdn,
                System.currentTimeMillis()-startTime,
                getSize(fileSize));
    }

    /**
     * file_size 单位转换成 KB 上传
     *
     * @param byteSize byte size
     * @return
     */
    public static int getSize(long byteSize) {
        int size = 0;
        try{
            BigDecimal sizeNew = new BigDecimal(byteSize);
             size = sizeNew.divide(BigDecimal.valueOf(1024),0,BigDecimal.ROUND_HALF_UP).intValue();
        }catch (Exception e){
            AdLogUtil.Log().d(TAG,Log.getStackTraceString(e));
        }
        return size;
    }


}
