package com.cloud.hisavana.sdk.data.bean.response;


import com.cloud.hisavana.sdk.common.bean.AdImage;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 *
 * @author: wenjing.luo
 * @date: 2022/03/28
 *
 * ps素材返回数据bean
 */
public class AdPsResponseBody {

    private int code;
    private String message;
    private DataDTO data;

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public DataDTO getData() {
        return data;
    }

    public void setData(DataDTO data) {
        this.data = data;
    }

    public class DataDTO implements Serializable {

        private List<String> gpLinkList;
        private List<PsLinkListDTO> psLinkList;

        public List<String> getGpLinkList() {
            return gpLinkList;
        }

        public void setGpLinkList(List<String> gpLinkList) {
            this.gpLinkList = gpLinkList;
        }

        public List<PsLinkListDTO> getPsLinkList() {
            return psLinkList;
        }

        public void setPsLinkList(List<PsLinkListDTO> psLinkList) {
            this.psLinkList = psLinkList;
        }
    }

    public class PsLinkListDTO implements Serializable{
        private String icon;
        private String appName;
        private String star;
        private long size;
        private String dpLink;
        private AdImage image;

        public String getIcon() {
            return icon;
        }

        public void setIcon(String icon) {
            this.icon = icon;
        }

        public String getAppName() {
            return appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public String getStar() {
            return star;
        }

        public void setStar(String star) {
            this.star = star;
        }

        public String getSize() {
            BigDecimal size_new = new BigDecimal(size);
            size_new = size_new.divide(BigDecimal.valueOf(1024 * 1024),1,BigDecimal.ROUND_HALF_UP);
            return size_new + "MB";
        }

        public void setSize(long size) {
            this.size = size;
        }

        public String getDpLink() {
            return dpLink;
        }

        public void setDpLink(String dpLink) {
            this.dpLink = dpLink;
        }
    }

}

