package com.cloud.hisavana.sdk.data.bean.response;

import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.ps.PsRequestManager;
import com.cloud.hisavana.sdk.data.bean.request.AdxImpBean;

import java.util.List;

/**
 * @author: wenjing.luo
 * @date: 2022/3/20
 * 自定义的广告数据bean
 */
public class AdsDTO extends TAdsDTO{
    private AdxImpBean impBeanRequest;
    private Long fill_ts;//刚请求回数据的时间
    private String uuid;//在native广告中用到
    //广告过期时间配置 (分钟)
    private Integer splashCountTime = 4; // 倒计时 5S 第4 秒开始才可以点击跳转
    private Boolean isACReady;//adchoice是否预加载成功
    //图片是否下载成功
    private Boolean imageIsDownload;
    //取打底广告时用到，取未曝光过的打底广告，如果都被曝光过，则全置为false，从第一个开始取
    private Boolean isExpiration;

    //1.3.0新增
    private String deepLinkUrlFirst; //deepLinkUrl中的第一个可拉起的应用深链接地址
    private Long actualShowTime;//广告素材实际曝光时间
    private Integer actualShowRate = 0;//广告素材实际曝光比例
    private String showArea = "0*0";//广告素材曝光面积，宽*高

    private Integer isEffectiveShow;//是否有效曝光 1/0 1=有效 0=无效
    private Integer isDefaultAdFirstShow = 0;//是否初次曝光（仅在打底广告时记录）   1=是 0=否 int
    private Integer showReportTimeType;//展现上报时机类型 1. 展现时上报 2. 达标时上报 3. 离开时上报
    //1.4.0新增
    //pslink下载情况
    private Integer adPsType = Constants.AD_PS_TYPE.NO_PS_AD;
    //被调起的url类型
    private int calledUrlType = Constants.CALLED_URL_TYPE.CLICKURLS;
    //pslink的name
    private String pslinkAppName;
    //宏替换的clickid
    private String clickid;
    //请求ps素材的时间
    private long requestPsTs;
    //返回ps素材的时间
    private long returnPsTs;
    //曝光串
    private String impressionUrl;
    //落地页点击时间
    private long clickUrlTs;

    private PsRequestManager psRequestManager;

    public PsRequestManager getPsRequestManager() {
        return psRequestManager;
    }

    public void setPsRequestManager(PsRequestManager psRequestManager) {
        this.psRequestManager = psRequestManager;
    }

    public long getClickUrlTs() {
        return clickUrlTs;
    }

    public void setClickUrlTs(long clickUrlTs) {
        this.clickUrlTs = clickUrlTs;
    }

    public int getRequestType() {
        if (impBeanRequest != null){
            return impBeanRequest.requestType;
        }
        return -1;
    }

    public String getDeepLinkUrlFirst() {
        return deepLinkUrlFirst == null ? "" : deepLinkUrlFirst;
    }

    public void setDeepLinkUrlFirst(String deepLinkUrlFirst) {
        this.deepLinkUrlFirst = deepLinkUrlFirst;
    }

    public String getImpressionUrl() {
        return impressionUrl;
    }

    public void setImpressionUrl(String impressionUrl) {
        this.impressionUrl = impressionUrl;
    }

    public long getRequestPsTs() {
        return requestPsTs;
    }

    public void setRequestPsTs(long requestPsTs) {
        this.requestPsTs = requestPsTs;
    }

    public long getReturnPsTs() {
        return returnPsTs;
    }

    public void setReturnPsTs(long returnPsTs) {
        this.returnPsTs = returnPsTs;
    }

    public String getClickid() {
        return clickid;
    }

    public void setClickid(String clickid) {
        this.clickid = clickid;
    }

    public Integer getAdPsType() {
        return adPsType;
    }

    public void setAdPsType(Integer adPsType) {
        this.adPsType = adPsType;
    }

    public int getCalledUrlType() {
        return calledUrlType;
    }

    public void setCalledUrlType(int calledUrlType) {
        this.calledUrlType = calledUrlType;
    }

    public String getPslinkAppName() {
        return pslinkAppName;
    }

    public void setPslinkAppName(String pslinkAppName) {
        this.pslinkAppName = pslinkAppName;
    }

    public AdxImpBean getImpBeanRequest() {
        return impBeanRequest;
    }

    public void setImpBeanRequest(AdxImpBean impBeanRequest) {
        this.impBeanRequest = impBeanRequest;
    }

    public String getCodeSeatId() {
        if (impBeanRequest != null){
            return impBeanRequest.pmid;
        }
        return "";
    }

    public Integer getCodeSeatType() {
        if (impBeanRequest != null){
            return impBeanRequest.adt;
        }
        return -1;
    }

    public Integer getIsDefaultAd() {
        if (impBeanRequest != null){
            return impBeanRequest.defaultAd ? 1 : 0;
        }
        return 0;
    }

    public String getRid() {
        if (impBeanRequest != null){
            return impBeanRequest.requestId;
        }
        return "";
    }

    public Long getFill_ts() {
        return fill_ts == null ? 0 : fill_ts;
    }

    public Integer getSplashCountTime() {
        return splashCountTime == null ? 0 : splashCountTime;
    }

    public Boolean getACReady() {
        return isACReady == null ? false : isACReady;
    }

    public Boolean getImageIsDownload() {
        return imageIsDownload == null ? false : imageIsDownload;
    }

    public Boolean getExpiration() {
        return isExpiration == null ? false : isExpiration;
    }

    public Integer getActualShowRate() {
        return actualShowRate == null ? 0 : actualShowRate;
    }

    public Long getActualShowTime() {
        return actualShowTime == null ? 0L : actualShowTime;
    }

    public Integer getIsEffectiveShow() {
        return isEffectiveShow == null ? 0 : isEffectiveShow;
    }

    public Integer getIsDefaultAdFirstShow() {
        return isDefaultAdFirstShow == null ? 0 : isDefaultAdFirstShow;
    }

    public String getUuid() {
        return null == uuid ? "" : uuid;
    }

    public Integer getShowReportTimeType() {
        return showReportTimeType;
    }

    public void setShowReportTimeType(Integer showReportTimeType) {
        this.showReportTimeType = showReportTimeType;
    }

    public String getShowArea() {
        return showArea;
    }

    public void setShowArea(String showArea) {
        this.showArea = showArea;
    }

    public void setFill_ts(Long fill_ts) {
        this.fill_ts = fill_ts;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setSplashCountTime(Integer splashCountTime) {
        this.splashCountTime = splashCountTime;
    }

    public void setACReady(Boolean ACReady) {
        isACReady = ACReady;
    }

    public void setImageIsDownload(Boolean imageIsDownload) {
        this.imageIsDownload = imageIsDownload;
    }

    public void setExpiration(Boolean expiration) {
        isExpiration = expiration;
    }

    public void setActualShowRate(Integer actualShowRate) {
        this.actualShowRate = actualShowRate;
    }

    public void setActualShowTime(Long actualShowTime) {
        this.actualShowTime = actualShowTime;
    }

    public void setIsEffectiveShow(Integer isEffectiveShow) {
        this.isEffectiveShow = isEffectiveShow;
    }

    public void setIsDefaultAdFirstShow(Integer isDefaultAdFirstShow) {
        this.isDefaultAdFirstShow = isDefaultAdFirstShow;
    }

    @Override
    public String toString() {
        return "AdsDTO{" +
                "id=" + id +
                ", advertiserId=" + advertiserId +
                ", planId=" + planId +
                ", adGroupId=" + adGroupId +
                ", adCreativeId=" + adCreativeId +
                ", packageName='" + packageName + '\'' +
                ", clickUrl='" + clickUrl + '\'' +
                ", showTrackingUrls=" + showTrackingUrls +
                ", showTrackingSecretKey='" + showTrackingSecretKey + '\'' +
                ", clickTrackingUrls=" + clickTrackingUrls +
                ", adChoiceImageUrl='" + adChoiceImageUrl + '\'' +
                ", adChoiceClickUrl='" + adChoiceClickUrl + '\'' +
                ", adChoiceLegalText='" + adChoiceLegalText + '\'' +
                ", defaultAdExpirationTime='" + defaultAdExpirationTime + '\'' +
                ", defaultAdShowCount=" + defaultAdShowCount +
                ", nativeObject=" + nativeObject +
                ", extInfo='" + extInfo + '\'' +
                ", materialStyle='" + materialStyle + '\'' +
                ", abTest=" + abTest +
                ", cacheTime=" + cacheTime +
                ", fill_ts=" + fill_ts +
                ", uuid='" + uuid + '\'' +
                ", splashCountTime=" + splashCountTime +
                ", isACReady=" + isACReady +
                ", imageIsDownload=" + imageIsDownload +
                ", isExpiration=" + isExpiration +
                ", actualShowRate=" + actualShowRate +
                ", isEffectiveShow=" + isEffectiveShow +
                ", isDefaultAdFirstShow=" + isDefaultAdFirstShow +
                ", adm=" + adm +
                ", scales "+scales+
                '}';
    }
}
