/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.http;

import android.text.TextUtils;
import android.util.Log;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.RequestBase;
import com.cloud.hisavana.sdk.common.http.listener.CommonResponseListener;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.config.AdxServerConfig;
import com.cloud.hisavana.sdk.data.bean.request.AdxImpBean;
import com.cloud.hisavana.sdk.data.control.AdxPreferencesHelper;
import com.cloud.hisavana.sdk.sign.c;
import com.transsion.core.pool.TranssionPoolManager;
import com.transsion.http.HttpClient;
import com.transsion.http.builder.PostJsonBuilder;
import com.transsion.http.impl.IHttpCallback;
import com.transsion.http.impl.StringCallback;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;

public class AdServerRequest
extends RequestBase<CommonResponseListener> {
    private String mPlacementid = "0";
    private String mUrl = "";
    private boolean mIsDebug = false;
    private SSLSocketFactory mSSLSocketFactory = null;
    private IAdPostBody mPostBody = null;
    private static String lastCloudCtrlVersion = null;
    private static boolean ctrlVersionChanged = false;
    private AdxImpBean adxImpBean;

    public AdServerRequest setAdxImpBean(AdxImpBean adxImpBean) {
        this.adxImpBean = adxImpBean;
        return this;
    }

    public AdServerRequest setPostBody(IAdPostBody postBody) {
        this.mPostBody = postBody;
        return this;
    }

    public AdServerRequest setListener(CommonResponseListener listener) {
        this.mListener = listener;
        return this;
    }

    public AdServerRequest setUrl(String url) {
        this.mUrl = url;
        return this;
    }

    public AdServerRequest setDebug(boolean isDebug) {
        this.mIsDebug = isDebug;
        return this;
    }

    public AdServerRequest setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.mSSLSocketFactory = sslSocketFactory;
        return this;
    }

    public AdServerRequest setPlacementId(String pid) {
        this.mPlacementid = pid;
        return this;
    }

    @Override
    protected void netRequestPosExecute() {
        TranssionPoolManager.getInstance().addTask(new Runnable(){

            @Override
            public void run() {
                AdServerRequest.this.sendRequestToServer();
            }
        });
    }

    private void sendRequestToServer() {
        block7: {
            String postBodyString = this.mPostBody.getPostBody();
            if (TextUtils.isEmpty((CharSequence)postBodyString)) {
                if (this.mListener != null) {
                    ((CommonResponseListener)this.mListener).onServerRequestFailure(-1, "TextUtils.isEmpty(postBodyString) == true ", null);
                }
                AdLogUtil.netLog("sendRequestToServer() --> TextUtils.isEmpty(postBodyString) == true ");
            }
            if (this.adxImpBean != null) {
                this.adxImpBean.requestTs = System.currentTimeMillis();
                AthenaTracker.trackSspRequest(this.adxImpBean);
            }
            try {
                AdLogUtil.netLog("full url:=" + this.mUrl);
                AdLogUtil.netLog("postBodyString == ");
                AdLogUtil.netLog(postBodyString.trim());
                String cloudControlVersion = AdxPreferencesHelper.getInstance().getString("cloudControlVersion", null);
                if (!TextUtils.isEmpty((CharSequence)this.mUrl)) {
                    if (this.mListener != null) {
                        ((CommonResponseListener)this.mListener).onServerRequestStart(1);
                    }
                    c.a(AdxServerConfig.getAppModle() != 0);
                    String signStr = c.a("post", "", "application/json", this.mUrl, postBodyString);
                    ((PostJsonBuilder)((PostJsonBuilder)((PostJsonBuilder)((PostJsonBuilder)((PostJsonBuilder)((PostJsonBuilder)((PostJsonBuilder)((PostJsonBuilder)HttpClient.postJson().log(this.mIsDebug)).sslSocketFactory(this.mSSLSocketFactory)).content(postBodyString).connectTimeout(15000)).readTimeout(15000)).addHeader("x-tr-signature", signStr)).addHeader("cloudControlVersion", cloudControlVersion)).url(this.mUrl)).addHeader("Accept-Timezone", "UTC")).build().execute((IHttpCallback)new StringCallback(true){

                        public void onSuccess(int statusCode, String response) {
                            AdLogUtil.netLog("*----> status code:=" + statusCode + "  mUrl =" + AdServerRequest.this.mUrl + "  response = ");
                            AdLogUtil.netLog(response);
                            if (!TextUtils.isEmpty((CharSequence)response)) {
                                if (AdServerRequest.this.mListener != null) {
                                    ((CommonResponseListener)AdServerRequest.this.mListener).onServerRequestSuccess(statusCode, response);
                                }
                            } else {
                                if (AdServerRequest.this.mListener != null) {
                                    ((CommonResponseListener)AdServerRequest.this.mListener).onServerRequestFailure(TaErrorCode.HTTP_RESPONSE_ERROR.getErrorCode(), TaErrorCode.HTTP_RESPONSE_ERROR.getErrorMessage(), null);
                                }
                                AdLogUtil.netLog("TextUtils.isEmpty(response) == true ,  response is null ");
                            }
                        }

                        public void onResponseHeader(Map<String, List<String>> map) {
                            String ctrlVersion;
                            List<String> list;
                            if (map != null && (list = map.get("cloudControlVersion")) != null && list.size() > 0 && !TextUtils.isEmpty((CharSequence)(ctrlVersion = list.get(0))) && !ctrlVersion.equals(lastCloudCtrlVersion)) {
                                lastCloudCtrlVersion = ctrlVersion;
                                ctrlVersionChanged = true;
                                AdLogUtil.netLog("get new cloud control version from header,version: " + ctrlVersion);
                                AdxPreferencesHelper.getInstance().putString("new_config_ver", ctrlVersion);
                            }
                        }

                        public void onFailure(int statusCode, String response, Throwable throwable) {
                            boolean isNeedRetry = c.a(statusCode, response);
                            if (isNeedRetry) {
                                AdServerRequest.this.sendRequestToServer();
                                return;
                            }
                            if (null != throwable) {
                                AdLogUtil.netLog("error statusCode:=" + statusCode + " ,reponse: = " + response + ",error message = " + throwable.getMessage());
                            }
                            if (AdServerRequest.this.mListener != null) {
                                ((CommonResponseListener)AdServerRequest.this.mListener).onServerRequestFailure(statusCode, response, throwable);
                            }
                        }
                    });
                }
            }
            catch (Throwable e2) {
                AdLogUtil.netLog(Log.getStackTraceString((Throwable)e2));
                if (this.mListener == null) break block7;
                ((CommonResponseListener)this.mListener).onServerRequestFailure(new TaErrorCode(10000, e2.getMessage()));
            }
        }
    }

    public static interface IAdPostBody {
        public String getPostBody();
    }
}

