package com.cloud.hisavana.sdk.api.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;

import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.bean.AdImage;
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.DownLoadRequest;
import com.cloud.hisavana.sdk.common.http.listener.DrawableResponseListener;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.transsion.core.utils.ScreenUtil;

/**
 * @author Connor Lin
 * @date 2020/4/20
 */
public class SspNativeView extends FrameLayout {

    private MediaView mediaView;
    private View iconView;
    private AAdChoicesView adChoicesView;
    private ImageView.ScaleType scaleType = null;
    private DownLoadRequest downLoadMedia;

    public SspNativeView(@NonNull Context context) {
        this(context, null);
    }

    public SspNativeView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SspNativeView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setMediaView(MediaView mediaView) {
        setMediaView(mediaView, null);
    }

    public void setMediaView(MediaView mediaView, ImageView.ScaleType scaleType) {
        this.mediaView = mediaView;
        this.scaleType = scaleType;
    }

    public final void setIconView(View view) {
        this.iconView = view;
    }

    public final void setupViews(TaNativeInfo adInfo, AAdChoicesView adChoicesView) {
        this.adChoicesView = adChoicesView;
//        setMediaView(adInfo);
//        setIconView(adInfo);
//        setAdChoice(adInfo);
    }

    private void setMediaView(TaNativeInfo adInfo) {
        if (mediaView == null || adInfo == null) {
            return;
        }

        final AdImage image = adInfo.getImage();
        if (image != null) {
            mediaView.init(image.getMime());
            if (!image.isAdImageRecycled()) {
                mediaView.setMediaView(image, scaleType == null ? ImageView.ScaleType.CENTER_CROP : scaleType);
            } else if (!TextUtils.isEmpty(image.getImgUrl())) {
                downLoadMedia = new DownLoadRequest().setListener(new DrawableResponseListener() {
                    @Override
                    public void onRequestSuccess(int statusCode, byte[] data,  AdImage adImage) {
                        if (adImage != null && adImage.getDrawable() != null) {
                            AdLogUtil.Log().d(AdLogUtil.TAG,"download Image Success.");
                            mediaView.setMediaView(adImage, scaleType == null ? ImageView.ScaleType.FIT_CENTER : scaleType);
                        }
                    }

                    @Override
                    protected void onRequestError(TaErrorCode adError) {
                        AdLogUtil.Log().d(AdLogUtil.TAG,"download Image failed.");
                    }

                }).setUrl(image.getImgUrl()).setAdsDTO(image.adsDTO, AthenaTracker.M_TYPE_LARGE_IMG);
                downLoadMedia.netRequestPreExecute();
            }
        }
    }

    private void setIconView(TaNativeInfo adInfo) {

        if (iconView == null || adInfo == null) {
            return;
        }

        final AdImage icon = adInfo.getIconImage();
        if (icon != null) {
            if (!icon.isAdImageRecycled()) {
                ((ImageView) iconView).setImageDrawable(icon.getDrawable());
            } else if (!TextUtils.isEmpty(icon.getImgUrl())) {
                DownLoadRequest downLoadRequest_ = new DownLoadRequest().setListener(new DrawableResponseListener() {
                    @Override
                    public void onRequestSuccess(int statusCode, byte[] data,  AdImage adImage) {
                        if (adImage != null && adImage.getDrawable() != null) {
                            AdLogUtil.Log().d(AdLogUtil.TAG,"download Image Success.");
                            ((ImageView) iconView).setImageDrawable(adImage.getDrawable());
                        }
                    }

                    @Override
                    protected void onRequestError(TaErrorCode adError) {
                        AdLogUtil.Log().d(AdLogUtil.TAG,"download Image failed.");
                    }
                }).setUrl(icon.getImgUrl()).setAdsDTO(icon.adsDTO, AthenaTracker.M_TYPE_LOGO);
                downLoadRequest_.netRequestPreExecute();
            }
        }
    }

    private void setAdChoice(TaNativeInfo adInfo) {
        if (adInfo == null) {
            return;
        }
        if (adChoicesView != null && mediaView.indexOfChild(adChoicesView) < 0) {
            ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(
                    ScreenUtil.dip2px(Constants.adChoiceViewSize), ScreenUtil.dip2px(Constants.adChoiceViewSize));
            //mediaView.addView(adChoicesView,params);
        }
    }

    public void destroy() {

        if (downLoadMedia != null) {
            downLoadMedia.cancelRequest();
        }

        if (mediaView != null) {
            mediaView.destroy();
        }
        removeAllViews();
    }

    public MediaView getMediaView() {
        return mediaView;
    }
}
