package com.cloud.hisavana.sdk.common.activity;
/* Top Secret */

import static com.cloud.hisavana.sdk.common.util.AdLogUtil.TRACK_TAG;
import static com.transsion.core.CoreUtil.getContext;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.webkit.ConsoleMessage;
import android.webkit.JavascriptInterface;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;


import com.cloud.hisavana.sdk.BuildConfig;
import com.cloud.hisavana.sdk.R;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.hisavana.sdk.common.tracking.TrackingManager;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.widget.webview.WebViewDataTracker;
import com.cloud.hisavana.sdk.common.widget.webview.WebViewManager;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.tmc.vuid.VUID;
import com.cloud.tmc.vuid.listener.ActionJsHelper;
import com.cloud.tmc.vuid.listener.INotifyTokenRefresh;
import com.cloud.tmc.vuid.util.ClipboardUtils;
import com.cloud.tmc.vuid.util.MixUtilsKt;
import com.cloud.tmc.vuid.util.StatusBarUtil;
import com.cloud.tmc.vuid.util.ThreadUtils;
import com.tmc.webview.ActionWebView;
import com.tmc.webview.ActionWebViewClient;

import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

/**
 * usage
 *
 * @author peng.sun
 * @data 2018/08/16
 * ========================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */

public class TAdExposureActivity extends Activity {

    public static final String TAG_AD = "tag_ad_bean";
    private ActionWebView webView;
    private ProgressBar bar;
    private LinearLayout mainContent;
    private FrameLayout layoutTitle;
    private ImageView imBack;
    private TextView titleTv;
    private boolean isRedirected = false;
    private long start;
    private boolean isBackPage = true;
    //剪贴板内容
    String copyCode = "";
    //复制到剪切板的回调
    String copyCodeCallback = "";
    //网页title
    private String title = "";
    private static final String KEY_IS_FROM_VUID = "is_from_vuid";
    private static final String KEY_FROM_VUID_URL = "from_vuid_url";
    private AdsDTO adsDTO;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            setJsHelper();
            ActionWebView.setClient(new WebViewClient(this));
        } catch (Exception e) {
            e.printStackTrace();
        }
        setContentView(R.layout.tad_exposure_activity);
        bar = findViewById(R.id.pb_progress);
        mainContent = findViewById(R.id.main_content);
        layoutTitle = findViewById(R.id.layout_title);
        imBack = layoutTitle.findViewById(R.id.im_back);
        titleTv = layoutTitle.findViewById(R.id.tv_title);
        initWebView();

        Log.i("zxb_log", "onCreate --> initWebView 完成");
    }

    private void initWebView() {
        webView = findViewById(R.id.wv_webview);
        webView.getSettings().setJavaScriptEnabled(true);
        webView.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        webView.getSettings().setSupportZoom(true);
        webView.getSettings().setUseWideViewPort(true);
        webView.getSettings().setLoadWithOverviewMode(true);
        webView.getSettings().setDisplayZoomControls(true);
        webView.getSettings().setAppCacheEnabled(true);
        webView.getSettings().setDomStorageEnabled(true);
        WebViewManager.addJavaScriptInterface(this, webView);
        webView.setWebChromeClient(new WebChromeClient() {
            @Override
            public void onReceivedTitle(WebView view, String title) {
                super.onReceivedTitle(view, title);
                if (title == null || title.isEmpty() ||
                        view.getUrl() == null || view.getUrl().contains(title)) {
                    return;
                }
                TAdExposureActivity.this.title = title;
            }


            @Override
            public void onProgressChanged(WebView view, int newProgress) {
                if (newProgress == 100) {
                    bar.setVisibility(View.GONE);
                } else {
                    if (View.GONE == bar.getVisibility()) {
                        bar.setVisibility(View.VISIBLE);
                    }
                }
            }

            @Override
            public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
                if (BuildConfig.DEBUG && consoleMessage != null) {
                    AdLogUtil.Log().d("webview--", "WebViewInterface onConsoleMessage " + consoleMessage.message());
                }
                return super.onConsoleMessage(consoleMessage);
            }
        });


        if (getIntent() == null) {
            this.finish();
            return;
        }
        Serializable value = getIntent().getSerializableExtra(TAG_AD);
        adsDTO = value instanceof AdsDTO ? (AdsDTO)value : null;
        boolean isAdClick = getIntent().getBooleanExtra("isAdClick", false);

        boolean isFromVuid = getIntent().getBooleanExtra(KEY_IS_FROM_VUID, false);
        if (!isFromVuid) {
            if (adsDTO == null) {
                this.finish();
                return;
            }
        }
        start = System.currentTimeMillis();
        // 判断是 AdChoices 还是 Ad 点击事件
        if (isAdClick) {
            String url = adsDTO.getClickUrl();
            if (TextUtils.isEmpty(url)) return;
            //是gp地址，跳转到gp应用商店
            if (checkGpUrl(url)){
                return;
            }
            // 广告点击事件  --> url 埋点数据
            DownUpPointBean pointBean = (DownUpPointBean) getIntent().getSerializableExtra("pointBean");
            url = processServerClickUrl(pointBean, adsDTO);
            Map<String, String> map = new HashMap();
            map.put("Accept-Timezone", "UTC");

            try {
                setVuidInfo(url);
            } catch (Exception e) {
            }

            webView.loadUrl(url, map);
            AdLogUtil.Log().d("webview--", "TAdExposureActivity url == " + url);
        } else {
            if (isFromVuid) {
                String urlFromVuid = getIntent().getStringExtra(KEY_FROM_VUID_URL);
                if (urlFromVuid == null || urlFromVuid.isEmpty()) finish();
                try {
                    setVuidInfo(urlFromVuid);
                } catch (Exception e) {
                }
                webView.loadUrl(urlFromVuid);
            } else {
                webView.loadUrl(adsDTO.getAdChoiceClickUrl());
            }
        }
    }

    private void setVuidInfo(String url) {
        if (url == null || url.isEmpty()) return;

        if (layoutTitle != null && url.contains("isNativeHeader=true")) {
            layoutTitle.setVisibility(View.VISIBLE);
        } else {
            layoutTitle.setVisibility(View.GONE);
        }

        if (url.contains("isBackPage=false")) {
            isBackPage = false;
        }

        if (bar != null && url.contains("isNativeLoading=false")) {
            bar.setVisibility(View.GONE);
        } else {
            bar.setVisibility(View.VISIBLE);
        }

        imBack.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();
            }
        });

        try {
            VUID.Companion.setTokenRefreshListener(new INotifyTokenRefresh() {
                @Override
                public void onSuccess() {
                    ThreadUtils.runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            webView.loadUrl("javascript:tokenSuccess()");
                        }
                    });
                }

                @Override
                public void onError(int i, @androidx.annotation.Nullable String s) {
                }
            });
        } catch (Exception e) {
        }
    }

    /**
     * 复制剪切板
     */
    private void copyToClipboard(String code, String js) {
        try {
            copyCode = code;
            copyCodeCallback = js;
            ClipboardUtils.addChangedListener(listener);
            ClipboardUtils.copyText(code);
        } catch (Exception e) {
        }
    }

    //剪切板复制的回调
    ClipboardManager.OnPrimaryClipChangedListener listener = new ClipboardManager.OnPrimaryClipChangedListener() {
        @Override
        public void onPrimaryClipChanged() {
            try {
                if (!copyCode.isEmpty() && copyCode.equals(ClipboardUtils.getText())) {
                    if (copyCodeCallback != null && !copyCodeCallback.isEmpty() && webView != null) {
                        webView.loadUrl("javascript:" + copyCodeCallback + "()");
                    }
                }
                ClipboardUtils.removeChangedListener(this);
            } catch (Exception e) {
            }
        }
    };

    /**
     * 设置js回调
     */
    private void setJsHelper() {
        String jsName = "login";
        ActionWebView.setJsHelper(jsName, new ActionJsHelper() {
            @JavascriptInterface
            @Override
            public String getSystemInfo() {
                return "";
            }

            @JavascriptInterface
            @Override
            public void goBack() {
                ThreadUtils.runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        if (webView != null && isBackPage && webView.canGoBack()) {
                            webView.goBack();
                        } else {
                            finish();
                        }
                    }
                });
            }

            @JavascriptInterface
            public void copyCode(final String code, final String js) {
                ThreadUtils.runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        try {
                            copyToClipboard(code, js);
                        } catch (Exception e) {
                        }
                    }
                });
            }

            @JavascriptInterface
            public String getToken() {
                try {
                    return VUID.Companion.getVTokenFromMemory();
                } catch (Exception e) {
                    return "";
                }
            }

            @JavascriptInterface
            public void setStatusBarColor(final String colorValue) {
                ThreadUtils.runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        try {
                            int colorNum = Color.parseColor(colorValue);
                            boolean lightColor = MixUtilsKt.isLightColor(colorNum);
                            StatusBarUtil.INSTANCE.setStatusBarLightMode(TAdExposureActivity.this, lightColor);
                            StatusBarUtil.INSTANCE.setStatusBarColor(TAdExposureActivity.this.getWindow(), colorNum);
                        } catch (Exception e) {
                        }
                    }
                });
            }

            @JavascriptInterface
            public void openNewWebView(final String url) {
                if (url.isEmpty()) return;
                ThreadUtils.runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        launchWeb(TAdExposureActivity.this, url);
                    }
                });

            }

            @JavascriptInterface
            public void shareBySchemaUrl(final String url) {
                if (url.isEmpty()) return;
                ThreadUtils.runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        try {
                            MixUtilsKt.openSchemeUrl(TAdExposureActivity.this, url);
                        } catch (Exception e) {
                        }
                    }
                });
            }

            @JavascriptInterface
            public void getPageExposureInfo(String activityId, String activityName) {
                try {
                    VUID.Companion.getPageExposureInfo(activityId, activityName);
                } catch (Exception e) {
                }
            }

            @JavascriptInterface
            public void nativeDoTask(final int dumpUrlType, final String url) {
                ThreadUtils.runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        try {
                            jumpRouter(dumpUrlType, url);
                        } catch (Exception e) {
                        }
                    }
                });
            }
        });
    }

    private void jumpRouter(int type, String url) {
        try {
            if (type == 1) {
                launchWeb(TAdExposureActivity.this, url);
            } else if (type == 2) {
                try {
                    Intent intent = new Intent();
                    intent.setAction("android.intent.action.VIEW");
                    Uri content_url = Uri.parse(url);
                    intent.setData(content_url);
                    intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                    this.startActivity(intent);

                } catch (Exception e) {
                }
            } else if (type == 3) {
                MixUtilsKt.openSchemeUrl(TAdExposureActivity.this, url);
            }
        } catch (Exception e) {
        }

    }

    /**
     * 校验是否是gp地址
     * @param url
     * @return
     */
    private boolean checkGpUrl(String url){
        if (url.startsWith("https://play.google.com/store/apps/")) {
            url = url.replaceAll("https://play.google.com/store/apps/", "market://");
            startGp(url);
            return true;
        } else if (url.startsWith("market://")) {
            startGp(url);
            return true;
        }
        return false;
    }
    private void startGp(String url) {
        try {
            Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
            intent.setPackage("com.android.vending");
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            getContext().startActivity(intent);
            TAdExposureActivity.this.finish();
        } catch (Throwable e) {
        }
    }

    public boolean goToNext(String url) {
        Log.d("TAG", "webview get redirect url is:" + url);
        if (url != null && (!(url.startsWith("http:") || url.startsWith("https:")))) {
            try {
                //处理intent协议
                if (url.startsWith("intent://")) {
                    Intent intent;
                    intent = Intent.parseUri(url, Intent.URI_INTENT_SCHEME);
                    intent.addCategory("android.intent.category.BROWSABLE");
                    intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                    intent.setComponent(null);
                    intent.setSelector(null);
                    getContext().startActivity(intent);
                    TAdExposureActivity.this.finish();
                } else {
                    Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
                    intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                    getContext().startActivity(intent);
                    TAdExposureActivity.this.finish();
                }
            } catch (URISyntaxException e) {
                //pass
            } catch (Throwable e) {
                AdLogUtil.Log().e("No App to open receive the intent" + Log.getStackTraceString(e));
            }
            return true;
        } else {
            //webview重定向埋点埋点
            AthenaTracker.trackWebViewRedirect(adsDTO);
            //校验是否是gp地址，是gp地址，跳转到gp应用商店，return true。否则，return false，webview处理url
            return checkGpUrl(url);
        }
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK && webView != null && webView.canGoBack()) {
            webView.goBack();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    public void onBackPressed() {
        if (isBackPage && webView != null && webView.canGoBack()) {
            webView.goBack();
        } else {
            super.onBackPressed();
        }
    }

    @Override
    protected void onDestroy() {
        if (webView != null) {
            ViewParent parent = webView.getParent();
            if (parent != null) {
                ((ViewGroup) parent).removeView(webView);
            }
            webView.stopLoading();
            // 退出时调用此方法，移除绑定的服务，否则某些特定系统会报错
            webView.getSettings().setJavaScriptEnabled(false);
            // 取消监听引用
            webView.setWebChromeClient(null);
            webView.clearHistory();
            webView.removeAllViews();
            try {
                VUID.Companion.setTokenRefreshListener(null);
                webView.destroy();
            } catch (Exception e) {
            }
        }
        super.onDestroy();
    }

    /**
     * webview打开clickurl，处理clickurl
     *
     * @param pointBean
     * @param adsDTO
     * @return
     */
    private String processServerClickUrl(DownUpPointBean pointBean, AdsDTO adsDTO) {
        if (adsDTO == null || TextUtils.isEmpty(adsDTO.getClickUrl())) {
            AdLogUtil.Log().d(TRACK_TAG, "processServerClickUrl --> null == url || null == pointBean");
            return "";
        }

        //是eagllwin地址才需要上报参数给服务器
        if (pointBean == null || !TrackingManager.isEagllwinLink(adsDTO.getClickUrl())) {
            return adsDTO.getClickUrl();
        }

        AdLogUtil.Log().d(TRACK_TAG, "TrackingManager --> processUrl --> pointBean = " + pointBean.toString());
        return TrackingManager.processReportServerField(pointBean, adsDTO, true);
    }

    /**
     * 打开H5页面
     */
    public void launchWeb(Context context, String webUrl) {
        try {
            if (context == null || webUrl == null || webUrl.isEmpty()) return;

            VUID.Companion.getToken(context);

            Intent intent = new Intent(context, TAdExposureActivity.class);
            Bundle bundle = new Bundle();
            bundle.putBoolean(KEY_IS_FROM_VUID, true);
            bundle.putString(KEY_FROM_VUID_URL, webUrl);
            intent.putExtras(bundle);
            if (!(context instanceof Activity)) {
                intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            }
            context.startActivity(intent);
        } catch (Exception e) {
        }
    }

    public void trackWebViewComplete() {
        AdLogUtil.Log().d("webview--","TAdExposureActivity trackWebViewComplete time = " + (System.currentTimeMillis() - start));
        WebViewDataTracker.trackWebComplete(this, adsDTO);
    }

    class WebViewClient extends ActionWebViewClient {
        public WebViewClient(@androidx.annotation.Nullable Context context) {
            super(context);
        }

        @Nullable
        @Override
        public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                String urlStr = request.getUrl().toString();
                if (WebViewManager.checkAssetsExist(urlStr)) {
                    if (BuildConfig.DEBUG) {
                        AdLogUtil.Log().d("webview--","TAdExposureActivity checkAssetsExist true, url = " + urlStr);
                        AdLogUtil.Log().d("webview--","使用本地的JS资源");
                    }
                    return WebViewManager.onInterceptRequest(urlStr);
                }
                AdLogUtil.Log().d("webview--","使用网络的js资源 ----- url=="+urlStr);
            }

            return super.shouldInterceptRequest(view, request);
        }

        @Nullable
        @Override
        public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
            if (WebViewManager.checkAssetsExist(url)) {
                if (BuildConfig.DEBUG) {
                    AdLogUtil.Log().d("webview--","TAdExposureActivity checkAssetsExist true, url = " + url);
                }
                return WebViewManager.onInterceptRequest(url);
            }
            return super.shouldInterceptRequest(view, url);
        }

        /**
         * 多页面在同一个WebView中打开，就是不新建activity或者调用系统浏览器打开
         */
        @Override
        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            AdLogUtil.Log().d(TRACK_TAG, "shouldOverrideUrlLoading url=" + url);
            return goToNext(url);
        }

        @Override
        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {

            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                if (request != null && request.getUrl() != null) {
                    if (!TextUtils.isEmpty(request.getUrl().toString())) {
                        AdLogUtil.Log().d(AdLogUtil.TAG, "shouldOverrideUrlLoading url=" + request.getUrl().toString());
                        return goToNext(request.getUrl().toString());
                    }
                }
            }
            return false;
        }

        @Override
        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
            Log.i("zxb_log", "onPageStarted --> url=" + url);
        }

        @Override
        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            if (titleTv != null && !title.isEmpty()) {
                titleTv.setText(title);
            }
            if (webView.getProgress() == 100) {
                AdLogUtil.Log().d("webview--", "TAdExposureActivity onPageFinished time = " + " url=" + url);
                AdLogUtil.Log().d("webview--", "TAdExposureActivity onPageFinished time = " + (System.currentTimeMillis() - start) + " url=" + url);
            }
            Log.i("zxb_log", "onPageFinished: url=" + url);
            if (!isRedirected) {
                //  数据上报位置
                AdLogUtil.Log().d(AdLogUtil.TAG, "onPageFinished" + ":" + webView == null ? "" : webView.getUrl());
                if (bar != null && bar.getVisibility() != View.GONE) {
                    bar.setVisibility(View.GONE);
                }
            }
            isRedirected = false;
        }

        /**
         * # android7.0 https无法正常显示修复
         */
        @Override
        public void onReceivedSslError(WebView view, final SslErrorHandler handler, SslError error) {
            AdLogUtil.Log().d(AdLogUtil.TAG, "sslerror " + error.getPrimaryError());
            final AlertDialog.Builder builder = new AlertDialog.Builder(TAdExposureActivity.this);
            builder.setMessage(R.string.web_ssl_error);
            builder.setPositiveButton("continue", new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    if(handler != null){
                        handler.proceed();
                    }
                }
            });
            builder.setNegativeButton("cancel", new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    if(handler != null){
                        handler.cancel();
                    }
                    finish();
                }
            });
            final AlertDialog dialog = builder.create();
            dialog.show();
        }
    }
}

