package com.cloud.hisavana.sdk.common.athena;

import android.os.HandlerThread;

/**
 * athena上报新开一个线程
 */
public class AthenaUtil {
    private static volatile HandlerThread handlerThread;
    private static String threadName = "athena track thread";
    private static volatile boolean started = false;

    public static synchronized HandlerThread getHanderThread() {
        if (handlerThread == null) {
            synchronized (AthenaUtil.class) {
                if (handlerThread == null) {
                    handlerThread = new HandlerThread(threadName);
                }
            }
        }
        return handlerThread;
    }

    public static synchronized void start() {
        if (!started && handlerThread != null) {
            handlerThread.start();
            started = !started;
        }

    }

    public static synchronized void quit() {
        if (handlerThread != null) {
            handlerThread.quit();
        }
    }
}
