package com.cloud.hisavana.sdk.common.widget.config;

import android.content.Context;

import com.cloud.hisavana.sdk.BuildConfig;

public class Config {

    private static final String DEBUG_KEY = "com.cloud.hisavana.ad.sdk";
    private static final String RELEASE_KEY = DEBUG_KEY;

    private Config() {
    }

    public interface OnConfigCallback {
        void onCallback(ConfigData configData);
    }

    public static void init(Context context, final OnConfigCallback callback) {
        registerConfig();
        ConfigManager.getInstance().init(context, getConfigKey(), new ConfigManager.OnConfigCallback.ConfigCallbackImpl() {
            @Override
            public void onCallback(ConfigData configData) {
                if (callback != null) {
                    callback.onCallback(configData);
                }
            }
        });
    }

    /**
     * 在这个方法里注册config
     */
    private static void registerConfig() {
       // ConfigManager.getInstance().register("webview", TestConfig.class);
    }

    private static String getConfigKey() {
        if (BuildConfig.DEBUG) {
            return DEBUG_KEY;
        }
        return RELEASE_KEY;
    }
}
