package com.cloud.hisavana.sdk.common.widget.net;

import android.text.TextUtils;

import com.transsion.http.HttpClient;
import com.transsion.http.RequestCall;
import com.transsion.http.builder.PostJsonBuilder;
import com.transsion.http.impl.StringCallback;

import org.json.JSONObject;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HttpRequest {

    public void post(String urlPath, Map<String, String> headers, JSONObject paramsObj, final HttpManager.OnRequestCallback callback) {
        String jsonString = paramsObj.toString();
        PostJsonBuilder postJsonBuilder = HttpClient.postJson()  //必须方法体
                .log(true)
                .sslSocketFactory(null)  //Tan 需要私有证书校验,Adx不需要
                .content(jsonString) //必须方法体，上传的String类型的数据文本，目前只提供上传String接口
                .connectTimeout(15 * 1000)   //网络连接超时时间，单位毫秒，非必须默认10s
                .readTimeout(15 * 1000)      //读取数据超时时间，单位毫秒，非必须默认10s
                .url(urlPath);
        postJsonBuilder.addHeader("x-tr-devtype", "h5");
        if (headers != null && !headers.isEmpty()) {
            Iterator<Map.Entry<String, String>> headerIterator = headers.entrySet().iterator();
            while (headerIterator.hasNext()) {
                Map.Entry<String, String> entry = headerIterator.next();
                if (entry == null || TextUtils.isEmpty(entry.getKey()) || TextUtils.isEmpty(entry.getValue())) {
                    continue;
                }
                postJsonBuilder.addHeader(entry.getKey(), entry.getValue());
            }
        }
        RequestCall call = postJsonBuilder.build();
        call.execute(new StringCallback(true) {
                         @Override
                         public void onSuccess(final int statusCode, String response) {
                             if (callback != null) {
                                 callback.onSuccess(response);
                             }
                         }

                         @Override
                         public void onResponseHeader(Map<String, List<String>> map) {

                         }

                         @Override
                         public void onFailure(int statusCode, String response, Throwable throwable) {
                             if (callback != null) {
                                 callback.onFail(statusCode, TextUtils.isEmpty(response) ? throwable.getMessage() : response);
                             }
                         }
                     }
        );
    }
}
